@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.serviceworker

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.target.TargetID

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#type-RegistrationID)
 */
public typealias RegistrationID = String

/**
 * ServiceWorker registration.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#type-ServiceWorkerRegistration)
 */
@Serializable
public data class ServiceWorkerRegistration(
  public val registrationId: RegistrationID,
  public val scopeURL: String,
  public val isDeleted: Boolean,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#type-ServiceWorkerVersionRunningStatus)
 */
@Serializable
public enum class ServiceWorkerVersionRunningStatus {
  stopped,
  starting,
  running,
  stopping,
}

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#type-ServiceWorkerVersionStatus)
 */
@Serializable
public enum class ServiceWorkerVersionStatus {
  new,
  installing,
  installed,
  activating,
  activated,
  redundant,
}

/**
 * ServiceWorker version.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#type-ServiceWorkerVersion)
 */
@Serializable
public data class ServiceWorkerVersion(
  public val versionId: String,
  public val registrationId: RegistrationID,
  public val scriptURL: String,
  public val runningStatus: ServiceWorkerVersionRunningStatus,
  public val status: ServiceWorkerVersionStatus,
  /**
   * The Last-Modified header value of the main script.
   */
  public val scriptLastModified: Double? = null,
  /**
   * The time at which the response headers of the main script were received from the server.
   * For cached script it is the last time the cache entry was validated.
   */
  public val scriptResponseTime: Double? = null,
  public val controlledClients: List<TargetID>? = null,
  public val targetId: TargetID? = null,
)

/**
 * ServiceWorker error message.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#type-ServiceWorkerErrorMessage)
 */
@Serializable
public data class ServiceWorkerErrorMessage(
  public val errorMessage: String,
  public val registrationId: RegistrationID,
  public val versionId: String,
  public val sourceURL: String,
  public val lineNumber: Int,
  public val columnNumber: Int,
)
