@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.serviceworker.events

import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerErrorMessage
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerRegistration
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerVersion

@Serializable
public sealed class ServiceWorkerEvent {
  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerErrorReported)
   */
  @Serializable
  public data class WorkerErrorReported(
    public val errorMessage: ServiceWorkerErrorMessage,
  ) : ServiceWorkerEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerRegistrationUpdated)
   */
  @Serializable
  public data class WorkerRegistrationUpdated(
    public val registrations: List<ServiceWorkerRegistration>,
  ) : ServiceWorkerEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerVersionUpdated)
   */
  @Serializable
  public data class WorkerVersionUpdated(
    public val versions: List<ServiceWorkerVersion>,
  ) : ServiceWorkerEvent()
}
