@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.target

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.browser.BrowserContextID
import org.hildan.chrome.devtools.domains.page.FrameId
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Target/#type-TargetID)
 */
public typealias TargetID = String

/**
 * Unique identifier of attached debugging session.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Target/#type-SessionID)
 */
public typealias SessionID = String

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Target/#type-TargetInfo)
 */
@Serializable
public data class TargetInfo(
  public val targetId: TargetID,
  public val type: String,
  public val title: String,
  public val url: String,
  /**
   * Whether the target has an attached client.
   */
  public val attached: Boolean,
  /**
   * Opener target Id
   */
  public val openerId: TargetID? = null,
  /**
   * Whether the target has access to the originating window.
   */
  @ExperimentalChromeApi
  public val canAccessOpener: Boolean? = null,
  /**
   * Frame id of originating window (is only set if target has an opener).
   */
  @ExperimentalChromeApi
  public val openerFrameId: FrameId? = null,
  @ExperimentalChromeApi
  public val browserContextId: BrowserContextID? = null,
  /**
   * Provides additional details for specific target types. For example, for
   * the type of "page", this may be set to "portal" or "prerender".
   */
  @ExperimentalChromeApi
  public val subtype: String? = null,
)

/**
 * A filter used by target query/discovery/auto-attach operations.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Target/#type-FilterEntry)
 */
@ExperimentalChromeApi
@Serializable
public data class FilterEntry(
  /**
   * If set, causes exclusion of mathcing targets from the list.
   */
  public val exclude: Boolean? = null,
  /**
   * If not present, matches any type.
   */
  public val type: String? = null,
)

/**
 * The entries in TargetFilter are matched sequentially against targets and
 * the first entry that matches determines if the target is included or not,
 * depending on the value of `exclude` field in the entry.
 * If filter is not specified, the one assumed is
 * [{type: "browser", exclude: true}, {type: "tab", exclude: true}, {}]
 * (i.e. include everything but `browser` and `tab`).
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Target/#type-TargetFilter)
 */
@ExperimentalChromeApi
public typealias TargetFilter = List<FilterEntry>

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Target/#type-RemoteLocation)
 */
@ExperimentalChromeApi
@Serializable
public data class RemoteLocation(
  public val host: String,
  public val port: Int,
)
