/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.hildan.hashcode.utils.reader.HCReaderKt;
import org.hildan.hashcode.utils.reader.IncompleteInputReadException;
import org.hildan.hashcode.utils.reader.IncompleteLineReadException;
import org.hildan.hashcode.utils.reader.InputParsingException;
import org.hildan.hashcode.utils.reader.NoMoreLinesToReadException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\bJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\b\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0015J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010 \u001a\u00020\bJ\b\u0010!\u001a\u00020\bH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u0010\u0010#\u001a\u00020\u00122\b\b\u0002\u0010$\u001a\u00020\fJ\u0012\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\n*\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/hildan/hashcode/utils/reader/HCReader;", "Ljava/io/Closeable;", "reader", "Ljava/io/Reader;", "tokenDelimiter", "Lkotlin/text/Regex;", "(Ljava/io/Reader;Lkotlin/text/Regex;)V", "currentLineText", "", "currentLineTokens", "", "lineNumber", "", "getLineNumber", "()I", "nextTokenIndex", "Ljava/io/LineNumberReader;", "close", "", "fetchNextLine", "hasMoreTokensInCurrentLine", "", "nextLineText", "nextLineTokens", "nextToken", "parseError", "", "msg", "readBoolean", "readDouble", "", "readInt", "readString", "remainingInputOnCurrentLine", "remainingTokensOnCurrentLine", "skip", "n", "tokenize", "hashcode-utils-kt"})
public final class HCReader
implements Closeable {
    private final LineNumberReader reader;
    private String currentLineText;
    private List<String> currentLineTokens;
    private int nextTokenIndex;
    private final Regex tokenDelimiter;

    public final int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public final void skip(int n) {
        if (n < 0) {
            throw (Throwable)new IllegalArgumentException("The number of elements to skip cannot be negative");
        }
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            this.nextToken();
        }
    }

    public static /* synthetic */ void skip$default(HCReader hCReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        hCReader.skip(n);
    }

    @NotNull
    public final String readString() {
        return this.nextToken();
    }

    public final int readInt() {
        String string = this.nextToken();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            Void void_ = this.parseError("expected integer, got '" + it + '\'');
            throw new KotlinNothingValueException();
        }
        return n;
    }

    public final double readDouble() {
        String string = this.nextToken();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        Double d = StringsKt.toDoubleOrNull((String)it);
        if (d == null) {
            Void void_ = this.parseError("expected double, got '" + it + '\'');
            throw new KotlinNothingValueException();
        }
        return d;
    }

    public final boolean readBoolean() {
        boolean bl;
        String string = this.nextToken();
        boolean bl2 = false;
        boolean bl3 = false;
        String it = string;
        boolean bl4 = false;
        if (StringsKt.equals((String)it, (String)"true", (boolean)true)) {
            bl = true;
        } else if (StringsKt.equals((String)it, (String)"false", (boolean)true)) {
            bl = false;
        } else {
            Void void_ = this.parseError("expected boolean, got '" + it + '\'');
            throw new KotlinNothingValueException();
        }
        return bl;
    }

    @NotNull
    public final String nextLineText() {
        this.fetchNextLine();
        this.nextTokenIndex = this.currentLineTokens.size();
        return this.currentLineText;
    }

    @NotNull
    public final List<String> nextLineTokens() {
        this.fetchNextLine();
        this.nextTokenIndex = this.currentLineTokens.size();
        return this.currentLineTokens;
    }

    private final String nextToken() {
        while (!this.hasMoreTokensInCurrentLine()) {
            this.fetchNextLine();
        }
        int n = this.nextTokenIndex;
        this.nextTokenIndex = n + 1;
        return this.currentLineTokens.get(n);
    }

    private final boolean hasMoreTokensInCurrentLine() {
        return this.nextTokenIndex < this.currentLineTokens.size();
    }

    private final void fetchNextLine() {
        try {
            if (this.hasMoreTokensInCurrentLine()) {
                throw (Throwable)new IncompleteLineReadException(this.getLineNumber(), this.remainingInputOnCurrentLine());
            }
            String string = this.reader.readLine();
            if (string == null) {
                throw (Throwable)new NoMoreLinesToReadException();
            }
            String nextLine = string;
            this.currentLineTokens = this.tokenize(nextLine);
            this.currentLineText = nextLine;
            this.nextTokenIndex = 0;
        }
        catch (IOException e) {
            throw (Throwable)new InputParsingException("An error occurred while reading the input line " + this.getLineNumber(), e);
        }
    }

    private final String remainingInputOnCurrentLine() {
        return CollectionsKt.joinToString$default((Iterable)this.remainingTokensOnCurrentLine(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final List<String> remainingTokensOnCurrentLine() {
        return CollectionsKt.slice(this.currentLineTokens, (IntRange)RangesKt.until((int)this.nextTokenIndex, (int)this.currentLineTokens.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block10: {
            try {
                String string;
                Object object = this.reader;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    LineNumberReader it = (LineNumberReader)object;
                    boolean bl3 = false;
                    string = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                String remainingText = string;
                if (!this.hasMoreTokensInCurrentLine()) {
                    object = this.tokenize(remainingText);
                    bl = false;
                    if (!(!object.isEmpty())) break block10;
                }
                throw (Throwable)new IncompleteInputReadException(this.getLineNumber(), this.nextTokenIndex);
            }
            catch (IOException e) {
                throw (Throwable)new InputParsingException("An error occurred while consuming the end of the input", e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tokenize(String $this$tokenize) {
        void $this$filterTo$iv$iv;
        CharSequence charSequence = $this$tokenize;
        Regex regex = this.tokenDelimiter;
        int n = 0;
        boolean bl = false;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence2 = it;
            boolean bl3 = false;
            if (!(charSequence2.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Void parseError(String msg) {
        throw (Throwable)new InputParsingException(this.getLineNumber(), this.nextTokenIndex, msg);
    }

    /*
     * WARNING - void declaration
     */
    public HCReader(@NotNull Reader reader, @NotNull Regex tokenDelimiter) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)tokenDelimiter, (String)"tokenDelimiter");
        this.tokenDelimiter = tokenDelimiter;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        boolean bl = false;
        boolean bl2 = false;
        LineNumberReader lineNumberReader2 = lineNumberReader;
        HCReader hCReader = this;
        boolean bl3 = false;
        $this$apply.setLineNumber(0);
        Unit unit = Unit.INSTANCE;
        hCReader.reader = lineNumberReader;
        this.currentLineText = "";
        this.currentLineTokens = CollectionsKt.emptyList();
    }

    public /* synthetic */ HCReader(Reader reader, Regex regex, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            regex = HCReaderKt.getDEFAULT_HASHCODE_INPUT_DELIMITER();
        }
        this(reader, regex);
    }
}

