/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.hildan.hashcode.utils.parser.config.Config;
import org.hildan.hashcode.utils.parser.context.Context;
import org.hildan.hashcode.utils.parser.readers.ObjectReader;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;

public class HCParser<T> {
    private final Config config;
    private final ObjectReader<T> rootReader;

    public HCParser(@NotNull ObjectReader<T> rootReader) {
        this(rootReader, new Config());
    }

    public HCParser(@NotNull ObjectReader<T> rootReader, @RegExp String separator) {
        this.config = new Config(separator);
        this.rootReader = rootReader;
    }

    public HCParser(@NotNull ObjectReader<T> rootReader, Config config) {
        this.config = config;
        this.rootReader = rootReader;
    }

    public T parseFile(String filename) throws FileNotFoundException {
        return this.parse(new FileReader(filename));
    }

    public T parse(String content) {
        return this.parse(new StringReader(content));
    }

    public T parse(Reader inputReader) {
        return this.parse(new Context(inputReader, this.config));
    }

    public T parse(Context context) {
        T result = this.rootReader.read(context);
        context.closeReader();
        return result;
    }
}

