/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.context;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.hildan.hashcode.utils.parser.InputParsingException;
import org.hildan.hashcode.utils.parser.config.Config;
import org.hildan.hashcode.utils.parser.context.LineNumberScanner;
import org.hildan.hashcode.utils.parser.context.NoMoreLinesToReadException;
import org.hildan.hashcode.utils.parser.context.UndefinedVariableException;
import org.jetbrains.annotations.NotNull;

public class Context {
    private final Map<String, String> variables = new HashMap<String, String>();
    private final LineNumberScanner scanner;

    public Context(Reader reader, Config config) {
        this.scanner = new LineNumberScanner(reader, config.getSeparator());
    }

    public void skip(int n) throws InputParsingException {
        if (n < 0) {
            throw new IllegalArgumentException("The number of elements to skip cannot be negative");
        }
        IntStream.range(0, n).forEach(i -> this.scanner.nextString());
    }

    @NotNull
    public String readString() throws NoMoreLinesToReadException {
        return this.scanner.nextString();
    }

    public int readInt() throws InputParsingException {
        return this.scanner.nextInt();
    }

    public double readDouble() throws InputParsingException {
        return this.scanner.nextDouble();
    }

    public String[] readLine() throws InputParsingException {
        return this.scanner.nextLineTokens();
    }

    @NotNull
    public String readIntoVariable(String variableName) throws NoMoreLinesToReadException {
        String value = this.scanner.nextString();
        this.setVariable(variableName, value);
        return value;
    }

    public void closeReader() {
        this.scanner.close();
    }

    public InputParsingException wrapException(String message, Exception cause) {
        return new InputParsingException(this.scanner.getLineNumber(), this.scanner.getCurrentLine(), message, cause);
    }

    public String getVariable(String key) throws UndefinedVariableException {
        String value = this.variables.get(key);
        if (value == null) {
            throw new UndefinedVariableException(key);
        }
        return value;
    }

    public int getVariableAsInt(String key) throws InputParsingException {
        String size = this.getVariable(key);
        try {
            return Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            throw new InputParsingException("Variable '" + key + "' cannot be converted into an int", e);
        }
    }

    public void setVariable(String key, String value) {
        this.variables.put(key, value);
    }
}

