/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.context;

import java.io.Closeable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Arrays;
import org.hildan.hashcode.utils.parser.InputParsingException;
import org.hildan.hashcode.utils.parser.context.IncompleteInputReadException;
import org.hildan.hashcode.utils.parser.context.IncompleteLineReadException;
import org.hildan.hashcode.utils.parser.context.NoMoreLinesToReadException;
import org.jetbrains.annotations.Nullable;

public class LineNumberScanner
implements Closeable,
AutoCloseable {
    private final LineNumberReader reader;
    private final String delimiter;
    private String currentLineRaw;
    private String[] currentLine;
    private int nextTokenIndex;

    public LineNumberScanner(Reader reader, String delimiter) {
        this.reader = new LineNumberReader(reader);
        this.reader.setLineNumber(0);
        this.delimiter = delimiter;
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    @Nullable
    public String getCurrentLine() {
        return this.currentLineRaw;
    }

    public String nextString() throws InputParsingException {
        while (!this.hasMoreTokenInCurrentLine()) {
            this.fetchNextLine();
        }
        return this.currentLine[this.nextTokenIndex++];
    }

    public int nextInt() throws InputParsingException {
        String value = this.nextString();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InputParsingException(this.getLineNumber(), "expected int, got '" + value + "'", e);
        }
    }

    public double nextDouble() throws InputParsingException {
        String value = this.nextString();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new InputParsingException(this.getLineNumber(), "expected double, got '" + value + "'", e);
        }
    }

    public String nextLine() throws InputParsingException {
        this.fetchNextLine();
        this.nextTokenIndex = this.currentLine.length;
        return this.currentLineRaw;
    }

    public String[] nextLineTokens() throws InputParsingException {
        this.fetchNextLine();
        this.nextTokenIndex = this.currentLine.length;
        return this.currentLine;
    }

    private boolean hasMoreTokenInCurrentLine() {
        return this.currentLine != null && this.nextTokenIndex < this.currentLine.length;
    }

    private void fetchNextLine() throws InputParsingException {
        try {
            if (this.hasMoreTokenInCurrentLine()) {
                throw new IncompleteLineReadException(this.getLineNumber(), this.remainingInputOnCurrentLine());
            }
            this.currentLineRaw = this.reader.readLine();
            if (this.currentLineRaw == null) {
                throw new NoMoreLinesToReadException();
            }
            this.currentLine = this.currentLineRaw.isEmpty() ? new String[]{} : this.currentLineRaw.split(this.delimiter, -1);
            this.nextTokenIndex = 0;
        }
        catch (IOException e) {
            throw new InputParsingException("An error occurred while reading the input", e);
        }
    }

    private String remainingInputOnCurrentLine() {
        return String.join((CharSequence)" ", this.remainingTokens());
    }

    private String[] remainingTokens() {
        return Arrays.copyOfRange(this.currentLine, this.nextTokenIndex, this.currentLine.length);
    }

    @Override
    public void close() {
        try {
            int nbLinesLeft = this.consumeAndCountRemainingLines();
            if (nbLinesLeft > 0) {
                throw new IncompleteInputReadException(nbLinesLeft);
            }
        }
        catch (IOException e) {
            throw new InputParsingException("An error occurred while consuming the end of the input", e);
        }
        finally {
            this.safeClose();
        }
    }

    private int consumeAndCountRemainingLines() throws IOException {
        String line;
        int nbLinesLeft = 0;
        while ((line = this.reader.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            ++nbLinesLeft;
        }
        return nbLinesLeft;
    }

    private void safeClose() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

