/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.readers;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.hildan.hashcode.utils.parser.context.Context;
import org.hildan.hashcode.utils.parser.readers.ObjectReader;
import org.hildan.hashcode.utils.parser.readers.constructors.Int2Constructor;
import org.hildan.hashcode.utils.parser.readers.constructors.Int3Constructor;
import org.hildan.hashcode.utils.parser.readers.constructors.Int4Constructor;
import org.hildan.hashcode.utils.parser.readers.constructors.Int5Constructor;
import org.hildan.hashcode.utils.parser.readers.constructors.Int6Constructor;
import org.hildan.hashcode.utils.parser.readers.constructors.Int7Constructor;
import org.hildan.hashcode.utils.parser.readers.constructors.IntArrayConstructor;
import org.hildan.hashcode.utils.parser.readers.variable.VariableReader;

public class HCReader {
    public static <T> ObjectReader<T> create(Supplier<? extends T> constructor) {
        return ctx -> constructor.get();
    }

    public static <T> ObjectReader<T> createFromInt(Function<Integer, ? extends T> constructor) {
        return ctx -> constructor.apply(ctx.readInt());
    }

    public static <T> ObjectReader<T> createFrom2Ints(Int2Constructor<T> constructor) {
        return constructor;
    }

    public static <T> ObjectReader<T> createFrom3Ints(Int3Constructor<T> constructor) {
        return constructor;
    }

    public static <T> ObjectReader<T> createFrom4Ints(Int4Constructor<T> constructor) {
        return constructor;
    }

    public static <T> ObjectReader<T> createFrom5Ints(Int5Constructor<T> constructor) {
        return constructor;
    }

    public static <T> ObjectReader<T> createFrom6Ints(Int6Constructor<T> constructor) {
        return constructor;
    }

    public static <T> ObjectReader<T> createFrom7Ints(Int7Constructor<T> constructor) {
        return constructor;
    }

    public static <T> ObjectReader<T> createFromInts(IntArrayConstructor<T> constructor, int nbIntsToRead) {
        if (nbIntsToRead <= 0) {
            throw new IllegalArgumentException("nbIntsToRead must be positive");
        }
        return ctx -> {
            int[] params = IntStream.range(0, nbIntsToRead).map(i -> ctx.readInt()).toArray();
            return constructor.create(params);
        };
    }

    public static WithVars withVars(String ... variableNames) {
        return new WithVars(variableNames);
    }

    public static class WithVars {
        private final Consumer<Context> variableReader;

        WithVars(String ... variableNames) {
            this.variableReader = new VariableReader(variableNames);
        }

        public <T> ObjectReader<T> of(Function<Context, T> constructor) {
            return ctx -> {
                this.variableReader.accept(ctx);
                return constructor.apply(ctx);
            };
        }

        public <T> ObjectReader<T> createFromVar(Function<Integer, T> constructor, String varName) {
            return this.of(ctx -> constructor.apply(ctx.getVariableAsInt(varName)));
        }

        public <T> ObjectReader<T> createFrom2Vars(Int2Constructor<T> constructor, String var1, String var2) {
            return this.of(ctx -> constructor.create(ctx.getVariableAsInt(var1), ctx.getVariableAsInt(var2)));
        }

        public <T> ObjectReader<T> createFrom3Vars(Int3Constructor<T> constructor, String var1, String var2, String var3) {
            return this.of(ctx -> constructor.create(ctx.getVariableAsInt(var1), ctx.getVariableAsInt(var2), ctx.getVariableAsInt(var3)));
        }

        public <T> ObjectReader<T> createFrom4Vars(Int4Constructor<T> constructor, String var1, String var2, String var3, String var4) {
            return this.of(ctx -> constructor.create(ctx.getVariableAsInt(var1), ctx.getVariableAsInt(var2), ctx.getVariableAsInt(var3), ctx.getVariableAsInt(var4)));
        }

        public <T> ObjectReader<T> createFrom5Vars(Int5Constructor<T> constructor, String var1, String var2, String var3, String var4, String var5) {
            return this.of(ctx -> constructor.create(ctx.getVariableAsInt(var1), ctx.getVariableAsInt(var2), ctx.getVariableAsInt(var3), ctx.getVariableAsInt(var4), ctx.getVariableAsInt(var5)));
        }

        public <T> ObjectReader<T> createFrom6Vars(Int6Constructor<T> constructor, String var1, String var2, String var3, String var4, String var5, String var6) {
            return this.of(ctx -> constructor.create(ctx.getVariableAsInt(var1), ctx.getVariableAsInt(var2), ctx.getVariableAsInt(var3), ctx.getVariableAsInt(var4), ctx.getVariableAsInt(var5), ctx.getVariableAsInt(var6)));
        }

        public <T> ObjectReader<T> createFrom7Vars(Int7Constructor<T> constructor, String var1, String var2, String var3, String var4, String var5, String var6, String var7) {
            return this.of(ctx -> constructor.create(ctx.getVariableAsInt(var1), ctx.getVariableAsInt(var2), ctx.getVariableAsInt(var3), ctx.getVariableAsInt(var4), ctx.getVariableAsInt(var5), ctx.getVariableAsInt(var6), ctx.getVariableAsInt(var7)));
        }

        public <T> ObjectReader<T> createFromVars(IntArrayConstructor<T> constructor, String ... vars) {
            return this.of(ctx -> {
                int[] params = Arrays.stream(vars).mapToInt(ctx::getVariableAsInt).toArray();
                return constructor.create(params);
            });
        }
    }
}

