/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.readers;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import org.hildan.hashcode.utils.parser.InputParsingException;
import org.hildan.hashcode.utils.parser.context.Context;
import org.hildan.hashcode.utils.parser.readers.ChildReader;
import org.hildan.hashcode.utils.parser.readers.line.LineReader;
import org.hildan.hashcode.utils.parser.readers.section.FieldAndVarReader;
import org.hildan.hashcode.utils.parser.readers.section.FieldsAndVarsReader;
import org.hildan.hashcode.utils.parser.readers.section.SectionReader;
import org.hildan.hashcode.utils.parser.readers.variable.VariableReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ObjectReader<T>
extends ChildReader<T, Object>,
Function<Context, T> {
    @Nullable
    public T read(@NotNull Context var1) throws InputParsingException;

    @Override
    @Nullable
    default public T read(@NotNull Context context, @Nullable Object parent) throws InputParsingException {
        return this.read(context);
    }

    @Override
    default public T apply(Context context) throws InputParsingException {
        return this.read(context);
    }

    default public ObjectReader<T> then(SectionReader<? super T> sectionReader) {
        return ctx -> {
            T obj = this.read(ctx);
            sectionReader.readAndSet(ctx, (T)obj);
            return obj;
        };
    }

    default public ObjectReader<T> then(Consumer<Context> consumer) {
        return ctx -> {
            T obj = this.read(ctx);
            consumer.accept(ctx);
            return obj;
        };
    }

    default public ObjectReader<T> thenSkip(int n) {
        return this.then((Context ctx) -> ctx.skip(n));
    }

    default public ObjectReader<T> thenVar(String variableName) {
        return this.thenVars(variableName);
    }

    default public ObjectReader<T> thenVars(String ... variableNames) {
        return this.then(new VariableReader(variableNames));
    }

    default public ObjectReader<T> thenField(String fieldName) {
        return this.then(new FieldAndVarReader(fieldName, null));
    }

    default public ObjectReader<T> thenFields(String ... fieldNames) {
        if (Arrays.stream(fieldNames).anyMatch(s -> s.contains("@"))) {
            throw new IllegalArgumentException("Some field names contain the illegal character '@'");
        }
        return this.thenFieldsAndVars(fieldNames);
    }

    default public ObjectReader<T> thenFieldAndVar(String fieldName, String variableName) {
        return this.then(new FieldAndVarReader(fieldName, variableName));
    }

    default public ObjectReader<T> thenFieldsAndVars(String ... fieldAndVarNames) {
        return this.then(new FieldsAndVarsReader(fieldAndVarNames));
    }

    default public <V> ObjectReader<T> thenObject(BiConsumer<? super T, ? super V> setter, Function<? super String, V> converter) {
        return this.then(SectionReader.settingObject(setter, converter));
    }

    default public ObjectReader<T> thenInt(ObjIntConsumer<? super T> setter) {
        return this.then(SectionReader.settingInt(setter));
    }

    default public ObjectReader<T> thenDouble(ObjDoubleConsumer<? super T> setter) {
        return this.then(SectionReader.settingDouble(setter));
    }

    default public ObjectReader<T> thenString(BiConsumer<? super T, ? super String> setter) {
        return this.then(SectionReader.settingString(setter));
    }

    default public ObjectReader<T> thenIntArrayLine(BiConsumer<? super T, int[]> setter) {
        return this.then(SectionReader.settingChild(setter, LineReader.ofIntArray()));
    }

    default public ObjectReader<T> thenLongArrayLine(BiConsumer<? super T, long[]> setter) {
        return this.then(SectionReader.settingChild(setter, LineReader.ofLongArray()));
    }

    default public ObjectReader<T> thenDoubleArrayLine(BiConsumer<? super T, double[]> setter) {
        return this.then(SectionReader.settingChild(setter, LineReader.ofDoubleArray()));
    }

    default public ObjectReader<T> thenStringArrayLine(BiConsumer<? super T, String[]> setter) {
        return this.then(SectionReader.settingChild(setter, LineReader.ofStringArray()));
    }

    default public <E> ObjectReader<T> thenArrayLine(BiConsumer<? super T, ? super E[]> setter, IntFunction<E[]> arrayCreator, Function<? super String, ? extends E> itemConverter) {
        return this.then(SectionReader.settingChild(setter, LineReader.ofArray(arrayCreator, itemConverter)));
    }

    default public <E> ObjectReader<T> thenListLine(BiConsumer<? super T, ? super List<E>> setter, Function<String, ? extends E> itemConverter) {
        return this.then(SectionReader.settingChild(setter, LineReader.ofList(itemConverter)));
    }

    default public <E> ObjectReader<T> thenArray(BiConsumer<? super T, ? super E[]> setter, IntFunction<E[]> arrayCreator, String sizeVariable, ChildReader<? extends E, ? super T> itemReader) {
        return this.then(SectionReader.settingArray(setter, arrayCreator, (p, c) -> c.getVariableAsInt(sizeVariable), itemReader));
    }

    default public <E> ObjectReader<T> thenArray(BiConsumer<? super T, ? super E[]> setter, IntFunction<E[]> arrayCreator, Function<? super T, Integer> getSize, ChildReader<? extends E, ? super T> itemReader) {
        return this.then(SectionReader.settingArray(setter, arrayCreator, (p, c) -> (Integer)getSize.apply(p), itemReader));
    }

    default public <E> ObjectReader<T> thenArray(BiConsumer<? super T, ? super E[]> setter, IntFunction<E[]> arrayCreator, BiFunction<? super T, Context, Integer> getSize, ChildReader<? extends E, ? super T> itemReader) {
        return this.then(SectionReader.settingArray(setter, arrayCreator, getSize, itemReader));
    }

    default public <E> ObjectReader<T> thenList(BiConsumer<? super T, ? super List<E>> setter, String sizeVariable, ChildReader<? extends E, ? super T> itemReader) {
        return this.then(SectionReader.settingList(setter, (p, c) -> c.getVariableAsInt(sizeVariable), itemReader));
    }

    default public <E> ObjectReader<T> thenList(BiConsumer<? super T, ? super List<E>> setter, Function<? super T, Integer> getSize, ChildReader<? extends E, ? super T> itemReader) {
        return this.then(SectionReader.settingList(setter, (p, c) -> (Integer)getSize.apply(p), itemReader));
    }

    default public <E> ObjectReader<T> thenList(BiConsumer<? super T, ? super List<E>> setter, BiFunction<? super T, Context, Integer> getSize, ChildReader<? extends E, ? super T> itemReader) {
        return this.then(SectionReader.settingList(setter, getSize, itemReader));
    }

    default public <C> ObjectReader<T> thenChild(BiConsumer<? super T, ? super C> setter, ChildReader<C, ? super T> childReader) {
        return this.then(SectionReader.settingChild(setter, childReader));
    }
}

