/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.readers.container;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import org.hildan.hashcode.utils.parser.InputParsingException;
import org.hildan.hashcode.utils.parser.context.Context;
import org.hildan.hashcode.utils.parser.readers.ChildReader;
import org.hildan.hashcode.utils.parser.readers.container.AddFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerReader<E, C, P>
implements ChildReader<C, P> {
    private final IntFunction<? extends C> constructor;
    private final ChildReader<? extends E, ? super P> itemReader;
    private final BiFunction<? super P, Context, Integer> getSize;
    private final AddFunction<? super E, ? super C> addFunction;

    protected ContainerReader(BiFunction<? super P, Context, Integer> getSize, ChildReader<? extends E, ? super P> itemReader, IntFunction<? extends C> constructor, AddFunction<? super E, ? super C> addFunction) {
        this.constructor = constructor;
        this.itemReader = itemReader;
        this.getSize = getSize;
        this.addFunction = addFunction;
    }

    @Override
    public C read(@NotNull Context context, @Nullable P parent) throws InputParsingException {
        int size = this.getSize.apply(parent, context);
        C collection = this.constructor.apply(size);
        for (int i = 0; i < size; ++i) {
            this.addFunction.apply(collection, i, this.itemReader.read(context, parent));
        }
        return collection;
    }

    public static <E, C, P> ChildReader<C, P> of(BiFunction<? super P, Context, Integer> getSize, ChildReader<? extends E, ? super P> itemReader, IntFunction<? extends C> constructor, AddFunction<? super E, ? super C> addFunction) {
        return new ContainerReader<E, C, P>(getSize, itemReader, constructor, addFunction);
    }

    public static <E, P> ChildReader<E[], P> ofArray(BiFunction<? super P, Context, Integer> getSize, ChildReader<? extends E, ? super P> itemReader, IntFunction<E[]> arrayCreator) {
        return new ContainerReader<Object, Object[], P>(getSize, itemReader, arrayCreator, Array::set);
    }

    public static <E, P> ChildReader<List<E>, P> ofList(BiFunction<? super P, Context, Integer> getSize, ChildReader<? extends E, ? super P> itemReader) {
        return ContainerReader.ofCollection(getSize, itemReader, ArrayList::new);
    }

    public static <E, C extends Collection<E>, P> ChildReader<C, P> ofCollection(BiFunction<? super P, Context, Integer> getSize, ChildReader<? extends E, ? super P> itemReader, IntFunction<C> constructor) {
        return new ContainerReader<Object, Collection, P>(getSize, itemReader, constructor, (c, i, e) -> c.add(e));
    }
}

