/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.readers.line;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.hildan.hashcode.utils.parser.InputParsingException;
import org.hildan.hashcode.utils.parser.context.Context;
import org.hildan.hashcode.utils.parser.readers.ChildReader;
import org.hildan.hashcode.utils.parser.readers.ObjectReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineReader<T, P>
implements ChildReader<T, P> {
    private final BiFunction<? super String[], P, T> lineConverter;

    protected LineReader(BiFunction<? super String[], P, T> lineConverter) {
        this.lineConverter = lineConverter;
    }

    @Override
    @NotNull
    public T read(@NotNull Context context, @Nullable P parent) throws InputParsingException {
        Object[] line = context.readLine();
        try {
            return this.lineConverter.apply((String[])line, parent);
        }
        catch (Exception e) {
            throw context.wrapException("exception while converting the values: " + Arrays.toString(line), e);
        }
    }

    public static ObjectReader<String[]> ofStringArray() {
        return Context::readLine;
    }

    public static ObjectReader<int[]> ofIntArray() {
        return LineReader.ofObject(arr -> Arrays.stream(arr).mapToInt(Integer::parseInt).toArray());
    }

    public static ObjectReader<long[]> ofLongArray() {
        return LineReader.ofObject(arr -> Arrays.stream(arr).mapToLong(Long::parseLong).toArray());
    }

    public static ObjectReader<double[]> ofDoubleArray() {
        return LineReader.ofObject(arr -> Arrays.stream(arr).mapToDouble(Double::parseDouble).toArray());
    }

    public static <E> ObjectReader<E[]> ofArray(IntFunction<E[]> arrayCreator, Function<? super String, ? extends E> itemConverter) {
        return LineReader.ofObject(arr -> Arrays.stream(arr).map(itemConverter).toArray(arrayCreator));
    }

    public static <E> ObjectReader<List<E>> ofList(Function<? super String, ? extends E> itemConverter) {
        return LineReader.ofCollection(itemConverter, Collectors.toList());
    }

    public static <E, R> ObjectReader<R> ofCollection(Function<? super String, ? extends E> itemConverter, Collector<E, ?, R> collector) {
        return LineReader.ofObject(arr -> Arrays.stream(arr).map(itemConverter).collect(collector));
    }

    public static <T> ObjectReader<T> ofObject(Function<? super String[], T> converter) {
        LineReader<Object, Object> reader = new LineReader<Object, Object>((line, parent) -> converter.apply((String[])line));
        return ctx -> reader.read(ctx, null);
    }

    public static <T, P> ChildReader<T, P> ofChild(BiFunction<? super String[], P, T> converter) {
        return new LineReader<T, P>(converter);
    }
}

