/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.readers.section;

import org.hildan.hashcode.utils.parser.InputParsingException;
import org.hildan.hashcode.utils.parser.context.Context;
import org.hildan.hashcode.utils.parser.readers.section.SectionReader;
import org.hildan.hashcode.utils.parser.reflect.ReflectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldAndVarReader<P>
implements SectionReader<P> {
    private final String fieldName;
    private final String variableName;

    public FieldAndVarReader(String fieldName, String variableName) {
        this.fieldName = fieldName;
        this.variableName = variableName;
        if (fieldName != null && fieldName.isEmpty()) {
            throw new IllegalArgumentException("Empty field name is not allowed, should be null to omit field");
        }
        if (variableName != null && variableName.isEmpty()) {
            throw new IllegalArgumentException("Empty variable name is not allowed, should be null to omit variable");
        }
    }

    @Override
    public void readAndSet(@NotNull Context context, @Nullable P object) throws InputParsingException {
        String value = context.readString();
        if (this.variableName != null) {
            context.setVariable(this.variableName, value);
        }
        if (this.fieldName != null) {
            ReflectUtils.setField(object, this.fieldName, (Object)value);
        }
    }
}

