/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.readers.section;

import java.util.ArrayList;
import java.util.List;
import org.hildan.hashcode.utils.parser.InputParsingException;
import org.hildan.hashcode.utils.parser.context.Context;
import org.hildan.hashcode.utils.parser.readers.section.FieldAndVarReader;
import org.hildan.hashcode.utils.parser.readers.section.SectionReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldsAndVarsReader<P>
implements SectionReader<P> {
    private final List<FieldAndVarReader<P>> readers;

    public FieldsAndVarsReader(String ... fieldAndVarNames) {
        this.readers = new ArrayList<FieldAndVarReader<P>>(fieldAndVarNames.length);
        for (String name : fieldAndVarNames) {
            String[] fieldAndVar = FieldsAndVarsReader.splitFieldAndVar(name);
            this.readers.add(new FieldAndVarReader(fieldAndVar[0], fieldAndVar[1]));
        }
    }

    @NotNull
    private static String[] splitFieldAndVar(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null field/variable descriptions are not allowed");
        }
        if (name.isEmpty()) {
            return new String[]{null, null};
        }
        if (!name.contains("@")) {
            return new String[]{name, null};
        }
        String[] fieldAndVar = name.split("@", 2);
        FieldsAndVarsReader.nullifyEmptyStrings(fieldAndVar);
        return fieldAndVar;
    }

    private static void nullifyEmptyStrings(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[0] == null || !array[0].isEmpty()) continue;
            array[0] = null;
        }
    }

    @Override
    public void readAndSet(@NotNull Context context, @Nullable P object) throws InputParsingException {
        for (FieldAndVarReader<P> reader : this.readers) {
            reader.readAndSet(context, object);
        }
    }
}

