/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.readers.section;

import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import org.hildan.hashcode.utils.parser.InputParsingException;
import org.hildan.hashcode.utils.parser.context.Context;
import org.hildan.hashcode.utils.parser.readers.ChildReader;
import org.hildan.hashcode.utils.parser.readers.container.ContainerReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface SectionReader<T> {
    public void readAndSet(@NotNull Context var1, @Nullable T var2) throws InputParsingException;

    public static <T> SectionReader<T> settingString(BiConsumer<T, ? super String> setter) {
        return (ctx, obj) -> setter.accept(obj, ctx.readString());
    }

    public static <T> SectionReader<T> settingInt(ObjIntConsumer<T> setter) {
        return (ctx, obj) -> setter.accept(obj, ctx.readInt());
    }

    public static <T> SectionReader<T> settingDouble(ObjDoubleConsumer<T> setter) {
        return (ctx, obj) -> setter.accept(obj, ctx.readDouble());
    }

    public static <V, T> SectionReader<T> settingObject(BiConsumer<T, ? super V> setter, Function<? super String, V> valueConverter) {
        return (ctx, obj) -> setter.accept((Object)obj, (Object)valueConverter.apply(ctx.readString()));
    }

    public static <V, T> SectionReader<T> settingChild(BiConsumer<? super T, ? super V> setter, ChildReader<? extends V, ? super T> valueReader) {
        return (ctx, obj) -> setter.accept((Object)obj, (Object)valueReader.read(ctx, (Object)obj));
    }

    public static <E, P> SectionReader<P> settingArray(BiConsumer<? super P, ? super E[]> setter, IntFunction<E[]> arrayCreator, BiFunction<? super P, Context, Integer> getSize, ChildReader<? extends E, ? super P> itemReader) {
        return SectionReader.settingChild(setter, ContainerReader.ofArray(getSize, itemReader, arrayCreator));
    }

    public static <E, P> SectionReader<P> settingList(BiConsumer<? super P, ? super List<E>> setter, BiFunction<? super P, Context, Integer> getSize, ChildReader<? extends E, ? super P> itemReader) {
        ChildReader<List<? extends E>, ? super P> listReader = ContainerReader.ofList(getSize, itemReader);
        return SectionReader.settingChild(setter, listReader);
    }

    public static <E, C extends Collection<E>, P> SectionReader<P> settingCollection(BiConsumer<? super P, ? super C> setter, IntFunction<C> constructor, BiFunction<? super P, Context, Integer> getSize, ChildReader<? extends E, ? super P> itemReader) {
        return SectionReader.settingChild(setter, ContainerReader.ofCollection(getSize, itemReader, constructor));
    }
}

