/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.reflect;

import org.hildan.hashcode.utils.parser.InputParsingException;

public class StringConversionException
extends InputParsingException {
    private final Class<?> targetType;
    private final String value;

    StringConversionException(Class<?> targetType, String value, String message) {
        super(message);
        this.targetType = targetType;
        this.value = value;
    }

    StringConversionException(Class<?> targetType, String value) {
        this(targetType, value, StringConversionException.defaultMessage(targetType, value));
    }

    StringConversionException(Class<?> targetType, String value, Throwable cause) {
        super(StringConversionException.defaultMessage(targetType, value), cause);
        this.targetType = targetType;
        this.value = value;
    }

    private static String defaultMessage(Class<?> targetType, String value) {
        return String.format("Cannot convert value '%s' to type '%s'", value, targetType.getSimpleName());
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public String getValue() {
        return this.value;
    }
}

