/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.parser.reflect;

import java.util.HashSet;
import java.util.Set;
import org.hildan.hashcode.utils.parser.reflect.StringConversionException;
import org.jetbrains.annotations.NotNull;

class StringConverter {
    private static final Set<Class<?>> WRAPPER_TYPES = new HashSet();

    StringConverter() {
    }

    @NotNull
    public static <T> T convertToPrimitiveWrapper(@NotNull Class<T> targetType, @NotNull String value) throws IllegalArgumentException {
        if (!StringConverter.isWrapperType(targetType)) {
            throw new IllegalArgumentException("The provided type '" + targetType.getSimpleName() + "' is not a wrapper of primitive");
        }
        return targetType.cast(StringConverter.convert(targetType, value));
    }

    private static boolean isWrapperType(@NotNull Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    @NotNull
    public static Object convert(@NotNull Class<?> targetType, @NotNull String value) throws StringConversionException {
        try {
            if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
                return StringConverter.convertToBoolean(value);
            }
            if (targetType.equals(Long.TYPE) || targetType.equals(Long.class)) {
                return Long.valueOf(value);
            }
            if (targetType.equals(Integer.TYPE) || targetType.equals(Integer.class)) {
                return Integer.valueOf(value);
            }
            if (targetType.equals(Double.TYPE) || targetType.equals(Double.class)) {
                return Double.valueOf(value);
            }
            if (targetType.equals(Float.TYPE) || targetType.equals(Float.class)) {
                return Float.valueOf(value);
            }
            if (targetType.equals(Character.TYPE) || targetType.equals(Character.class)) {
                if (value.length() != 1) {
                    throw new StringConversionException(targetType, value);
                }
                return Character.valueOf(value.charAt(0));
            }
            if (targetType.equals(String.class)) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            throw new StringConversionException(targetType, value, (Throwable)e);
        }
        throw new IllegalArgumentException("The provided type '" + targetType.getSimpleName() + "' is not String or a wrapper of primitive");
    }

    private static boolean convertToBoolean(@NotNull String value) {
        if (value.equalsIgnoreCase("false") || "0".equals(value)) {
            return false;
        }
        if (value.equalsIgnoreCase("true") || "1".equals(value)) {
            return true;
        }
        throw new StringConversionException(Boolean.class, value, "Cannot convert value '" + value + "' to boolean");
    }

    static {
        WRAPPER_TYPES.add(Boolean.class);
        WRAPPER_TYPES.add(Character.class);
        WRAPPER_TYPES.add(Byte.class);
        WRAPPER_TYPES.add(Short.class);
        WRAPPER_TYPES.add(Integer.class);
        WRAPPER_TYPES.add(Long.class);
        WRAPPER_TYPES.add(Float.class);
        WRAPPER_TYPES.add(Double.class);
    }
}

