/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.runner;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hildan.hashcode.utils.runner.UncaughtExceptionsPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExceptionLoggingExecutorService
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionLoggingExecutorService.class);
    private static final String UNCAUGHT_EXCEPTION_MSG = "Uncaught exception thrown during task execution:";
    private final UncaughtExceptionsPolicy exceptionsPolicy;

    ExceptionLoggingExecutorService(int nThreads, UncaughtExceptionsPolicy exceptionsPolicy) {
        super(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.exceptionsPolicy = exceptionsPolicy;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException e) {
                t = e;
            }
            catch (ExecutionException e) {
                t = e.getCause();
            }
            catch (InterruptedException e) {
                logger.error("Internal error, future.get() was interrupted while future.isDone() is true", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            if (this.exceptionsPolicy.shouldLogViaSlf4J()) {
                logger.error(UNCAUGHT_EXCEPTION_MSG, t);
            }
            if (this.exceptionsPolicy.shouldPrintOnStdErr()) {
                System.err.println(UNCAUGHT_EXCEPTION_MSG);
                t.printStackTrace();
            }
        }
    }
}

