/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.solver;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.hildan.hashcode.utils.solver.SolverException;

public abstract class AbstractFileSolver
implements Consumer<String> {
    private static final String INPUT_EXTENSION = ".in";
    private static final String OUTPUT_EXTENSION = ".out";
    private static final String INPUT_FOLDER = "inputs/";
    private static final String OUTPUT_FOLDER = "outputs/";

    @Override
    public void accept(String inputFilename) {
        Iterable<? extends CharSequence> lines = this.solve(inputFilename);
        String outputFile = this.computeOutputFilename(inputFilename);
        try {
            this.writeOutputFile(outputFile, lines);
        }
        catch (IOException e) {
            throw new SolverException("Exception occurred while writing to the output file '" + outputFile + "'", e);
        }
    }

    protected abstract Iterable<? extends CharSequence> solve(String var1);

    protected String computeOutputFilename(String inputFilename) {
        String outputFilename = inputFilename;
        outputFilename = outputFilename.replaceAll("^inputs/", OUTPUT_FOLDER);
        outputFilename = (outputFilename = outputFilename.replaceAll("/inputs/", "/outputs/")).endsWith(INPUT_EXTENSION) ? outputFilename.replaceAll(".in$", OUTPUT_EXTENSION) : outputFilename + OUTPUT_EXTENSION;
        return outputFilename;
    }

    protected void writeOutputFile(String outputFilename, Iterable<? extends CharSequence> lines) throws IOException {
        Path filePath = Paths.get(outputFilename, new String[0]);
        Path parentDir = filePath.getParent();
        if (parentDir != null) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        Files.write(filePath, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

