/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.hashcode.utils.solver;

import java.io.IOException;
import java.util.function.Function;
import org.hildan.hashcode.utils.parser.HCParser;
import org.hildan.hashcode.utils.parser.readers.ObjectReader;
import org.hildan.hashcode.utils.solver.AbstractFileSolver;
import org.hildan.hashcode.utils.solver.Solvable;
import org.hildan.hashcode.utils.solver.SolverException;

public class HCSolver<P>
extends AbstractFileSolver {
    private final HCParser<P> problemParser;
    private final Function<P, ? extends Iterable<? extends CharSequence>> solver;

    public HCSolver(HCParser<P> problemParser, Function<P, ? extends Iterable<? extends CharSequence>> solver) {
        this.problemParser = problemParser;
        this.solver = solver;
    }

    public static <P extends Solvable> HCSolver<P> of(HCParser<P> parser) {
        return new HCSolver<Solvable>(parser, Solvable::solve);
    }

    public static <P extends Solvable> HCSolver<P> of(ObjectReader<P> reader) {
        return new HCSolver<Solvable>(new HCParser<P>(reader), Solvable::solve);
    }

    public static <P> HCSolver<P> of(HCParser<P> parser, Function<P, ? extends Iterable<? extends CharSequence>> solver) {
        return new HCSolver<P>(parser, solver);
    }

    public static <P> HCSolver<P> of(ObjectReader<P> reader, Function<P, ? extends Iterable<? extends CharSequence>> solver) {
        return new HCSolver<P>(new HCParser<P>(reader), solver);
    }

    @Override
    protected Iterable<? extends CharSequence> solve(String inputFilename) {
        try {
            P problem = this.problemParser.parseFile(inputFilename);
            return this.solver.apply(problem);
        }
        catch (IOException e) {
            throw new SolverException("Exception occurred while parsing the input file '" + inputFilename + "'", e);
        }
    }
}

