(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'krossbow-krossbow-websocket-core-js-legacy', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('krossbow-krossbow-websocket-core-js-legacy'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-builtin-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'krossbow-krossbow-websocket-builtin-js-legacy'.");
    }
    if (typeof this['krossbow-krossbow-websocket-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-builtin-js-legacy'. Its dependency 'krossbow-krossbow-websocket-core-js-legacy' was not found. Please, check whether 'krossbow-krossbow-websocket-core-js-legacy' is loaded prior to 'krossbow-krossbow-websocket-builtin-js-legacy'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-builtin-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'krossbow-krossbow-websocket-builtin-js-legacy'.");
    }
    root['krossbow-krossbow-websocket-builtin-js-legacy'] = factory(typeof this['krossbow-krossbow-websocket-builtin-js-legacy'] === 'undefined' ? {} : this['krossbow-krossbow-websocket-builtin-js-legacy'], kotlin, this['krossbow-krossbow-websocket-core-js-legacy'], this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$krossbow_krossbow_websocket_core_js_legacy, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var UnboundedWsListenerFlowAdapter = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.UnboundedWsListenerFlowAdapter;
  var Unit = Kotlin.kotlin.Unit;
  var WebSocketConnectionClosedException = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketConnectionClosedException;
  var WebSocketConnectionException = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketConnectionException;
  var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
  var toString = Kotlin.toString;
  var Exception = Kotlin.kotlin.Exception;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var WebSocketClient = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketClient;
  var toShort = Kotlin.toShort;
  var WebSocketConnection = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketConnection;
  var toTypedArray = Kotlin.kotlin.collections.toTypedArray_964n91$;
  var Result = Kotlin.kotlin.Result;
  var createFailure = Kotlin.kotlin.createFailure_tcv7n7$;
  var intercepted = Kotlin.kotlin.coroutines.intrinsics.intercepted_f9mg25$;
  var CancellableContinuationImpl_init = $module$kotlinx_coroutines_core.kotlinx.coroutines.CancellableContinuationImpl;
  BrowserWebSocketClient.prototype = Object.create(JsWebSocketClientAdapter.prototype);
  BrowserWebSocketClient.prototype.constructor = BrowserWebSocketClient;
  function default_0($receiver) {
    return BrowserWebSocketClient_getInstance();
  }
  function suspendCancellableCoroutine$lambda(closure$block) {
    return function (uCont) {
      var cancellable = new CancellableContinuationImpl_init(intercepted(uCont), 1);
      cancellable.initCancellability();
      closure$block(cancellable);
      return cancellable.getResult();
    };
  }
  function BrowserWebSocketClient() {
    BrowserWebSocketClient_instance = this;
    JsWebSocketClientAdapter.call(this, BrowserWebSocketClient_init$lambda);
  }
  function BrowserWebSocketClient_init$lambda(url) {
    return new WebSocket(url);
  }
  BrowserWebSocketClient.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BrowserWebSocketClient',
    interfaces: [JsWebSocketClientAdapter]
  };
  var BrowserWebSocketClient_instance = null;
  function BrowserWebSocketClient_getInstance() {
    if (BrowserWebSocketClient_instance === null) {
      new BrowserWebSocketClient();
    }
    return BrowserWebSocketClient_instance;
  }
  function JsWebSocketClientAdapter(newWebSocket) {
    this.newWebSocket_wgl7q3$_0 = newWebSocket;
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda(closure$pendingConnect, closure$cont, closure$wsSession) {
    return function (it) {
      closure$pendingConnect.v = false;
      var $receiver = closure$cont;
      var value = closure$wsSession;
      $receiver.resumeWith_tl1gpc$(new Result(value));
      return Unit;
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_0(closure$pendingConnect, closure$cont, closure$url, closure$listener) {
    return function (event) {
      var closeEvent = event;
      var code = closeEvent.code;
      if (closure$pendingConnect.v) {
        closure$pendingConnect.v = false;
        var $receiver = closure$cont;
        var exception = new WebSocketConnectionClosedException(closure$url, code, closeEvent.reason);
        $receiver.resumeWith_tl1gpc$(new Result(createFailure(exception)));
        return Unit;
      } else {
        return closure$listener.onClose_vqvrqt$(code, closeEvent.reason);
      }
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_1(closure$pendingConnect, closure$cont, closure$url, closure$listener) {
    return function (event) {
      var errorEvent = event;
      if (closure$pendingConnect.v) {
        closure$pendingConnect.v = false;
        var $receiver = closure$cont;
        var exception = new WebSocketConnectionException(closure$url, null, errorEvent.message);
        $receiver.resumeWith_tl1gpc$(new Result(createFailure(exception)));
      } else {
        closure$listener.onError_61zpoe$(errorEvent.message);
      }
      return Unit;
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_2(closure$listener) {
    return function (event) {
      var body = event.data;
      if (Kotlin.isType(body, ArrayBuffer))
        return closure$listener.onBinaryMessage_fqrh44$(toByteArray(body));
      else if (typeof body === 'string')
        return closure$listener.onTextMessage_61zpoe$(body);
      else if (body == null)
        return closure$listener.onTextMessage_61zpoe$('');
      else
        return closure$listener.onError_61zpoe$('Unknown socket frame body type: ' + get_js(Kotlin.getKClassFromExpression(body))), Unit;
    };
  }
  function JsWebSocketClientAdapter$connect$lambda(this$JsWebSocketClientAdapter, closure$url) {
    return function (cont) {
      try {
        var ws = this$JsWebSocketClientAdapter.newWebSocket_wgl7q3$_0(closure$url);
        ws.binaryType = 'arraybuffer';
        var pendingConnect = {v: true};
        var listener = new UnboundedWsListenerFlowAdapter();
        var wsSession = new JsWebSocketConnection(ws, listener.incomingFrames);
        ws.onopen = JsWebSocketClientAdapter$connect$lambda$lambda(pendingConnect, cont, wsSession);
        ws.onclose = JsWebSocketClientAdapter$connect$lambda$lambda_0(pendingConnect, cont, closure$url, listener);
        ws.onerror = JsWebSocketClientAdapter$connect$lambda$lambda_1(pendingConnect, cont, closure$url, listener);
        ws.onmessage = JsWebSocketClientAdapter$connect$lambda$lambda_2(listener);
      } catch (e) {
        if (Kotlin.isType(e, Exception)) {
          console.error('Exception in WebSocket setup: ' + toString(e.message));
          var exception = e;
          cont.resumeWith_tl1gpc$(new Result(createFailure(exception)));
        } else
          throw e;
      }
      return Unit;
    };
  }
  function Coroutine$connect_61zpoe$($this, url_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$url = url_0;
  }
  Coroutine$connect_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connect_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connect_61zpoe$.prototype.constructor = Coroutine$connect_61zpoe$;
  Coroutine$connect_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = suspendCancellableCoroutine$lambda(JsWebSocketClientAdapter$connect$lambda(this.$this, this.local$url))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  JsWebSocketClientAdapter.prototype.connect_61zpoe$ = function (url_0, continuation_0, suspended) {
    var instance = new Coroutine$connect_61zpoe$(this, url_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  JsWebSocketClientAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsWebSocketClientAdapter',
    interfaces: [WebSocketClient]
  };
  function JsWebSocketConnection(ws, incomingFrames) {
    this.ws_0 = ws;
    this.incomingFrames_g4ilgs$_0 = incomingFrames;
  }
  Object.defineProperty(JsWebSocketConnection.prototype, 'incomingFrames', {
    get: function () {
      return this.incomingFrames_g4ilgs$_0;
    }
  });
  Object.defineProperty(JsWebSocketConnection.prototype, 'url', {
    configurable: true,
    get: function () {
      return this.ws_0.url;
    }
  });
  Object.defineProperty(JsWebSocketConnection.prototype, 'canSend', {
    configurable: true,
    get: function () {
      return this.ws_0.readyState === WebSocket.OPEN;
    }
  });
  JsWebSocketConnection.prototype.sendText_61zpoe$ = function (frameText, continuation) {
    this.ws_0.send(frameText);
  };
  JsWebSocketConnection.prototype.sendBinary_fqrh44$ = function (frameData, continuation) {
    this.ws_0.send(toArrayBuffer(frameData));
  };
  JsWebSocketConnection.prototype.close_vqvrqt$$default = function (code, reason, continuation) {
    this.ws_0.close(toShort(code), reason != null ? reason : '');
  };
  JsWebSocketConnection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsWebSocketConnection',
    interfaces: [WebSocketConnection]
  };
  function toByteArray($receiver) {
    var int8Array = new Int8Array($receiver);
    var array = new Int8Array(int8Array.length);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = int8Array[i];
    }
    return array;
  }
  function toArrayBuffer($receiver) {
    return (new Int8Array(toTypedArray($receiver))).buffer;
  }
  var package$org = _.org || (_.org = {});
  var package$hildan = package$org.hildan || (package$org.hildan = {});
  var package$krossbow = package$hildan.krossbow || (package$hildan.krossbow = {});
  var package$websocket = package$krossbow.websocket || (package$krossbow.websocket = {});
  package$websocket.default_nxdado$ = default_0;
  var package$js = package$websocket.js || (package$websocket.js = {});
  Object.defineProperty(package$js, 'BrowserWebSocketClient', {
    get: BrowserWebSocketClient_getInstance
  });
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  package$js.JsWebSocketClientAdapter = JsWebSocketClientAdapter;
  Object.defineProperty(JsWebSocketConnection.prototype, 'host', Object.getOwnPropertyDescriptor(WebSocketConnection.prototype, 'host'));
  JsWebSocketConnection.prototype.close_vqvrqt$ = WebSocketConnection.prototype.close_vqvrqt$;
  Kotlin.defineModule('krossbow-krossbow-websocket-builtin-js-legacy', _);
  return _;
}));

//# sourceMappingURL=krossbow-krossbow-websocket-builtin-js-legacy.js.map
