(function (_, Kotlin, $module$kotlinx_io, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var writeFully = $module$kotlinx_io.kotlinx.io.core.writeFully_u129dg$;
  var readBytes = $module$kotlinx_io.kotlinx.io.core.readBytes_3lionn$;
  var BytePacketBuilder = $module$kotlinx_io.kotlinx.io.core.BytePacketBuilder_za3lpa$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var BufferOverflow = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.BufferOverflow;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var substringAfter = Kotlin.kotlin.text.substringAfter_j4ogox$;
  var substringBefore = Kotlin.kotlin.text.substringBefore_j4ogox$;
  var Exception = Kotlin.kotlin.Exception;
  var toString = Kotlin.toString;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Unit = Kotlin.kotlin.Unit;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
  var toShort = Kotlin.toShort;
  var toTypedArray = Kotlin.kotlin.collections.toTypedArray_964n91$;
  var Result = Kotlin.kotlin.Result;
  var createFailure = Kotlin.kotlin.createFailure_tcv7n7$;
  var intercepted = Kotlin.kotlin.coroutines.intrinsics.intercepted_f9mg25$;
  var CancellableContinuationImpl_init = $module$kotlinx_coroutines_core.kotlinx.coroutines.CancellableContinuationImpl;
  WebSocketFrame$Text.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Text.prototype.constructor = WebSocketFrame$Text;
  WebSocketFrame$Binary.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Binary.prototype.constructor = WebSocketFrame$Binary;
  WebSocketFrame$Ping.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Ping.prototype.constructor = WebSocketFrame$Ping;
  WebSocketFrame$Pong.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Pong.prototype.constructor = WebSocketFrame$Pong;
  WebSocketFrame$Close.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Close.prototype.constructor = WebSocketFrame$Close;
  WebSocketException.prototype = Object.create(Exception.prototype);
  WebSocketException.prototype.constructor = WebSocketException;
  WebSocketConnectionException.prototype = Object.create(WebSocketException.prototype);
  WebSocketConnectionException.prototype.constructor = WebSocketConnectionException;
  WebSocketConnectionClosedException.prototype = Object.create(WebSocketConnectionException.prototype);
  WebSocketConnectionClosedException.prototype.constructor = WebSocketConnectionClosedException;
  BrowserWebSocketClient.prototype = Object.create(JsWebSocketClientAdapter.prototype);
  BrowserWebSocketClient.prototype.constructor = BrowserWebSocketClient;
  function PartialBinaryMessageHandler(onMessageComplete) {
    this.onMessageComplete_0 = onMessageComplete;
    this.bytesBuilder_0 = BytePacketBuilder();
  }
  function Coroutine$processMessage_1fhb37$($this, bytes_0, isLast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$bytes = bytes_0;
    this.local$isLast = isLast_0;
  }
  Coroutine$processMessage_1fhb37$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$processMessage_1fhb37$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$processMessage_1fhb37$.prototype.constructor = Coroutine$processMessage_1fhb37$;
  Coroutine$processMessage_1fhb37$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$isLast === void 0)
              this.local$isLast = true;
            if (this.$this.bytesBuilder_0.isEmpty && this.local$isLast) {
              this.state_0 = 4;
              this.result_0 = this.$this.onMessageComplete_0(this.local$bytes, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              writeFully(this.$this.bytesBuilder_0, this.local$bytes);
              if (this.local$isLast) {
                var fullMsg = readBytes(this.$this.bytesBuilder_0.build());
                this.state_0 = 2;
                this.result_0 = this.$this.onMessageComplete_0(fullMsg, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                this.state_0 = 3;
                continue;
              }
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            continue;
          case 3:
            this.state_0 = 5;
            continue;
          case 4:
            this.state_0 = 5;
            continue;
          case 5:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PartialBinaryMessageHandler.prototype.processMessage_1fhb37$ = function (bytes_0, isLast_0, continuation_0, suspended) {
    var instance = new Coroutine$processMessage_1fhb37$(this, bytes_0, isLast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  PartialBinaryMessageHandler.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PartialBinaryMessageHandler',
    interfaces: []
  };
  function PartialTextMessageHandler(onMessageComplete) {
    this.onMessageComplete_0 = onMessageComplete;
    this.textBuilder_0 = StringBuilder_init();
  }
  function Coroutine$processMessage_7tcg9p$($this, text_0, isLast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$text = text_0;
    this.local$isLast = isLast_0;
  }
  Coroutine$processMessage_7tcg9p$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$processMessage_7tcg9p$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$processMessage_7tcg9p$.prototype.constructor = Coroutine$processMessage_7tcg9p$;
  Coroutine$processMessage_7tcg9p$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$isLast === void 0)
              this.local$isLast = true;
            if (this.$this.textBuilder_0.length === 0 && this.local$isLast) {
              this.state_0 = 4;
              this.result_0 = this.$this.onMessageComplete_0(this.local$text, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.$this.textBuilder_0.append_gw00v9$(this.local$text);
              if (this.local$isLast) {
                var $receiver = this.$this.textBuilder_0.toString();
                this.$this.textBuilder_0.clear();
                var fullMsg = $receiver;
                this.state_0 = 2;
                this.result_0 = this.$this.onMessageComplete_0(fullMsg, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                this.state_0 = 3;
                continue;
              }
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            continue;
          case 3:
            this.state_0 = 5;
            continue;
          case 4:
            this.state_0 = 5;
            continue;
          case 5:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PartialTextMessageHandler.prototype.processMessage_7tcg9p$ = function (text_0, isLast_0, continuation_0, suspended) {
    var instance = new Coroutine$processMessage_7tcg9p$(this, text_0, isLast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  PartialTextMessageHandler.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PartialTextMessageHandler',
    interfaces: []
  };
  function processPartialMessage(msg, isLast, isBufferEmpty, appendToBuffer, readAndClearBuffer, onMessageComplete) {
    if (isBufferEmpty && isLast) {
      onMessageComplete(msg);
    } else {
      appendToBuffer(msg);
      if (isLast) {
        var fullMsg = readAndClearBuffer();
        onMessageComplete(fullMsg);
      }}
  }
  function WebSocketListenerChannelAdapter(bufferSize, onBufferOverflow) {
    if (bufferSize === void 0)
      bufferSize = -2;
    if (onBufferOverflow === void 0)
      onBufferOverflow = BufferOverflow.SUSPEND;
    this.frames_0 = Channel(bufferSize, onBufferOverflow);
    this.partialTextMessageHandler_0 = new PartialTextMessageHandler(WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda(this));
    this.partialBinaryMessageHandler_0 = new PartialBinaryMessageHandler(WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda(this));
  }
  Object.defineProperty(WebSocketListenerChannelAdapter.prototype, 'incomingFrames', {
    configurable: true,
    get: function () {
      return this.frames_0;
    }
  });
  function Coroutine$onBinaryMessage_1fhb37$($this, bytes_0, isLast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$bytes = bytes_0;
    this.local$isLast = isLast_0;
  }
  Coroutine$onBinaryMessage_1fhb37$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onBinaryMessage_1fhb37$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onBinaryMessage_1fhb37$.prototype.constructor = Coroutine$onBinaryMessage_1fhb37$;
  Coroutine$onBinaryMessage_1fhb37$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$isLast === void 0)
              this.local$isLast = true;
            this.state_0 = 2;
            this.result_0 = this.$this.partialBinaryMessageHandler_0.processMessage_1fhb37$(this.local$bytes, this.local$isLast, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onBinaryMessage_1fhb37$ = function (bytes_0, isLast_0, continuation_0, suspended) {
    var instance = new Coroutine$onBinaryMessage_1fhb37$(this, bytes_0, isLast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$onTextMessage_7tcg9p$($this, text_0, isLast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$text = text_0;
    this.local$isLast = isLast_0;
  }
  Coroutine$onTextMessage_7tcg9p$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onTextMessage_7tcg9p$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onTextMessage_7tcg9p$.prototype.constructor = Coroutine$onTextMessage_7tcg9p$;
  Coroutine$onTextMessage_7tcg9p$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$isLast === void 0)
              this.local$isLast = true;
            this.state_0 = 2;
            this.result_0 = this.$this.partialTextMessageHandler_0.processMessage_7tcg9p$(this.local$text, this.local$isLast, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onTextMessage_7tcg9p$ = function (text_0, isLast_0, continuation_0, suspended) {
    var instance = new Coroutine$onTextMessage_7tcg9p$(this, text_0, isLast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$onPing_fqrh44$($this, bytes_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$bytes = bytes_0;
  }
  Coroutine$onPing_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onPing_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onPing_fqrh44$.prototype.constructor = Coroutine$onPing_fqrh44$;
  Coroutine$onPing_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.frames_0.send_11rb$(new WebSocketFrame$Ping(this.local$bytes), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onPing_fqrh44$ = function (bytes_0, continuation_0, suspended) {
    var instance = new Coroutine$onPing_fqrh44$(this, bytes_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$onPong_fqrh44$($this, bytes_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$bytes = bytes_0;
  }
  Coroutine$onPong_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onPong_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onPong_fqrh44$.prototype.constructor = Coroutine$onPong_fqrh44$;
  Coroutine$onPong_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.frames_0.send_11rb$(new WebSocketFrame$Pong(this.local$bytes), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onPong_fqrh44$ = function (bytes_0, continuation_0, suspended) {
    var instance = new Coroutine$onPong_fqrh44$(this, bytes_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$onClose_vqvrqt$($this, code_0, reason_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$code = code_0;
    this.local$reason = reason_0;
  }
  Coroutine$onClose_vqvrqt$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onClose_vqvrqt$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onClose_vqvrqt$.prototype.constructor = Coroutine$onClose_vqvrqt$;
  Coroutine$onClose_vqvrqt$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.frames_0.send_11rb$(new WebSocketFrame$Close(this.local$code, this.local$reason), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.$this.frames_0.close_dbl4no$();
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onClose_vqvrqt$ = function (code_0, reason_0, continuation_0, suspended) {
    var instance = new Coroutine$onClose_vqvrqt$(this, code_0, reason_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  WebSocketListenerChannelAdapter.prototype.onError_61zpoe$ = function (message) {
    this.frames_0.close_dbl4no$(new WebSocketException(message));
  };
  WebSocketListenerChannelAdapter.prototype.onError_dbl4no$ = function (error) {
    var tmp$;
    this.frames_0.close_dbl4no$(new WebSocketException((tmp$ = error != null ? error.message : null) != null ? tmp$ : 'web socket error', error));
  };
  function Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$WebSocketListenerChannelAdapter = this$WebSocketListenerChannelAdapter_0;
    this.local$it = it_0;
  }
  Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda.prototype.constructor = Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda;
  Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$WebSocketListenerChannelAdapter.frames_0.send_11rb$(new WebSocketFrame$Text(this.local$it.toString()), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$WebSocketListenerChannelAdapter = this$WebSocketListenerChannelAdapter_0;
    this.local$it = it_0;
  }
  Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda.prototype.constructor = Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda;
  Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$WebSocketListenerChannelAdapter.frames_0.send_11rb$(new WebSocketFrame$Binary(this.local$it), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  WebSocketListenerChannelAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketListenerChannelAdapter',
    interfaces: []
  };
  function WebSocketClient() {
  }
  WebSocketClient.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'WebSocketClient',
    interfaces: []
  };
  function WebSocketSession() {
  }
  Object.defineProperty(WebSocketSession.prototype, 'host', {
    configurable: true,
    get: function () {
      return substringBefore(substringBefore(substringAfter(this.url, '://'), '/'), ':');
    }
  });
  WebSocketSession.prototype.close_vqvrqt$ = function (code, reason, continuation, callback$default) {
    if (code === void 0)
      code = 1000;
    if (reason === void 0)
      reason = null;
    return callback$default ? callback$default(code, reason, continuation) : this.close_vqvrqt$$default(code, reason, continuation);
  };
  WebSocketSession.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'WebSocketSession',
    interfaces: []
  };
  function WebSocketSessionWithPingPong() {
  }
  WebSocketSessionWithPingPong.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'WebSocketSessionWithPingPong',
    interfaces: [WebSocketSession]
  };
  function WebSocketFrame() {
  }
  function WebSocketFrame$Text(text) {
    WebSocketFrame.call(this);
    this.text = text;
  }
  WebSocketFrame$Text.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Text',
    interfaces: [WebSocketFrame]
  };
  WebSocketFrame$Text.prototype.component1 = function () {
    return this.text;
  };
  WebSocketFrame$Text.prototype.copy_61zpoe$ = function (text) {
    return new WebSocketFrame$Text(text === void 0 ? this.text : text);
  };
  WebSocketFrame$Text.prototype.toString = function () {
    return 'Text(text=' + Kotlin.toString(this.text) + ')';
  };
  WebSocketFrame$Text.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    return result;
  };
  WebSocketFrame$Text.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.text, other.text))));
  };
  function WebSocketFrame$Binary(bytes) {
    WebSocketFrame.call(this);
    this.bytes = bytes;
  }
  WebSocketFrame$Binary.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Binary',
    interfaces: [WebSocketFrame]
  };
  function WebSocketFrame$Ping(bytes) {
    WebSocketFrame.call(this);
    this.bytes = bytes;
  }
  WebSocketFrame$Ping.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Ping',
    interfaces: [WebSocketFrame]
  };
  function WebSocketFrame$Pong(bytes) {
    WebSocketFrame.call(this);
    this.bytes = bytes;
  }
  WebSocketFrame$Pong.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Pong',
    interfaces: [WebSocketFrame]
  };
  function WebSocketFrame$Close(code, reason) {
    WebSocketFrame.call(this);
    this.code = code;
    this.reason = reason;
  }
  WebSocketFrame$Close.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Close',
    interfaces: [WebSocketFrame]
  };
  WebSocketFrame$Close.prototype.component1 = function () {
    return this.code;
  };
  WebSocketFrame$Close.prototype.component2 = function () {
    return this.reason;
  };
  WebSocketFrame$Close.prototype.copy_vqvrqt$ = function (code, reason) {
    return new WebSocketFrame$Close(code === void 0 ? this.code : code, reason === void 0 ? this.reason : reason);
  };
  WebSocketFrame$Close.prototype.toString = function () {
    return 'Close(code=' + Kotlin.toString(this.code) + (', reason=' + Kotlin.toString(this.reason)) + ')';
  };
  WebSocketFrame$Close.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.code) | 0;
    result = result * 31 + Kotlin.hashCode(this.reason) | 0;
    return result;
  };
  WebSocketFrame$Close.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.code, other.code) && Kotlin.equals(this.reason, other.reason)))));
  };
  WebSocketFrame.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketFrame',
    interfaces: []
  };
  function WebSocketException(message, cause) {
    if (cause === void 0)
      cause = null;
    Exception.call(this, message, cause);
    this.name = 'WebSocketException';
  }
  WebSocketException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketException',
    interfaces: [Exception]
  };
  function WebSocketConnectionException(url, message, cause) {
    if (message === void 0)
      message = "Couldn't connect to web socket at " + url;
    if (cause === void 0)
      cause = null;
    WebSocketException.call(this, message, cause);
    this.url = url;
    this.name = 'WebSocketConnectionException';
  }
  WebSocketConnectionException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketConnectionException',
    interfaces: [WebSocketException]
  };
  function WebSocketConnectionClosedException(url, code, reason) {
    WebSocketConnectionException.call(this, url, "Couldn't connect to web socket at " + url + '. The server closed the connection. Code: ' + code + ' Reason: ' + toString(reason));
    this.code = code;
    this.reason = reason;
    this.name = 'WebSocketConnectionClosedException';
  }
  WebSocketConnectionClosedException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketConnectionClosedException',
    interfaces: [WebSocketConnectionException]
  };
  function WebSocketCloseCodes() {
    WebSocketCloseCodes_instance = this;
    this.NORMAL_CLOSURE = 1000;
    this.GOING_AWAY = 1001;
    this.PROTOCOL_ERROR = 1002;
    this.NOT_ACCEPTABLE = 1003;
    this.NO_STATUS_CODE = 1005;
    this.NO_CLOSE_FRAME = 1006;
    this.BAD_DATA = 1007;
    this.POLICY_VIOLATION = 1008;
    this.TOO_BIG_TO_PROCESS = 1009;
    this.REQUIRED_EXTENSION = 1010;
    this.SERVER_ERROR = 1011;
    this.SERVICE_RESTARTED = 1012;
    this.SERVICE_OVERLOAD = 1013;
    this.TLS_HANDSHAKE_FAILURE = 1015;
  }
  WebSocketCloseCodes.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'WebSocketCloseCodes',
    interfaces: []
  };
  var WebSocketCloseCodes_instance = null;
  function WebSocketCloseCodes_getInstance() {
    if (WebSocketCloseCodes_instance === null) {
      new WebSocketCloseCodes();
    }return WebSocketCloseCodes_instance;
  }
  function defaultWebSocketClient() {
    return BrowserWebSocketClient_getInstance();
  }
  function suspendCancellableCoroutine$lambda(closure$block) {
    return function (uCont) {
      var cancellable = new CancellableContinuationImpl_init(intercepted(uCont), 1);
      cancellable.initCancellability();
      closure$block(cancellable);
      return cancellable.getResult();
    };
  }
  function BrowserWebSocketClient() {
    BrowserWebSocketClient_instance = this;
    JsWebSocketClientAdapter.call(this, BrowserWebSocketClient_init$lambda);
  }
  function BrowserWebSocketClient_init$lambda(url) {
    return new WebSocket(url);
  }
  BrowserWebSocketClient.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BrowserWebSocketClient',
    interfaces: [JsWebSocketClientAdapter]
  };
  var BrowserWebSocketClient_instance = null;
  function BrowserWebSocketClient_getInstance() {
    if (BrowserWebSocketClient_instance === null) {
      new BrowserWebSocketClient();
    }return BrowserWebSocketClient_instance;
  }
  function JsWebSocketClientAdapter(newWebSocket) {
    this.newWebSocket_wgl7q3$_0 = newWebSocket;
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda(closure$pendingConnect, closure$cont, closure$wsSession) {
    return function (it) {
      closure$pendingConnect.v = false;
      var $receiver = closure$cont;
      var value = closure$wsSession;
      $receiver.resumeWith_tl1gpc$(new Result(value));
      return Unit;
    };
  }
  function Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda(closure$listener_0, closure$code_0, closure$closeEvent_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$listener = closure$listener_0;
    this.local$closure$code = closure$code_0;
    this.local$closure$closeEvent = closure$closeEvent_0;
  }
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda.prototype.constructor = Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda;
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$listener.onClose_vqvrqt$(this.local$closure$code, this.local$closure$closeEvent.reason, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function JsWebSocketClientAdapter$connect$lambda$lambda$lambda(closure$listener_0, closure$code_0, closure$closeEvent_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda(closure$listener_0, closure$code_0, closure$closeEvent_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_0(closure$pendingConnect, closure$cont, closure$url, closure$listener) {
    return function (event) {
      var closeEvent = event;
      var code = closeEvent.code;
      if (closure$pendingConnect.v) {
        closure$pendingConnect.v = false;
        var $receiver = closure$cont;
        var exception = new WebSocketConnectionClosedException(closure$url, code, closeEvent.reason);
        $receiver.resumeWith_tl1gpc$(new Result(createFailure(exception)));
        return Unit;
      } else {
        return launch(coroutines.GlobalScope, void 0, void 0, JsWebSocketClientAdapter$connect$lambda$lambda$lambda(closure$listener, code, closeEvent));
      }
    };
  }
  function Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0(closure$listener_0, closure$errorEvent_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$listener = closure$listener_0;
    this.local$closure$errorEvent = closure$errorEvent_0;
  }
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0.prototype.constructor = Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0;
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$closure$listener.onError_61zpoe$(this.local$closure$errorEvent.message), Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0(closure$listener_0, closure$errorEvent_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0(closure$listener_0, closure$errorEvent_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_1(closure$pendingConnect, closure$cont, closure$url, closure$listener) {
    return function (event) {
      var errorEvent = event;
      if (closure$pendingConnect.v) {
        closure$pendingConnect.v = false;
        var $receiver = closure$cont;
        var exception = new WebSocketConnectionException(closure$url, errorEvent.message);
        $receiver.resumeWith_tl1gpc$(new Result(createFailure(exception)));
        return Unit;
      } else {
        return launch(coroutines.GlobalScope, void 0, void 0, JsWebSocketClientAdapter$connect$lambda$lambda$lambda_0(closure$listener, errorEvent));
      }
    };
  }
  function Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1(closure$event_0, closure$listener_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$event = closure$event_0;
    this.local$closure$listener = closure$listener_0;
  }
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1.prototype.constructor = Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1;
  Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var body = this.local$closure$event.data;
            if (typeof body === 'string') {
              this.state_0 = 6;
              this.result_0 = this.local$closure$listener.onTextMessage_7tcg9p$(body, void 0, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              if (Kotlin.isType(body, ArrayBuffer)) {
                this.state_0 = 4;
                this.result_0 = this.local$closure$listener.onBinaryMessage_1fhb37$(toByteArray(body), void 0, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                if (body == null) {
                  this.state_0 = 2;
                  this.result_0 = this.local$closure$listener.onTextMessage_7tcg9p$('', void 0, this);
                  if (this.result_0 === COROUTINE_SUSPENDED)
                    return COROUTINE_SUSPENDED;
                  continue;
                } else {
                  return this.local$closure$listener.onError_61zpoe$('Unknown socket frame body type: ' + get_js(Kotlin.getKClassFromExpression(body))), Unit;
                }
              }
            }

          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          case 3:
            this.state_0 = 5;
            continue;
          case 4:
            return Unit;
          case 5:
            this.state_0 = 7;
            continue;
          case 6:
            return Unit;
          case 7:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1(closure$event_0, closure$listener_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1(closure$event_0, closure$listener_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_2(closure$listener) {
    return function (event) {
      return launch(coroutines.GlobalScope, void 0, void 0, JsWebSocketClientAdapter$connect$lambda$lambda$lambda_1(event, closure$listener));
    };
  }
  function JsWebSocketClientAdapter$connect$lambda(this$JsWebSocketClientAdapter, closure$url) {
    return function (cont) {
      try {
        var ws = this$JsWebSocketClientAdapter.newWebSocket_wgl7q3$_0(closure$url);
        ws.binaryType = 'arraybuffer';
        var pendingConnect = {v: true};
        var listener = new WebSocketListenerChannelAdapter(2147483647);
        var wsSession = new JsWebSocketSession(ws, listener.incomingFrames);
        ws.onopen = JsWebSocketClientAdapter$connect$lambda$lambda(pendingConnect, cont, wsSession);
        ws.onclose = JsWebSocketClientAdapter$connect$lambda$lambda_0(pendingConnect, cont, closure$url, listener);
        ws.onerror = JsWebSocketClientAdapter$connect$lambda$lambda_1(pendingConnect, cont, closure$url, listener);
        ws.onmessage = JsWebSocketClientAdapter$connect$lambda$lambda_2(listener);
      } catch (e) {
        if (Kotlin.isType(e, Exception)) {
          console.error('Exception in WebSocket setup: ' + toString(e.message));
          var exception = e;
          cont.resumeWith_tl1gpc$(new Result(createFailure(exception)));
        } else
          throw e;
      }
      return Unit;
    };
  }
  function Coroutine$connect_61zpoe$($this, url_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$url = url_0;
  }
  Coroutine$connect_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connect_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connect_61zpoe$.prototype.constructor = Coroutine$connect_61zpoe$;
  Coroutine$connect_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = suspendCancellableCoroutine$lambda(JsWebSocketClientAdapter$connect$lambda(this.$this, this.local$url))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  JsWebSocketClientAdapter.prototype.connect_61zpoe$ = function (url_0, continuation_0, suspended) {
    var instance = new Coroutine$connect_61zpoe$(this, url_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  JsWebSocketClientAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsWebSocketClientAdapter',
    interfaces: [WebSocketClient]
  };
  function JsWebSocketSession(ws, incomingFrames) {
    this.ws_0 = ws;
    this.incomingFrames_5tbuwo$_0 = incomingFrames;
  }
  Object.defineProperty(JsWebSocketSession.prototype, 'incomingFrames', {
    get: function () {
      return this.incomingFrames_5tbuwo$_0;
    }
  });
  Object.defineProperty(JsWebSocketSession.prototype, 'url', {
    configurable: true,
    get: function () {
      return this.ws_0.url;
    }
  });
  Object.defineProperty(JsWebSocketSession.prototype, 'canSend', {
    configurable: true,
    get: function () {
      return this.ws_0.readyState === WebSocket.OPEN;
    }
  });
  JsWebSocketSession.prototype.sendText_61zpoe$ = function (frameText, continuation) {
    this.ws_0.send(frameText);
  };
  JsWebSocketSession.prototype.sendBinary_fqrh44$ = function (frameData, continuation) {
    this.ws_0.send(toArrayBuffer(frameData));
  };
  JsWebSocketSession.prototype.close_vqvrqt$$default = function (code, reason, continuation) {
    this.ws_0.close(toShort(code), reason != null ? reason : '');
  };
  JsWebSocketSession.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsWebSocketSession',
    interfaces: [WebSocketSession]
  };
  function toByteArray($receiver) {
    var int8Array = new Int8Array($receiver);
    var array = new Int8Array(int8Array.length);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = int8Array[i];
    }
    return array;
  }
  function toArrayBuffer($receiver) {
    return (new Int8Array(toTypedArray($receiver))).buffer;
  }
  $$importsForInline$$['krossbow-krossbow-websocket-core'] = _;
  var package$org = _.org || (_.org = {});
  var package$hildan = package$org.hildan || (package$org.hildan = {});
  var package$krossbow = package$hildan.krossbow || (package$hildan.krossbow = {});
  var package$websocket = package$krossbow.websocket || (package$krossbow.websocket = {});
  package$websocket.PartialBinaryMessageHandler = PartialBinaryMessageHandler;
  package$websocket.PartialTextMessageHandler = PartialTextMessageHandler;
  package$websocket.WebSocketListenerChannelAdapter = WebSocketListenerChannelAdapter;
  package$websocket.WebSocketClient = WebSocketClient;
  package$websocket.WebSocketSession = WebSocketSession;
  package$websocket.WebSocketSessionWithPingPong = WebSocketSessionWithPingPong;
  WebSocketFrame.Text = WebSocketFrame$Text;
  WebSocketFrame.Binary = WebSocketFrame$Binary;
  WebSocketFrame.Ping = WebSocketFrame$Ping;
  WebSocketFrame.Pong = WebSocketFrame$Pong;
  WebSocketFrame.Close = WebSocketFrame$Close;
  package$websocket.WebSocketFrame = WebSocketFrame;
  package$websocket.WebSocketException = WebSocketException;
  package$websocket.WebSocketConnectionException = WebSocketConnectionException;
  package$websocket.WebSocketConnectionClosedException = WebSocketConnectionClosedException;
  Object.defineProperty(package$websocket, 'WebSocketCloseCodes', {
    get: WebSocketCloseCodes_getInstance
  });
  package$websocket.defaultWebSocketClient = defaultWebSocketClient;
  var package$js = package$websocket.js || (package$websocket.js = {});
  Object.defineProperty(package$js, 'BrowserWebSocketClient', {
    get: BrowserWebSocketClient_getInstance
  });
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  package$js.JsWebSocketClientAdapter = JsWebSocketClientAdapter;
  Object.defineProperty(WebSocketSessionWithPingPong.prototype, 'host', Object.getOwnPropertyDescriptor(WebSocketSession.prototype, 'host'));
  WebSocketSessionWithPingPong.prototype.close_vqvrqt$ = WebSocketSession.prototype.close_vqvrqt$;
  Object.defineProperty(JsWebSocketSession.prototype, 'host', Object.getOwnPropertyDescriptor(WebSocketSession.prototype, 'host'));
  JsWebSocketSession.prototype.close_vqvrqt$ = WebSocketSession.prototype.close_vqvrqt$;
  Kotlin.defineModule('krossbow-krossbow-websocket-core', _);
  return _;
}(module.exports, require('kotlin'), require('kotlinx-io'), require('kotlinx-coroutines-core')));

//# sourceMappingURL=krossbow-krossbow-websocket-core.js.map
