(function (_, Kotlin, $module$okio_parent_okio, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var Buffer = $module$okio_parent_okio.okio.Buffer;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var substringAfter = Kotlin.kotlin.text.substringAfter_j4ogox$;
  var substringBefore = Kotlin.kotlin.text.substringBefore_j4ogox$;
  var Exception = Kotlin.kotlin.Exception;
  var toString = Kotlin.toString;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var encodeToByteArray = Kotlin.kotlin.text.encodeToByteArray_pdl1vz$;
  var copyOf = Kotlin.kotlin.collections.copyOf_mrm5p$;
  var decodeToString = Kotlin.kotlin.text.decodeToString_964n91$;
  var unboxChar = Kotlin.unboxChar;
  var throwCCE = Kotlin.throwCCE;
  var get_indices = Kotlin.kotlin.text.get_indices_gw00vp$;
  var reversed = Kotlin.kotlin.ranges.reversed_zf1xzc$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var BufferOverflow = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.BufferOverflow;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var Duration = Kotlin.kotlin.time.Duration;
  var Unit = Kotlin.kotlin.Unit;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_cgako$;
  var CancellationException = Kotlin.kotlin.coroutines.cancellation.CancellationException;
  var cancel = $module$kotlinx_coroutines_core.kotlinx.coroutines.cancel_q2ti5d$;
  var coroutines = Kotlin.kotlin.coroutines;
  var Job = $module$kotlinx_coroutines_core.kotlinx.coroutines.Job_5dx9e$;
  var CoroutineName = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineName;
  var CoroutineScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineScope_1fupul$;
  var CoroutineStart = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineStart;
  var get_isActive = $module$kotlinx_coroutines_core.kotlinx.coroutines.get_isActive_e9pf1l$;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var JsMath = Math;
  var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
  var toShort = Kotlin.toShort;
  var toTypedArray = Kotlin.kotlin.collections.toTypedArray_964n91$;
  var Result = Kotlin.kotlin.Result;
  var createFailure = Kotlin.kotlin.createFailure_tcv7n7$;
  var intercepted = Kotlin.kotlin.coroutines.intrinsics.intercepted_f9mg25$;
  var CancellableContinuationImpl_init = $module$kotlinx_coroutines_core.kotlinx.coroutines.CancellableContinuationImpl;
  WebSocketException.prototype = Object.create(Exception.prototype);
  WebSocketException.prototype.constructor = WebSocketException;
  WebSocketConnectionException.prototype = Object.create(WebSocketException.prototype);
  WebSocketConnectionException.prototype.constructor = WebSocketConnectionException;
  WebSocketConnectionClosedException.prototype = Object.create(WebSocketConnectionException.prototype);
  WebSocketConnectionClosedException.prototype.constructor = WebSocketConnectionClosedException;
  WebSocketFrame$Text.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Text.prototype.constructor = WebSocketFrame$Text;
  WebSocketFrame$Binary.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Binary.prototype.constructor = WebSocketFrame$Binary;
  WebSocketFrame$Ping.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Ping.prototype.constructor = WebSocketFrame$Ping;
  WebSocketFrame$Pong.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Pong.prototype.constructor = WebSocketFrame$Pong;
  WebSocketFrame$Close.prototype = Object.create(WebSocketFrame.prototype);
  WebSocketFrame$Close.prototype.constructor = WebSocketFrame$Close;
  WebSocketReconnectionException.prototype = Object.create(WebSocketConnectionException.prototype);
  WebSocketReconnectionException.prototype.constructor = WebSocketReconnectionException;
  BrowserWebSocketClient.prototype = Object.create(JsWebSocketClientAdapter.prototype);
  BrowserWebSocketClient.prototype.constructor = BrowserWebSocketClient;
  function PartialBinaryMessageHandler(onMessageComplete) {
    this.onMessageComplete_0 = onMessageComplete;
    this.buffer_0 = new Buffer();
  }
  function Coroutine$processMessage_1fhb37$($this, bytes_0, isLast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$bytes = bytes_0;
    this.local$isLast = isLast_0;
  }
  Coroutine$processMessage_1fhb37$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$processMessage_1fhb37$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$processMessage_1fhb37$.prototype.constructor = Coroutine$processMessage_1fhb37$;
  Coroutine$processMessage_1fhb37$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$isLast === void 0)
              this.local$isLast = true;
            if (this.$this.buffer_0.exhausted() && this.local$isLast) {
              this.state_0 = 4;
              this.result_0 = this.$this.onMessageComplete_0(this.local$bytes, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.$this.buffer_0.write_fqrh44$(this.local$bytes);
              if (this.local$isLast) {
                var fullMsg = this.$this.buffer_0.readByteArray();
                this.state_0 = 2;
                this.result_0 = this.$this.onMessageComplete_0(fullMsg, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                this.state_0 = 3;
                continue;
              }
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            continue;
          case 3:
            this.state_0 = 5;
            continue;
          case 4:
            this.state_0 = 5;
            continue;
          case 5:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PartialBinaryMessageHandler.prototype.processMessage_1fhb37$ = function (bytes_0, isLast_0, continuation_0, suspended) {
    var instance = new Coroutine$processMessage_1fhb37$(this, bytes_0, isLast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  PartialBinaryMessageHandler.prototype.close = function () {
    this.buffer_0.close();
  };
  PartialBinaryMessageHandler.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PartialBinaryMessageHandler',
    interfaces: []
  };
  function PartialTextMessageHandler(onMessageComplete) {
    this.onMessageComplete_0 = onMessageComplete;
    this.textBuilder_0 = StringBuilder_init();
  }
  function Coroutine$processMessage_7tcg9p$($this, text_0, isLast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$text = text_0;
    this.local$isLast = isLast_0;
  }
  Coroutine$processMessage_7tcg9p$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$processMessage_7tcg9p$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$processMessage_7tcg9p$.prototype.constructor = Coroutine$processMessage_7tcg9p$;
  Coroutine$processMessage_7tcg9p$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$isLast === void 0)
              this.local$isLast = true;
            if (this.$this.textBuilder_0.length === 0 && this.local$isLast) {
              this.state_0 = 4;
              this.result_0 = this.$this.onMessageComplete_0(this.local$text, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.$this.textBuilder_0.append_gw00v9$(this.local$text);
              if (this.local$isLast) {
                var $receiver = this.$this.textBuilder_0.toString();
                this.$this.textBuilder_0.clear();
                var fullMsg = $receiver;
                this.state_0 = 2;
                this.result_0 = this.$this.onMessageComplete_0(fullMsg, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                this.state_0 = 3;
                continue;
              }
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            continue;
          case 3:
            this.state_0 = 5;
            continue;
          case 4:
            this.state_0 = 5;
            continue;
          case 5:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PartialTextMessageHandler.prototype.processMessage_7tcg9p$ = function (text_0, isLast_0, continuation_0, suspended) {
    var instance = new Coroutine$processMessage_7tcg9p$(this, text_0, isLast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  PartialTextMessageHandler.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PartialTextMessageHandler',
    interfaces: []
  };
  function processPartialMessage(msg, isLast, isBufferEmpty, appendToBuffer, readAndClearBuffer, onMessageComplete) {
    if (isBufferEmpty && isLast) {
      onMessageComplete(msg);
    } else {
      appendToBuffer(msg);
      if (isLast) {
        var fullMsg = readAndClearBuffer();
        onMessageComplete(fullMsg);
      }}
  }
  function WebSocketClient() {
  }
  WebSocketClient.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'WebSocketClient',
    interfaces: []
  };
  function WebSocketConnection() {
  }
  Object.defineProperty(WebSocketConnection.prototype, 'host', {
    configurable: true,
    get: function () {
      return substringBefore(substringBefore(substringAfter(this.url, '://'), '/'), ':');
    }
  });
  WebSocketConnection.prototype.close_vqvrqt$ = function (code, reason, continuation, callback$default) {
    if (code === void 0)
      code = 1000;
    if (reason === void 0)
      reason = null;
    return callback$default ? callback$default(code, reason, continuation) : this.close_vqvrqt$$default(code, reason, continuation);
  };
  WebSocketConnection.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'WebSocketConnection',
    interfaces: []
  };
  function WebSocketConnectionWithPingPong() {
  }
  WebSocketConnectionWithPingPong.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'WebSocketConnectionWithPingPong',
    interfaces: [WebSocketConnection]
  };
  function WebSocketException(message, cause) {
    if (cause === void 0)
      cause = null;
    Exception.call(this, message, cause);
    this.name = 'WebSocketException';
  }
  WebSocketException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketException',
    interfaces: [Exception]
  };
  function WebSocketConnectionException(url, message, cause) {
    if (message === void 0)
      message = "Couldn't connect to web socket at " + url;
    if (cause === void 0)
      cause = null;
    WebSocketException.call(this, message, cause);
    this.url = url;
    this.name = 'WebSocketConnectionException';
  }
  WebSocketConnectionException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketConnectionException',
    interfaces: [WebSocketException]
  };
  function WebSocketConnectionClosedException(url, code, reason) {
    WebSocketConnectionException.call(this, url, "Couldn't connect to web socket at " + url + '. The server closed the connection. Code: ' + code + ' Reason: ' + toString(reason));
    this.code = code;
    this.reason = reason;
    this.name = 'WebSocketConnectionClosedException';
  }
  WebSocketConnectionClosedException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketConnectionClosedException',
    interfaces: [WebSocketConnectionException]
  };
  function WebSocketCloseCodes() {
    WebSocketCloseCodes_instance = this;
    this.NORMAL_CLOSURE = 1000;
    this.GOING_AWAY = 1001;
    this.PROTOCOL_ERROR = 1002;
    this.NOT_ACCEPTABLE = 1003;
    this.NO_STATUS_CODE = 1005;
    this.NO_CLOSE_FRAME = 1006;
    this.BAD_DATA = 1007;
    this.POLICY_VIOLATION = 1008;
    this.TOO_BIG_TO_PROCESS = 1009;
    this.REQUIRED_EXTENSION = 1010;
    this.SERVER_ERROR = 1011;
    this.SERVICE_RESTARTED = 1012;
    this.SERVICE_OVERLOAD = 1013;
    this.TLS_HANDSHAKE_FAILURE = 1015;
  }
  WebSocketCloseCodes.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'WebSocketCloseCodes',
    interfaces: []
  };
  var WebSocketCloseCodes_instance = null;
  function WebSocketCloseCodes_getInstance() {
    if (WebSocketCloseCodes_instance === null) {
      new WebSocketCloseCodes();
    }return WebSocketCloseCodes_instance;
  }
  var CLOSE_REASON_MAX_LENGTH_BYTES;
  function truncateToCloseFrameReasonLength($receiver) {
    return truncateUtf8BytesLengthTo($receiver, 123);
  }
  function truncateUtf8BytesLengthTo($receiver, maxLength) {
    if ($receiver.length <= (maxLength / 4 | 0)) {
      return $receiver;
    }var utf8Bytes = encodeToByteArray($receiver);
    if (utf8Bytes.length <= maxLength) {
      return $receiver;
    }var $receiver_0 = decodeToString(copyOf(utf8Bytes, maxLength));
    var tmp$;
    var $receiver_0_0 = Kotlin.isCharSequence(tmp$ = $receiver_0) ? tmp$ : throwCCE();
    var trimEnd$result;
    trimEnd$break: do {
      var tmp$_0;
      tmp$_0 = reversed(get_indices($receiver_0_0)).iterator();
      while (tmp$_0.hasNext()) {
        var index = tmp$_0.next();
        if (!(unboxChar(toBoxedChar($receiver_0_0.charCodeAt(index))) === 65533)) {
          trimEnd$result = Kotlin.subSequence($receiver_0_0, 0, index + 1 | 0);
          break trimEnd$break;
        }}
      trimEnd$result = '';
    }
     while (false);
    return trimEnd$result.toString();
  }
  function WebSocketFrame() {
  }
  function WebSocketFrame$Text(text) {
    WebSocketFrame.call(this);
    this.text = text;
  }
  WebSocketFrame$Text.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Text',
    interfaces: [WebSocketFrame]
  };
  WebSocketFrame$Text.prototype.component1 = function () {
    return this.text;
  };
  WebSocketFrame$Text.prototype.copy_61zpoe$ = function (text) {
    return new WebSocketFrame$Text(text === void 0 ? this.text : text);
  };
  WebSocketFrame$Text.prototype.toString = function () {
    return 'Text(text=' + Kotlin.toString(this.text) + ')';
  };
  WebSocketFrame$Text.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    return result;
  };
  WebSocketFrame$Text.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.text, other.text))));
  };
  function WebSocketFrame$Binary(bytes) {
    WebSocketFrame.call(this);
    this.bytes = bytes;
  }
  WebSocketFrame$Binary.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Binary',
    interfaces: [WebSocketFrame]
  };
  function WebSocketFrame$Ping(bytes) {
    WebSocketFrame.call(this);
    this.bytes = bytes;
  }
  WebSocketFrame$Ping.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Ping',
    interfaces: [WebSocketFrame]
  };
  function WebSocketFrame$Pong(bytes) {
    WebSocketFrame.call(this);
    this.bytes = bytes;
  }
  WebSocketFrame$Pong.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Pong',
    interfaces: [WebSocketFrame]
  };
  function WebSocketFrame$Close(code, reason) {
    WebSocketFrame.call(this);
    this.code = code;
    this.reason = reason;
  }
  WebSocketFrame$Close.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Close',
    interfaces: [WebSocketFrame]
  };
  WebSocketFrame$Close.prototype.component1 = function () {
    return this.code;
  };
  WebSocketFrame$Close.prototype.component2 = function () {
    return this.reason;
  };
  WebSocketFrame$Close.prototype.copy_vqvrqt$ = function (code, reason) {
    return new WebSocketFrame$Close(code === void 0 ? this.code : code, reason === void 0 ? this.reason : reason);
  };
  WebSocketFrame$Close.prototype.toString = function () {
    return 'Close(code=' + Kotlin.toString(this.code) + (', reason=' + Kotlin.toString(this.reason)) + ')';
  };
  WebSocketFrame$Close.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.code) | 0;
    result = result * 31 + Kotlin.hashCode(this.reason) | 0;
    return result;
  };
  WebSocketFrame$Close.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.code, other.code) && Kotlin.equals(this.reason, other.reason)))));
  };
  WebSocketFrame.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketFrame',
    interfaces: []
  };
  function WebSocketListenerChannelAdapter(bufferSize, onBufferOverflow) {
    if (bufferSize === void 0)
      bufferSize = -2;
    if (onBufferOverflow === void 0)
      onBufferOverflow = BufferOverflow.SUSPEND;
    this.frames_0 = Channel(bufferSize, onBufferOverflow);
    this.partialTextMessageHandler_0 = new PartialTextMessageHandler(WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda(this));
    this.partialBinaryMessageHandler_0 = new PartialBinaryMessageHandler(WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda(this));
  }
  Object.defineProperty(WebSocketListenerChannelAdapter.prototype, 'incomingFrames', {
    configurable: true,
    get: function () {
      return this.frames_0;
    }
  });
  function Coroutine$onBinaryMessage_1fhb37$($this, bytes_0, isLast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$bytes = bytes_0;
    this.local$isLast = isLast_0;
  }
  Coroutine$onBinaryMessage_1fhb37$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onBinaryMessage_1fhb37$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onBinaryMessage_1fhb37$.prototype.constructor = Coroutine$onBinaryMessage_1fhb37$;
  Coroutine$onBinaryMessage_1fhb37$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$isLast === void 0)
              this.local$isLast = true;
            this.state_0 = 2;
            this.result_0 = this.$this.partialBinaryMessageHandler_0.processMessage_1fhb37$(this.local$bytes, this.local$isLast, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onBinaryMessage_1fhb37$ = function (bytes_0, isLast_0, continuation_0, suspended) {
    var instance = new Coroutine$onBinaryMessage_1fhb37$(this, bytes_0, isLast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$onTextMessage_7tcg9p$($this, text_0, isLast_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$text = text_0;
    this.local$isLast = isLast_0;
  }
  Coroutine$onTextMessage_7tcg9p$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onTextMessage_7tcg9p$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onTextMessage_7tcg9p$.prototype.constructor = Coroutine$onTextMessage_7tcg9p$;
  Coroutine$onTextMessage_7tcg9p$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$isLast === void 0)
              this.local$isLast = true;
            this.state_0 = 2;
            this.result_0 = this.$this.partialTextMessageHandler_0.processMessage_7tcg9p$(this.local$text, this.local$isLast, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onTextMessage_7tcg9p$ = function (text_0, isLast_0, continuation_0, suspended) {
    var instance = new Coroutine$onTextMessage_7tcg9p$(this, text_0, isLast_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$onPing_fqrh44$($this, bytes_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$bytes = bytes_0;
  }
  Coroutine$onPing_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onPing_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onPing_fqrh44$.prototype.constructor = Coroutine$onPing_fqrh44$;
  Coroutine$onPing_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.frames_0.send_11rb$(new WebSocketFrame$Ping(this.local$bytes), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onPing_fqrh44$ = function (bytes_0, continuation_0, suspended) {
    var instance = new Coroutine$onPing_fqrh44$(this, bytes_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$onPong_fqrh44$($this, bytes_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$bytes = bytes_0;
  }
  Coroutine$onPong_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onPong_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onPong_fqrh44$.prototype.constructor = Coroutine$onPong_fqrh44$;
  Coroutine$onPong_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.frames_0.send_11rb$(new WebSocketFrame$Pong(this.local$bytes), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onPong_fqrh44$ = function (bytes_0, continuation_0, suspended) {
    var instance = new Coroutine$onPong_fqrh44$(this, bytes_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$onClose_vqvrqt$($this, code_0, reason_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$code = code_0;
    this.local$reason = reason_0;
  }
  Coroutine$onClose_vqvrqt$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onClose_vqvrqt$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onClose_vqvrqt$.prototype.constructor = Coroutine$onClose_vqvrqt$;
  Coroutine$onClose_vqvrqt$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.frames_0.send_11rb$(new WebSocketFrame$Close(this.local$code, this.local$reason), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.$this.frames_0.close_dbl4no$();
            this.$this.partialBinaryMessageHandler_0.close();
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketListenerChannelAdapter.prototype.onClose_vqvrqt$ = function (code_0, reason_0, continuation_0, suspended) {
    var instance = new Coroutine$onClose_vqvrqt$(this, code_0, reason_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  WebSocketListenerChannelAdapter.prototype.onError_61zpoe$ = function (message) {
    this.frames_0.close_dbl4no$(new WebSocketException(message));
    this.partialBinaryMessageHandler_0.close();
  };
  WebSocketListenerChannelAdapter.prototype.onError_dbl4no$ = function (error) {
    var tmp$;
    this.frames_0.close_dbl4no$(new WebSocketException((tmp$ = error != null ? error.message : null) != null ? tmp$ : 'web socket error', error));
    this.partialBinaryMessageHandler_0.close();
  };
  function Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$WebSocketListenerChannelAdapter = this$WebSocketListenerChannelAdapter_0;
    this.local$it = it_0;
  }
  Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda.prototype.constructor = Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda;
  Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$WebSocketListenerChannelAdapter.frames_0.send_11rb$(new WebSocketFrame$Text(this.local$it.toString()), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$WebSocketListenerChannelAdapter$partialTextMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$WebSocketListenerChannelAdapter = this$WebSocketListenerChannelAdapter_0;
    this.local$it = it_0;
  }
  Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda.prototype.constructor = Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda;
  Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$WebSocketListenerChannelAdapter.frames_0.send_11rb$(new WebSocketFrame$Binary(this.local$it), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$WebSocketListenerChannelAdapter$partialBinaryMessageHandler$lambda(this$WebSocketListenerChannelAdapter_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  WebSocketListenerChannelAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketListenerChannelAdapter',
    interfaces: []
  };
  function UnboundedWsListenerChannelAdapter() {
    this.frames_0 = Channel(2147483647);
  }
  Object.defineProperty(UnboundedWsListenerChannelAdapter.prototype, 'incomingFrames', {
    configurable: true,
    get: function () {
      return this.frames_0;
    }
  });
  UnboundedWsListenerChannelAdapter.prototype.onBinaryMessage_fqrh44$ = function (bytes) {
    return this.frames_0.trySend_11rb$(new WebSocketFrame$Binary(bytes));
  };
  UnboundedWsListenerChannelAdapter.prototype.onTextMessage_61zpoe$ = function (text) {
    return this.frames_0.trySend_11rb$(new WebSocketFrame$Text(text));
  };
  UnboundedWsListenerChannelAdapter.prototype.onPing_fqrh44$ = function (bytes) {
    return this.frames_0.trySend_11rb$(new WebSocketFrame$Ping(bytes));
  };
  UnboundedWsListenerChannelAdapter.prototype.onPong_fqrh44$ = function (bytes) {
    return this.frames_0.trySend_11rb$(new WebSocketFrame$Pong(bytes));
  };
  UnboundedWsListenerChannelAdapter.prototype.onClose_vqvrqt$ = function (code, reason) {
    var result = this.frames_0.trySend_11rb$(new WebSocketFrame$Close(code, reason));
    this.frames_0.close_dbl4no$();
    return result;
  };
  UnboundedWsListenerChannelAdapter.prototype.onError_61zpoe$ = function (message) {
    this.frames_0.close_dbl4no$(new WebSocketException(message));
  };
  UnboundedWsListenerChannelAdapter.prototype.onError_dbl4no$ = function (error) {
    var tmp$;
    this.frames_0.close_dbl4no$(new WebSocketException((tmp$ = error != null ? error.message : null) != null ? tmp$ : 'web socket error', error));
  };
  UnboundedWsListenerChannelAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnboundedWsListenerChannelAdapter',
    interfaces: []
  };
  var DEFAULT_MAX_ATTEMPTS;
  var DEFAULT_DELAY_STRATEGY;
  function reconnectConfig(configure) {
    var $receiver = new ReconnectConfigBuilder();
    configure($receiver);
    return $receiver.build_8be2vx$();
  }
  function ReconnectConfig(maxAttempts, delayStrategy, afterReconnect) {
    if (maxAttempts === void 0)
      maxAttempts = 5;
    if (delayStrategy === void 0)
      delayStrategy = DEFAULT_DELAY_STRATEGY;
    if (afterReconnect === void 0)
      afterReconnect = ReconnectConfig_init$lambda;
    this.maxAttempts = maxAttempts;
    this.delayStrategy = delayStrategy;
    this.afterReconnect = afterReconnect;
    if (!(this.maxAttempts >= 0)) {
      var message = 'Max number of attempts must not be negative, got ' + this.maxAttempts;
      throw IllegalArgumentException_init(message.toString());
    }}
  function Coroutine$ReconnectConfig_init$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$ReconnectConfig_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ReconnectConfig_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ReconnectConfig_init$lambda.prototype.constructor = Coroutine$ReconnectConfig_init$lambda;
  Coroutine$ReconnectConfig_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ReconnectConfig_init$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ReconnectConfig_init$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ReconnectConfig.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ReconnectConfig',
    interfaces: []
  };
  ReconnectConfig.prototype.component1 = function () {
    return this.maxAttempts;
  };
  ReconnectConfig.prototype.component2 = function () {
    return this.delayStrategy;
  };
  ReconnectConfig.prototype.component3 = function () {
    return this.afterReconnect;
  };
  ReconnectConfig.prototype.copy_nh8qkh$ = function (maxAttempts, delayStrategy, afterReconnect) {
    return new ReconnectConfig(maxAttempts === void 0 ? this.maxAttempts : maxAttempts, delayStrategy === void 0 ? this.delayStrategy : delayStrategy, afterReconnect === void 0 ? this.afterReconnect : afterReconnect);
  };
  ReconnectConfig.prototype.toString = function () {
    return 'ReconnectConfig(maxAttempts=' + Kotlin.toString(this.maxAttempts) + (', delayStrategy=' + Kotlin.toString(this.delayStrategy)) + (', afterReconnect=' + Kotlin.toString(this.afterReconnect)) + ')';
  };
  ReconnectConfig.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.maxAttempts) | 0;
    result = result * 31 + Kotlin.hashCode(this.delayStrategy) | 0;
    result = result * 31 + Kotlin.hashCode(this.afterReconnect) | 0;
    return result;
  };
  ReconnectConfig.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.maxAttempts, other.maxAttempts) && Kotlin.equals(this.delayStrategy, other.delayStrategy) && Kotlin.equals(this.afterReconnect, other.afterReconnect)))));
  };
  function ReconnectConfigBuilder() {
    this.maxAttempts = 5;
    this.delayStrategy = DEFAULT_DELAY_STRATEGY;
    this.afterReconnect_0 = ReconnectConfigBuilder$afterReconnect$lambda;
  }
  ReconnectConfigBuilder.prototype.afterReconnect_h97xnj$ = function (body) {
    this.afterReconnect_0 = body;
  };
  ReconnectConfigBuilder.prototype.build_8be2vx$ = function () {
    return new ReconnectConfig(this.maxAttempts, this.delayStrategy, this.afterReconnect_0);
  };
  function Coroutine$ReconnectConfigBuilder$afterReconnect$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$ReconnectConfigBuilder$afterReconnect$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ReconnectConfigBuilder$afterReconnect$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ReconnectConfigBuilder$afterReconnect$lambda.prototype.constructor = Coroutine$ReconnectConfigBuilder$afterReconnect$lambda;
  Coroutine$ReconnectConfigBuilder$afterReconnect$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ReconnectConfigBuilder$afterReconnect$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ReconnectConfigBuilder$afterReconnect$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ReconnectConfigBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ReconnectConfigBuilder',
    interfaces: []
  };
  function withAutoReconnect($receiver, config) {
    if (Kotlin.isType($receiver, ReconnectingWebSocketClient))
      return new ReconnectingWebSocketClient($receiver.baseClient, config);
    else
      return new ReconnectingWebSocketClient($receiver, config);
  }
  function withAutoReconnect_0($receiver, configure) {
    return withAutoReconnect($receiver, reconnectConfig(configure));
  }
  function withAutoReconnect$lambda(closure$maxAttempts, closure$delayStrategy) {
    return function ($receiver) {
      $receiver.maxAttempts = closure$maxAttempts;
      $receiver.delayStrategy = closure$delayStrategy;
      return Unit;
    };
  }
  function withAutoReconnect_1($receiver, maxAttempts, delayStrategy) {
    if (maxAttempts === void 0)
      maxAttempts = 5;
    if (delayStrategy === void 0)
      delayStrategy = DEFAULT_DELAY_STRATEGY;
    return withAutoReconnect_0($receiver, withAutoReconnect$lambda(maxAttempts, delayStrategy));
  }
  function ReconnectingWebSocketClient(baseClient, reconnectConfig) {
    this.baseClient = baseClient;
    this.reconnectConfig_0 = reconnectConfig;
  }
  function Coroutine$connect_61zpoe$($this, url_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$url = url_0;
  }
  Coroutine$connect_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connect_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connect_61zpoe$.prototype.constructor = Coroutine$connect_61zpoe$;
  Coroutine$connect_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.baseClient.connect_61zpoe$(this.local$url, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var firstConnection = this.result_0;
            return new WebSocketConnectionProxy(this.$this.baseClient, this.$this.reconnectConfig_0, firstConnection);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ReconnectingWebSocketClient.prototype.connect_61zpoe$ = function (url_0, continuation_0, suspended) {
    var instance = new Coroutine$connect_61zpoe$(this, url_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ReconnectingWebSocketClient.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ReconnectingWebSocketClient',
    interfaces: [WebSocketClient]
  };
  function WebSocketConnectionProxy(baseClient, reconnectConfig, currentConnection) {
    this.baseClient_0 = baseClient;
    this.reconnectConfig_0 = reconnectConfig;
    this.currentConnection_0 = currentConnection;
    this.scope_0 = CoroutineScope(coroutines.EmptyCoroutineContext.plus_1fupul$(Job()).plus_1fupul$(new CoroutineName('krossbow-reconnection-watcher')));
    this._frames_0 = Channel();
    launch(this.scope_0, void 0, CoroutineStart.UNDISPATCHED, WebSocketConnectionProxy_init$lambda(this));
  }
  Object.defineProperty(WebSocketConnectionProxy.prototype, 'url', {
    configurable: true,
    get: function () {
      return this.currentConnection_0.url;
    }
  });
  Object.defineProperty(WebSocketConnectionProxy.prototype, 'canSend', {
    configurable: true,
    get: function () {
      return this.currentConnection_0.canSend;
    }
  });
  Object.defineProperty(WebSocketConnectionProxy.prototype, 'incomingFrames', {
    configurable: true,
    get: function () {
      return this._frames_0;
    }
  });
  function Coroutine$reconnect_0($this, cause_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 7;
    this.$this = $this;
    this.local$lastAttemptException = void 0;
    this.local$times = void 0;
    this.local$index = void 0;
    this.local$cause = cause_0;
  }
  Coroutine$reconnect_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$reconnect_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$reconnect_0.prototype.constructor = Coroutine$reconnect_0;
  Coroutine$reconnect_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$lastAttemptException = {v: this.local$cause};
            this.local$times = this.$this.reconnectConfig_0.maxAttempts;
            this.local$index = 0;
            this.state_0 = 1;
            continue;
          case 1:
            if (this.local$index >= this.local$times) {
              this.state_0 = 8;
              continue;
            }
            this.exceptionState_0 = 4;
            this.state_0 = 2;
            this.result_0 = delay(this.$this.reconnectConfig_0.delayStrategy.computeDelay_za3lpa$(this.local$index), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.$this.baseClient_0.connect_61zpoe$(this.$this.currentConnection_0.url, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          case 4:
            this.exceptionState_0 = 7;
            var e_0 = this.exception_0;
            if (Kotlin.isType(e_0, CancellationException)) {
              throw e_0;
            } else if (Kotlin.isType(e_0, Exception)) {
              this.local$lastAttemptException.v = e_0;
            } else
              throw e_0;
            this.state_0 = 5;
            continue;
          case 5:
            this.state_0 = 6;
            continue;
          case 6:
            this.local$index++;
            this.state_0 = 1;
            continue;
          case 7:
            throw this.exception_0;
          case 8:
            throw new WebSocketReconnectionException(this.$this.currentConnection_0.url, this.$this.reconnectConfig_0.maxAttempts, this.local$lastAttemptException.v);
          default:this.state_0 = 7;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 7) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionProxy.prototype.reconnect_0 = function (cause_0, continuation_0, suspended) {
    var instance = new Coroutine$reconnect_0(this, cause_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$sendText_61zpoe$($this, frameText_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frameText = frameText_0;
  }
  Coroutine$sendText_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendText_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendText_61zpoe$.prototype.constructor = Coroutine$sendText_61zpoe$;
  Coroutine$sendText_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.currentConnection_0.sendText_61zpoe$(this.local$frameText, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionProxy.prototype.sendText_61zpoe$ = function (frameText_0, continuation_0, suspended) {
    var instance = new Coroutine$sendText_61zpoe$(this, frameText_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$sendBinary_fqrh44$($this, frameData_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frameData = frameData_0;
  }
  Coroutine$sendBinary_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendBinary_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendBinary_fqrh44$.prototype.constructor = Coroutine$sendBinary_fqrh44$;
  Coroutine$sendBinary_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.currentConnection_0.sendBinary_fqrh44$(this.local$frameData, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionProxy.prototype.sendBinary_fqrh44$ = function (frameData_0, continuation_0, suspended) {
    var instance = new Coroutine$sendBinary_fqrh44$(this, frameData_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$close_vqvrqt$$default($this, code_0, reason_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$code = code_0;
    this.local$reason = reason_0;
  }
  Coroutine$close_vqvrqt$$default.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$close_vqvrqt$$default.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$close_vqvrqt$$default.prototype.constructor = Coroutine$close_vqvrqt$$default;
  Coroutine$close_vqvrqt$$default.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.currentConnection_0.close_vqvrqt$(this.local$code, this.local$reason, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            cancel(this.$this.scope_0);
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionProxy.prototype.close_vqvrqt$$default = function (code_0, reason_0, continuation_0, suspended) {
    var instance = new Coroutine$close_vqvrqt$$default(this, code_0, reason_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$WebSocketConnectionProxy_init$lambda(this$WebSocketConnectionProxy_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 16;
    this.local$this$WebSocketConnectionProxy = this$WebSocketConnectionProxy_0;
    this.local$tmp$ = void 0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$WebSocketConnectionProxy_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$WebSocketConnectionProxy_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$WebSocketConnectionProxy_init$lambda.prototype.constructor = Coroutine$WebSocketConnectionProxy_init$lambda;
  Coroutine$WebSocketConnectionProxy_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 1;
            continue;
          case 1:
            if (!get_isActive(this.local$$receiver)) {
              this.state_0 = 17;
              continue;
            }
            this.exceptionState_0 = 7;
            this.local$tmp$ = this.local$this$WebSocketConnectionProxy.currentConnection_0.incomingFrames.iterator();
            this.state_0 = 2;
            continue;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$tmp$.hasNext(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            if (!this.result_0) {
              this.state_0 = 6;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 4:
            var f = this.local$tmp$.next();
            this.state_0 = 5;
            this.result_0 = this.local$this$WebSocketConnectionProxy._frames_0.send_11rb$(f, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 5:
            this.state_0 = 2;
            continue;
          case 6:
            this.exceptionState_0 = 16;
            this.state_0 = 15;
            continue;
          case 7:
            this.exceptionState_0 = 16;
            var e = this.exception_0;
            if (Kotlin.isType(e, CancellationException)) {
              throw e;
            } else {
              if (Kotlin.isType(e, Exception)) {
                this.exceptionState_0 = 10;
                this.state_0 = 8;
                this.result_0 = this.local$this$WebSocketConnectionProxy.reconnect_0(e, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                throw e;
              }
            }

          case 8:
            this.local$this$WebSocketConnectionProxy.currentConnection_0 = this.result_0;
            this.state_0 = 9;
            this.result_0 = this.local$this$WebSocketConnectionProxy.reconnectConfig_0.afterReconnect(this.local$this$WebSocketConnectionProxy, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 9:
            this.exceptionState_0 = 16;
            this.state_0 = 12;
            continue;
          case 10:
            this.exceptionState_0 = 16;
            var e = this.exception_0;
            if (Kotlin.isType(e, WebSocketReconnectionException)) {
              this.local$this$WebSocketConnectionProxy._frames_0.close_dbl4no$(e);
              this.exceptionState_0 = 7;
              this.state_0 = 17;
              continue;
            } else {
              throw e;
            }

          case 11:
            this.state_0 = 12;
            continue;
          case 12:
            this.state_0 = 13;
            continue;
          case 13:
            this.state_0 = 14;
            continue;
          case 14:
            this.state_0 = 15;
            continue;
          case 15:
            this.state_0 = 1;
            continue;
          case 16:
            throw this.exception_0;
          case 17:
            return Unit;
          default:this.state_0 = 16;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 16) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function WebSocketConnectionProxy_init$lambda(this$WebSocketConnectionProxy_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$WebSocketConnectionProxy_init$lambda(this$WebSocketConnectionProxy_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  WebSocketConnectionProxy.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketConnectionProxy',
    interfaces: [WebSocketConnection]
  };
  function WebSocketReconnectionException(url, nAttemptedReconnections, cause, message) {
    if (message === void 0)
      message = 'Could not reconnect to web socket at ' + url + ' after ' + nAttemptedReconnections + ' attempts. Giving up.';
    WebSocketConnectionException.call(this, url, message, cause);
    this.nAttemptedReconnections = nAttemptedReconnections;
    this.name = 'WebSocketReconnectionException';
  }
  WebSocketReconnectionException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketReconnectionException',
    interfaces: [WebSocketConnectionException]
  };
  function RetryDelayStrategy() {
  }
  RetryDelayStrategy.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'RetryDelayStrategy',
    interfaces: []
  };
  function FixedDelay(delay) {
    this.delay_0 = delay;
  }
  FixedDelay.prototype.computeDelay_za3lpa$ = function (attempt) {
    return this.delay_0;
  };
  FixedDelay.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FixedDelay',
    interfaces: [RetryDelayStrategy]
  };
  function ExponentialBackOff(initialDelay, factor) {
    if (initialDelay === void 0)
      initialDelay = Duration.Companion.seconds_za3lpa$(1);
    if (factor === void 0)
      factor = 2.0;
    this.initialDelay_0 = initialDelay;
    this.factor_0 = factor;
  }
  ExponentialBackOff.prototype.computeDelay_za3lpa$ = function (attempt) {
    var tmp$ = this.initialDelay_0;
    var $receiver = this.factor_0;
    return tmp$.times_14dthe$(JsMath.pow($receiver, attempt));
  };
  ExponentialBackOff.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExponentialBackOff',
    interfaces: [RetryDelayStrategy]
  };
  function defaultWebSocketClient() {
    return BrowserWebSocketClient_getInstance();
  }
  function suspendCancellableCoroutine$lambda(closure$block) {
    return function (uCont) {
      var cancellable = new CancellableContinuationImpl_init(intercepted(uCont), 1);
      cancellable.initCancellability();
      closure$block(cancellable);
      return cancellable.getResult();
    };
  }
  function BrowserWebSocketClient() {
    BrowserWebSocketClient_instance = this;
    JsWebSocketClientAdapter.call(this, BrowserWebSocketClient_init$lambda);
  }
  function BrowserWebSocketClient_init$lambda(url) {
    return new WebSocket(url);
  }
  BrowserWebSocketClient.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BrowserWebSocketClient',
    interfaces: [JsWebSocketClientAdapter]
  };
  var BrowserWebSocketClient_instance = null;
  function BrowserWebSocketClient_getInstance() {
    if (BrowserWebSocketClient_instance === null) {
      new BrowserWebSocketClient();
    }return BrowserWebSocketClient_instance;
  }
  function JsWebSocketClientAdapter(newWebSocket) {
    this.newWebSocket_wgl7q3$_0 = newWebSocket;
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda(closure$pendingConnect, closure$cont, closure$wsSession) {
    return function (it) {
      closure$pendingConnect.v = false;
      var $receiver = closure$cont;
      var value = closure$wsSession;
      $receiver.resumeWith_tl1gpc$(new Result(value));
      return Unit;
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_0(closure$pendingConnect, closure$cont, closure$url, closure$listener) {
    return function (event) {
      var closeEvent = event;
      var code = closeEvent.code;
      if (closure$pendingConnect.v) {
        closure$pendingConnect.v = false;
        var $receiver = closure$cont;
        var exception = new WebSocketConnectionClosedException(closure$url, code, closeEvent.reason);
        $receiver.resumeWith_tl1gpc$(new Result(createFailure(exception)));
        return Unit;
      } else {
        return closure$listener.onClose_vqvrqt$(code, closeEvent.reason);
      }
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_1(closure$pendingConnect, closure$cont, closure$url, closure$listener) {
    return function (event) {
      var errorEvent = event;
      if (closure$pendingConnect.v) {
        closure$pendingConnect.v = false;
        var $receiver = closure$cont;
        var exception = new WebSocketConnectionException(closure$url, errorEvent.message);
        $receiver.resumeWith_tl1gpc$(new Result(createFailure(exception)));
      } else {
        closure$listener.onError_61zpoe$(errorEvent.message);
      }
      return Unit;
    };
  }
  function JsWebSocketClientAdapter$connect$lambda$lambda_2(closure$listener) {
    return function (event) {
      var body = event.data;
      if (Kotlin.isType(body, ArrayBuffer))
        return closure$listener.onBinaryMessage_fqrh44$(toByteArray(body));
      else if (typeof body === 'string')
        return closure$listener.onTextMessage_61zpoe$(body);
      else if (body == null)
        return closure$listener.onTextMessage_61zpoe$('');
      else
        return closure$listener.onError_61zpoe$('Unknown socket frame body type: ' + get_js(Kotlin.getKClassFromExpression(body))), Unit;
    };
  }
  function JsWebSocketClientAdapter$connect$lambda(this$JsWebSocketClientAdapter, closure$url) {
    return function (cont) {
      try {
        var ws = this$JsWebSocketClientAdapter.newWebSocket_wgl7q3$_0(closure$url);
        ws.binaryType = 'arraybuffer';
        var pendingConnect = {v: true};
        var listener = new UnboundedWsListenerChannelAdapter();
        var wsSession = new JsWebSocketConnection(ws, listener.incomingFrames);
        ws.onopen = JsWebSocketClientAdapter$connect$lambda$lambda(pendingConnect, cont, wsSession);
        ws.onclose = JsWebSocketClientAdapter$connect$lambda$lambda_0(pendingConnect, cont, closure$url, listener);
        ws.onerror = JsWebSocketClientAdapter$connect$lambda$lambda_1(pendingConnect, cont, closure$url, listener);
        ws.onmessage = JsWebSocketClientAdapter$connect$lambda$lambda_2(listener);
      } catch (e) {
        if (Kotlin.isType(e, Exception)) {
          console.error('Exception in WebSocket setup: ' + toString(e.message));
          var exception = e;
          cont.resumeWith_tl1gpc$(new Result(createFailure(exception)));
        } else
          throw e;
      }
      return Unit;
    };
  }
  function Coroutine$connect_61zpoe$_0($this, url_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$url = url_0;
  }
  Coroutine$connect_61zpoe$_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connect_61zpoe$_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connect_61zpoe$_0.prototype.constructor = Coroutine$connect_61zpoe$_0;
  Coroutine$connect_61zpoe$_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = suspendCancellableCoroutine$lambda(JsWebSocketClientAdapter$connect$lambda(this.$this, this.local$url))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  JsWebSocketClientAdapter.prototype.connect_61zpoe$ = function (url_0, continuation_0, suspended) {
    var instance = new Coroutine$connect_61zpoe$_0(this, url_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  JsWebSocketClientAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsWebSocketClientAdapter',
    interfaces: [WebSocketClient]
  };
  function JsWebSocketConnection(ws, incomingFrames) {
    this.ws_0 = ws;
    this.incomingFrames_g4ilgs$_0 = incomingFrames;
  }
  Object.defineProperty(JsWebSocketConnection.prototype, 'incomingFrames', {
    get: function () {
      return this.incomingFrames_g4ilgs$_0;
    }
  });
  Object.defineProperty(JsWebSocketConnection.prototype, 'url', {
    configurable: true,
    get: function () {
      return this.ws_0.url;
    }
  });
  Object.defineProperty(JsWebSocketConnection.prototype, 'canSend', {
    configurable: true,
    get: function () {
      return this.ws_0.readyState === WebSocket.OPEN;
    }
  });
  JsWebSocketConnection.prototype.sendText_61zpoe$ = function (frameText, continuation) {
    this.ws_0.send(frameText);
  };
  JsWebSocketConnection.prototype.sendBinary_fqrh44$ = function (frameData, continuation) {
    this.ws_0.send(toArrayBuffer(frameData));
  };
  JsWebSocketConnection.prototype.close_vqvrqt$$default = function (code, reason, continuation) {
    this.ws_0.close(toShort(code), reason != null ? reason : '');
  };
  JsWebSocketConnection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsWebSocketConnection',
    interfaces: [WebSocketConnection]
  };
  function toByteArray($receiver) {
    var int8Array = new Int8Array($receiver);
    var array = new Int8Array(int8Array.length);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = int8Array[i];
    }
    return array;
  }
  function toArrayBuffer($receiver) {
    return (new Int8Array(toTypedArray($receiver))).buffer;
  }
  $$importsForInline$$['krossbow-krossbow-websocket-core'] = _;
  var package$org = _.org || (_.org = {});
  var package$hildan = package$org.hildan || (package$org.hildan = {});
  var package$krossbow = package$hildan.krossbow || (package$hildan.krossbow = {});
  var package$websocket = package$krossbow.websocket || (package$krossbow.websocket = {});
  package$websocket.PartialBinaryMessageHandler = PartialBinaryMessageHandler;
  package$websocket.PartialTextMessageHandler = PartialTextMessageHandler;
  package$websocket.WebSocketClient = WebSocketClient;
  package$websocket.WebSocketConnection = WebSocketConnection;
  package$websocket.WebSocketConnectionWithPingPong = WebSocketConnectionWithPingPong;
  package$websocket.WebSocketException = WebSocketException;
  package$websocket.WebSocketConnectionException = WebSocketConnectionException;
  package$websocket.WebSocketConnectionClosedException = WebSocketConnectionClosedException;
  Object.defineProperty(package$websocket, 'WebSocketCloseCodes', {
    get: WebSocketCloseCodes_getInstance
  });
  Object.defineProperty(package$websocket, 'CLOSE_REASON_MAX_LENGTH_BYTES', {
    get: function () {
      return CLOSE_REASON_MAX_LENGTH_BYTES;
    }
  });
  package$websocket.truncateToCloseFrameReasonLength_pdl1vz$ = truncateToCloseFrameReasonLength;
  package$websocket.truncateUtf8BytesLengthTo_6ic1pp$ = truncateUtf8BytesLengthTo;
  WebSocketFrame.Text = WebSocketFrame$Text;
  WebSocketFrame.Binary = WebSocketFrame$Binary;
  WebSocketFrame.Ping = WebSocketFrame$Ping;
  WebSocketFrame.Pong = WebSocketFrame$Pong;
  WebSocketFrame.Close = WebSocketFrame$Close;
  package$websocket.WebSocketFrame = WebSocketFrame;
  package$websocket.WebSocketListenerChannelAdapter = WebSocketListenerChannelAdapter;
  package$websocket.UnboundedWsListenerChannelAdapter = UnboundedWsListenerChannelAdapter;
  var package$reconnection = package$websocket.reconnection || (package$websocket.reconnection = {});
  Object.defineProperty(package$reconnection, 'DEFAULT_MAX_ATTEMPTS_8be2vx$', {
    get: function () {
      return DEFAULT_MAX_ATTEMPTS;
    }
  });
  Object.defineProperty(package$reconnection, 'DEFAULT_DELAY_STRATEGY_8be2vx$', {
    get: function () {
      return DEFAULT_DELAY_STRATEGY;
    }
  });
  package$reconnection.reconnectConfig_j65ww7$ = reconnectConfig;
  package$reconnection.ReconnectConfig = ReconnectConfig;
  package$reconnection.ReconnectConfigBuilder = ReconnectConfigBuilder;
  package$reconnection.withAutoReconnect_cxrnbx$ = withAutoReconnect;
  package$reconnection.withAutoReconnect_tgics9$ = withAutoReconnect_0;
  package$reconnection.withAutoReconnect_h3eiq$ = withAutoReconnect_1;
  package$reconnection.WebSocketReconnectionException = WebSocketReconnectionException;
  package$reconnection.RetryDelayStrategy = RetryDelayStrategy;
  package$reconnection.FixedDelay = FixedDelay;
  package$reconnection.ExponentialBackOff = ExponentialBackOff;
  package$websocket.defaultWebSocketClient = defaultWebSocketClient;
  var package$js = package$websocket.js || (package$websocket.js = {});
  Object.defineProperty(package$js, 'BrowserWebSocketClient', {
    get: BrowserWebSocketClient_getInstance
  });
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  package$js.JsWebSocketClientAdapter = JsWebSocketClientAdapter;
  Object.defineProperty(WebSocketConnectionWithPingPong.prototype, 'host', Object.getOwnPropertyDescriptor(WebSocketConnection.prototype, 'host'));
  WebSocketConnectionWithPingPong.prototype.close_vqvrqt$ = WebSocketConnection.prototype.close_vqvrqt$;
  Object.defineProperty(WebSocketConnectionProxy.prototype, 'host', Object.getOwnPropertyDescriptor(WebSocketConnection.prototype, 'host'));
  WebSocketConnectionProxy.prototype.close_vqvrqt$ = WebSocketConnection.prototype.close_vqvrqt$;
  Object.defineProperty(JsWebSocketConnection.prototype, 'host', Object.getOwnPropertyDescriptor(WebSocketConnection.prototype, 'host'));
  JsWebSocketConnection.prototype.close_vqvrqt$ = WebSocketConnection.prototype.close_vqvrqt$;
  CLOSE_REASON_MAX_LENGTH_BYTES = 123;
  DEFAULT_MAX_ATTEMPTS = 5;
  DEFAULT_DELAY_STRATEGY = new FixedDelay(Duration.Companion.seconds_za3lpa$(1));
  Kotlin.defineModule('krossbow-krossbow-websocket-core', _);
  return _;
}(module.exports, require('kotlin'), require('okio-parent-okio'), require('kotlinx-coroutines-core')));

//# sourceMappingURL=krossbow-krossbow-websocket-core.js.map
