(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'ktor-ktor-http-js-legacy', 'ktor-ktor-client-core-js-legacy', 'krossbow-krossbow-websocket-core-js-legacy', 'ktor-ktor-websockets-js-legacy', 'kotlinx-atomicfu', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('ktor-ktor-http-js-legacy'), require('ktor-ktor-client-core-js-legacy'), require('krossbow-krossbow-websocket-core-js-legacy'), require('ktor-ktor-websockets-js-legacy'), require('kotlinx-atomicfu'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-ktor-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'krossbow-krossbow-websocket-ktor-js-legacy'.");
    }
    if (typeof this['ktor-ktor-http-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-ktor-js-legacy'. Its dependency 'ktor-ktor-http-js-legacy' was not found. Please, check whether 'ktor-ktor-http-js-legacy' is loaded prior to 'krossbow-krossbow-websocket-ktor-js-legacy'.");
    }
    if (typeof this['ktor-ktor-client-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-ktor-js-legacy'. Its dependency 'ktor-ktor-client-core-js-legacy' was not found. Please, check whether 'ktor-ktor-client-core-js-legacy' is loaded prior to 'krossbow-krossbow-websocket-ktor-js-legacy'.");
    }
    if (typeof this['krossbow-krossbow-websocket-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-ktor-js-legacy'. Its dependency 'krossbow-krossbow-websocket-core-js-legacy' was not found. Please, check whether 'krossbow-krossbow-websocket-core-js-legacy' is loaded prior to 'krossbow-krossbow-websocket-ktor-js-legacy'.");
    }
    if (typeof this['ktor-ktor-websockets-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-ktor-js-legacy'. Its dependency 'ktor-ktor-websockets-js-legacy' was not found. Please, check whether 'ktor-ktor-websockets-js-legacy' is loaded prior to 'krossbow-krossbow-websocket-ktor-js-legacy'.");
    }
    if (typeof this['kotlinx-atomicfu'] === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-ktor-js-legacy'. Its dependency 'kotlinx-atomicfu' was not found. Please, check whether 'kotlinx-atomicfu' is loaded prior to 'krossbow-krossbow-websocket-ktor-js-legacy'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'krossbow-krossbow-websocket-ktor-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'krossbow-krossbow-websocket-ktor-js-legacy'.");
    }
    root['krossbow-krossbow-websocket-ktor-js-legacy'] = factory(typeof this['krossbow-krossbow-websocket-ktor-js-legacy'] === 'undefined' ? {} : this['krossbow-krossbow-websocket-ktor-js-legacy'], kotlin, this['ktor-ktor-http-js-legacy'], this['ktor-ktor-client-core-js-legacy'], this['krossbow-krossbow-websocket-core-js-legacy'], this['ktor-ktor-websockets-js-legacy'], this['kotlinx-atomicfu'], this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$ktor_ktor_http_js_legacy, $module$ktor_ktor_client_core_js_legacy, $module$krossbow_krossbow_websocket_core_js_legacy, $module$ktor_ktor_websockets_js_legacy, $module$kotlinx_atomicfu, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var takeFrom = $module$ktor_ktor_http_js_legacy.io.ktor.http.takeFrom_jl1sg7$;
  var Unit = Kotlin.kotlin.Unit;
  var webSocketSession = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.plugins.websocket.webSocketSession_uxii9k$;
  var CancellationException = Kotlin.kotlin.coroutines.cancellation.CancellationException;
  var WebSocketConnectionException = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketConnectionException;
  var ResponseException = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.plugins.ResponseException;
  var Exception = Kotlin.kotlin.Exception;
  var WebSockets = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.plugins.websocket.WebSockets;
  var HttpClient = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.HttpClient_f0veat$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var WebSocketClient = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketClient;
  var WebSocketFrame$Close = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketFrame.Close;
  var Frame$Frame$Text_init = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.Frame.Text_init_61zpoe$;
  var Frame$Frame$Binary_init = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.Frame.Binary_init_3eyok5$;
  var Frame$Ping = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.Frame.Ping;
  var Frame$Pong = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.Frame.Pong;
  var toShort = Kotlin.toShort;
  var CloseReason = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.CloseReason;
  var close = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.close_d9la3o$;
  var atomic = $module$kotlinx_atomicfu.kotlinx.atomicfu.atomic$boolean$1;
  var receiveAsFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.receiveAsFlow_6u4434$;
  var onCompletion = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.onCompletion_sp7fh9$;
  var toString = Kotlin.toString;
  var WebSocketException = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketException;
  var catch_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.catch_xmh1mw$;
  var WebSocketConnectionWithPingPong = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketConnectionWithPingPong;
  var readText = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.readText_xv7s0w$;
  var WebSocketFrame$Text = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketFrame.Text;
  var Frame$Text = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.Frame.Text;
  var readBytes = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.readBytes_q8vmvx$;
  var WebSocketFrame$Binary = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketFrame.Binary;
  var Frame$Binary = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.Frame.Binary;
  var WebSocketFrame$Ping = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketFrame.Ping;
  var WebSocketFrame$Pong = $module$krossbow_krossbow_websocket_core_js_legacy.org.hildan.krossbow.websocket.WebSocketFrame.Pong;
  var Frame$Close = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.Frame.Close;
  var readReason = $module$ktor_ktor_websockets_js_legacy.io.ktor.websocket.readReason_7mwy0p$;
  var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
  var Flow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.Flow;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  function unsafeFlow$ObjectLiteral(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$.prototype.constructor = Coroutine$collect_42ocv1$;
  Coroutine$collect_42ocv1$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda;
  Coroutine$unsafeTransform$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
  Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda.prototype.constructor = Coroutine$map$lambda;
  Coroutine$map$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function KtorWebSocketClient(httpClient) {
    if (httpClient === void 0)
      httpClient = HttpClient(KtorWebSocketClient_init$lambda);
    this.httpClient_0 = httpClient;
  }
  function KtorWebSocketClient$connect$lambda(closure$url) {
    return function ($receiver) {
      takeFrom($receiver.url, closure$url);
      return Unit;
    };
  }
  function Coroutine$connect_61zpoe$($this, url_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 4;
    this.$this = $this;
    this.local$url = url_0;
  }
  Coroutine$connect_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connect_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connect_61zpoe$.prototype.constructor = Coroutine$connect_61zpoe$;
  Coroutine$connect_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.exceptionState_0 = 2;
            this.state_0 = 1;
            this.result_0 = webSocketSession(this.$this.httpClient_0, KtorWebSocketClient$connect$lambda(this.local$url), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            var wsKtorSession = this.result_0;
            return new KtorWebSocketConnectionAdapter(wsKtorSession);
          case 2:
            this.exceptionState_0 = 4;
            var e = this.exception_0;
            if (Kotlin.isType(e, CancellationException)) {
              throw e;
            } else if (Kotlin.isType(e, ResponseException)) {
              throw new WebSocketConnectionException(this.local$url, e.response.status.value, void 0, e);
            } else if (Kotlin.isType(e, Exception)) {
              var statusCode = extractHandshakeStatusCode(e);
              throw new WebSocketConnectionException(this.local$url, statusCode, void 0, e);
            } else
              throw e;
          case 3:
            return;
          case 4:
            throw this.exception_0;
          default:
            this.state_0 = 4;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 4) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KtorWebSocketClient.prototype.connect_61zpoe$ = function (url_0, continuation_0, suspended) {
    var instance = new Coroutine$connect_61zpoe$(this, url_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function KtorWebSocketClient_init$lambda($receiver) {
    $receiver.install_dq2y33$(WebSockets.Plugin);
    return Unit;
  }
  KtorWebSocketClient.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KtorWebSocketClient',
    interfaces: [WebSocketClient]
  };
  function KtorWebSocketConnectionAdapter(wsSession) {
    this.wsSession_0 = wsSession;
    this.emittedCloseFrame_0 = atomic(false);
    var $receiver = receiveAsFlow(this.wsSession_0.incoming);
    this.incomingFrames_p3k7tp$_0 = catch_0(onCompletion(new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(map$lambda(KtorWebSocketConnectionAdapter$incomingFrames$lambda), $receiver)), KtorWebSocketConnectionAdapter$incomingFrames$lambda_0(this)), KtorWebSocketConnectionAdapter$incomingFrames$lambda_1);
  }
  Object.defineProperty(KtorWebSocketConnectionAdapter.prototype, 'url', {
    configurable: true,
    get: function () {
      return this.wsSession_0.call.request.url.toString();
    }
  });
  Object.defineProperty(KtorWebSocketConnectionAdapter.prototype, 'canSend', {
    configurable: true,
    get: function () {
      return !this.wsSession_0.outgoing.isClosedForSend;
    }
  });
  Object.defineProperty(KtorWebSocketConnectionAdapter.prototype, 'incomingFrames', {
    configurable: true,
    get: function () {
      return this.incomingFrames_p3k7tp$_0;
    }
  });
  function Coroutine$buildCloseFrame_0($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$buildCloseFrame_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$buildCloseFrame_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$buildCloseFrame_0.prototype.constructor = Coroutine$buildCloseFrame_0;
  Coroutine$buildCloseFrame_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            this.state_0 = 2;
            this.result_0 = this.$this.wsSession_0.closeReason.await(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return (tmp$ = this.result_0) != null ? new WebSocketFrame$Close(tmp$.code, tmp$.message) : null;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KtorWebSocketConnectionAdapter.prototype.buildCloseFrame_0 = function (continuation_0, suspended) {
    var instance = new Coroutine$buildCloseFrame_0(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$sendText_61zpoe$($this, frameText_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frameText = frameText_0;
  }
  Coroutine$sendText_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendText_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendText_61zpoe$.prototype.constructor = Coroutine$sendText_61zpoe$;
  Coroutine$sendText_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.wsSession_0.outgoing.send_11rb$(Frame$Frame$Text_init(this.local$frameText), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KtorWebSocketConnectionAdapter.prototype.sendText_61zpoe$ = function (frameText_0, continuation_0, suspended) {
    var instance = new Coroutine$sendText_61zpoe$(this, frameText_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$sendBinary_fqrh44$($this, frameData_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frameData = frameData_0;
  }
  Coroutine$sendBinary_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendBinary_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendBinary_fqrh44$.prototype.constructor = Coroutine$sendBinary_fqrh44$;
  Coroutine$sendBinary_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.wsSession_0.outgoing.send_11rb$(Frame$Frame$Binary_init(true, this.local$frameData), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KtorWebSocketConnectionAdapter.prototype.sendBinary_fqrh44$ = function (frameData_0, continuation_0, suspended) {
    var instance = new Coroutine$sendBinary_fqrh44$(this, frameData_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$sendPing_fqrh44$($this, frameData_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frameData = frameData_0;
  }
  Coroutine$sendPing_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendPing_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendPing_fqrh44$.prototype.constructor = Coroutine$sendPing_fqrh44$;
  Coroutine$sendPing_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.wsSession_0.outgoing.send_11rb$(new Frame$Ping(this.local$frameData), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KtorWebSocketConnectionAdapter.prototype.sendPing_fqrh44$ = function (frameData_0, continuation_0, suspended) {
    var instance = new Coroutine$sendPing_fqrh44$(this, frameData_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$sendPong_fqrh44$($this, frameData_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frameData = frameData_0;
  }
  Coroutine$sendPong_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendPong_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendPong_fqrh44$.prototype.constructor = Coroutine$sendPong_fqrh44$;
  Coroutine$sendPong_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.wsSession_0.outgoing.send_11rb$(new Frame$Pong(this.local$frameData), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KtorWebSocketConnectionAdapter.prototype.sendPong_fqrh44$ = function (frameData_0, continuation_0, suspended) {
    var instance = new Coroutine$sendPong_fqrh44$(this, frameData_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$close_vqvrqt$$default($this, code_0, reason_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$code = code_0;
    this.local$reason = reason_0;
  }
  Coroutine$close_vqvrqt$$default.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$close_vqvrqt$$default.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$close_vqvrqt$$default.prototype.constructor = Coroutine$close_vqvrqt$$default;
  Coroutine$close_vqvrqt$$default.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = close(this.$this.wsSession_0, new CloseReason(toShort(this.local$code), this.local$reason != null ? this.local$reason : ''), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KtorWebSocketConnectionAdapter.prototype.close_vqvrqt$$default = function (code_0, reason_0, continuation_0, suspended) {
    var instance = new Coroutine$close_vqvrqt$$default(this, code_0, reason_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda.prototype.constructor = Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda;
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return toKrossbowFrame(this.local$it);
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KtorWebSocketConnectionAdapter$incomingFrames$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_0(this$KtorWebSocketConnectionAdapter_0, $receiver_0, error_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$KtorWebSocketConnectionAdapter = this$KtorWebSocketConnectionAdapter_0;
    this.local$$receiver = $receiver_0;
    this.local$error = error_0;
  }
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_0.prototype.constructor = Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_0;
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            if (this.local$error == null && !this.local$this$KtorWebSocketConnectionAdapter.emittedCloseFrame_0.atomicfu$getAndSet(true)) {
              this.state_0 = 2;
              this.result_0 = this.local$this$KtorWebSocketConnectionAdapter.buildCloseFrame_0(this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 5;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            if ((tmp$ = this.result_0) != null) {
              this.state_0 = 3;
              this.result_0 = this.local$$receiver.emit_11rb$(tmp$, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 3:
            this.state_0 = 4;
            continue;
          case 4:
            return Unit;
          case 5:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KtorWebSocketConnectionAdapter$incomingFrames$lambda_0(this$KtorWebSocketConnectionAdapter_0) {
    return function ($receiver_0, error_0, continuation_0, suspended) {
      var instance = new Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_0(this$KtorWebSocketConnectionAdapter_0, $receiver_0, error_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_1($receiver_0, th_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$th = th_0;
  }
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_1.prototype.constructor = Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_1;
  Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            throw new WebSocketException("error in Ktor's websocket: " + toString(this.local$th.message), this.local$th);
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KtorWebSocketConnectionAdapter$incomingFrames$lambda_1($receiver_0, th_0, continuation_0, suspended) {
    var instance = new Coroutine$KtorWebSocketConnectionAdapter$incomingFrames$lambda_1($receiver_0, th_0, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  KtorWebSocketConnectionAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KtorWebSocketConnectionAdapter',
    interfaces: [WebSocketConnectionWithPingPong]
  };
  function toKrossbowFrame($receiver) {
    if (Kotlin.isType($receiver, Frame$Text))
      return new WebSocketFrame$Text(readText($receiver));
    else if (Kotlin.isType($receiver, Frame$Binary))
      return new WebSocketFrame$Binary(readBytes($receiver));
    else if (Kotlin.isType($receiver, Frame$Ping))
      return new WebSocketFrame$Ping(readBytes($receiver));
    else if (Kotlin.isType($receiver, Frame$Pong))
      return new WebSocketFrame$Pong(readBytes($receiver));
    else if (Kotlin.isType($receiver, Frame$Close))
      return toKrossbowCloseFrame($receiver);
    else {
      throw IllegalStateException_init(('Unknown frame type ' + toString(Kotlin.getKClassFromExpression($receiver).simpleName)).toString());
    }
  }
  function toKrossbowCloseFrame($receiver) {
    var tmp$, tmp$_0;
    var reason = readReason($receiver);
    var code = (tmp$_0 = (tmp$ = reason != null ? reason.code : null) != null ? tmp$ : null) != null ? tmp$_0 : 1005;
    return new WebSocketFrame$Close(code, reason != null ? reason.message : null);
  }
  var jsonExceptionMessageRegex;
  var unexpectedServerResponseMessageRegex;
  function extractHandshakeStatusCode(handshakeException) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    tmp$ = handshakeException.message;
    if (tmp$ == null) {
      return null;
    }
    var json = tmp$;
    tmp$_2 = (tmp$_1 = (tmp$_0 = jsonExceptionMessageRegex.matchEntire_6bul2c$(json)) != null ? tmp$_0.groupValues : null) != null ? tmp$_1.get_za3lpa$(1) : null;
    if (tmp$_2 == null) {
      return null;
    }
    var actualMessage = tmp$_2;
    return (tmp$_5 = (tmp$_4 = (tmp$_3 = unexpectedServerResponseMessageRegex.matchEntire_6bul2c$(actualMessage)) != null ? tmp$_3.groupValues : null) != null ? tmp$_4.get_za3lpa$(1) : null) != null ? toInt(tmp$_5) : null;
  }
  var package$org = _.org || (_.org = {});
  var package$hildan = package$org.hildan || (package$org.hildan = {});
  var package$krossbow = package$hildan.krossbow || (package$hildan.krossbow = {});
  var package$websocket = package$krossbow.websocket || (package$krossbow.websocket = {});
  var package$ktor = package$websocket.ktor || (package$websocket.ktor = {});
  package$ktor.KtorWebSocketClient = KtorWebSocketClient;
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  package$ktor.extractHandshakeStatusCode_yfdpi9$ = extractHandshakeStatusCode;
  Object.defineProperty(KtorWebSocketConnectionAdapter.prototype, 'host', Object.getOwnPropertyDescriptor(WebSocketConnectionWithPingPong.prototype, 'host'));
  KtorWebSocketConnectionAdapter.prototype.close_vqvrqt$ = WebSocketConnectionWithPingPong.prototype.close_vqvrqt$;
  jsonExceptionMessageRegex = Regex_init('\\{"message":"(.*?)","target":\\{\\},"type":"error"\\}');
  unexpectedServerResponseMessageRegex = Regex_init('Unexpected server response: (\\d{3})');
  Kotlin.defineModule('krossbow-krossbow-websocket-ktor-js-legacy', _);
  return _;
}));

//# sourceMappingURL=krossbow-krossbow-websocket-ktor-js-legacy.js.map
