/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.krossbow.websocket.ktor;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.hildan.krossbow.websocket.ktor.HandshakeExceptionsJvmKt;
import org.hildan.krossbow.websocket.ktor.HandshakeFailureDetails;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"wrongStatusExceptionMessageRegex", "Lkotlin/text/Regex;", "extractKtorHandshakeFailureDetails", "Lorg/hildan/krossbow/websocket/ktor/HandshakeFailureDetails;", "handshakeException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "genericFailureDetails", "krossbow-websocket-ktor"})
public final class HandshakeExceptionsKt {
    @NotNull
    private static final Regex wrongStatusExceptionMessageRegex = new Regex("Handshake exception, expected status code 101 but was (\\d{3})");

    @NotNull
    public static final HandshakeFailureDetails extractKtorHandshakeFailureDetails(@NotNull Exception handshakeException) {
        Intrinsics.checkNotNullParameter((Object)handshakeException, (String)"handshakeException");
        String string = handshakeException.getMessage();
        if (string == null) {
            return HandshakeExceptionsJvmKt.extractHandshakeFailureDetails(handshakeException);
        }
        String message = string;
        MatchResult matchResult = wrongStatusExceptionMessageRegex.matchEntire((CharSequence)message);
        if (matchResult == null) {
            return HandshakeExceptionsJvmKt.extractHandshakeFailureDetails(handshakeException);
        }
        MatchResult match = matchResult;
        return new HandshakeFailureDetails(Integer.parseInt((String)match.getGroupValues().get(1)), message);
    }

    @NotNull
    public static final HandshakeFailureDetails genericFailureDetails(@NotNull Exception handshakeException) {
        Intrinsics.checkNotNullParameter((Object)handshakeException, (String)"handshakeException");
        return new HandshakeFailureDetails(null, handshakeException.toString());
    }
}

