/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.krossbow.websocket.ktor;

import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.net.http.WebSocketHandshakeException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.hildan.krossbow.websocket.ktor.HandshakeExceptionsKt;
import org.hildan.krossbow.websocket.ktor.HandshakeFailureDetails;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001b\u0010\u0004\u001a\u00020\u00032\n\u0010\u0002\u001a\u00060\u0000j\u0002`\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0017\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0007\u001a\u0017\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0004\u0010\n\u001a3\u0010\u000e\u001a\u00020\r\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\u000b*\u00020\u000bH\u0082\b\u0082\u0002\u0010\n\u000e\b\u0000\u0012\u0002\u0018\u0000\u001a\u0006\u0010\u0000\"\u00028\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\"\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Ljava/lang/Exception;", "Lkotlin/Exception;", "handshakeException", "Lorg/hildan/krossbow/websocket/ktor/HandshakeFailureDetails;", "extractHandshakeFailureDetails", "(Ljava/lang/Exception;)Lorg/hildan/krossbow/websocket/ktor/HandshakeFailureDetails;", "Ljava/net/ProtocolException;", "(Ljava/net/ProtocolException;)Lorg/hildan/krossbow/websocket/ktor/HandshakeFailureDetails;", "Ljava/net/http/WebSocketHandshakeException;", "webSocketHandshakeException", "(Ljava/net/http/WebSocketHandshakeException;)Lorg/hildan/krossbow/websocket/ktor/HandshakeFailureDetails;", "", "C", "", "safeIs", "(Ljava/lang/Object;)Z", "", "okhttp407WithoutProxyMessage", "Ljava/lang/String;", "Lkotlin/text/Regex;", "okhttpInvalidStatusCodeMessageRegex", "Lkotlin/text/Regex;", "krossbow-websocket-ktor"})
@SourceDebugExtension(value={"SMAP\nHandshakeExceptionsJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandshakeExceptionsJvm.kt\norg/hildan/krossbow/websocket/ktor/HandshakeExceptionsJvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n49#1,4:56\n1#2:60\n*S KotlinDebug\n*F\n+ 1 HandshakeExceptionsJvm.kt\norg/hildan/krossbow/websocket/ktor/HandshakeExceptionsJvmKt\n*L\n14#1:56,4\n*E\n"})
public final class HandshakeExceptionsJvmKt {
    @NotNull
    private static final String okhttp407WithoutProxyMessage = "Received HTTP_PROXY_AUTH (407) code while not using proxy";
    @NotNull
    private static final Regex okhttpInvalidStatusCodeMessageRegex = new Regex("Expected HTTP 101 response but was '(\\d{3}) ([^']*)'");

    @NotNull
    public static final HandshakeFailureDetails extractHandshakeFailureDetails(@NotNull Exception handshakeException) {
        HandshakeFailureDetails handshakeFailureDetails;
        Intrinsics.checkNotNullParameter((Object)handshakeException, (String)"handshakeException");
        if (handshakeException instanceof UnknownHostException) {
            handshakeFailureDetails = HandshakeExceptionsKt.genericFailureDetails(handshakeException);
        } else if (handshakeException instanceof ProtocolException) {
            handshakeFailureDetails = HandshakeExceptionsJvmKt.extractHandshakeFailureDetails((ProtocolException)handshakeException);
        } else {
            boolean bl;
            Exception $this$safeIs$iv = handshakeException;
            boolean $i$f$safeIs = false;
            try {
                bl = $this$safeIs$iv instanceof WebSocketHandshakeException;
            }
            catch (NoClassDefFoundError e$iv) {
                bl = false;
            }
            handshakeFailureDetails = bl ? HandshakeExceptionsJvmKt.extractHandshakeFailureDetails((WebSocketHandshakeException)handshakeException) : HandshakeExceptionsKt.genericFailureDetails(handshakeException);
        }
        return handshakeFailureDetails;
    }

    /*
     * WARNING - void declaration
     */
    private static final HandshakeFailureDetails extractHandshakeFailureDetails(ProtocolException handshakeException) {
        Object object;
        String string = handshakeException.getMessage();
        if (string == null) {
            return HandshakeExceptionsKt.genericFailureDetails(handshakeException);
        }
        String message = string;
        if (Intrinsics.areEqual((Object)message, (Object)okhttp407WithoutProxyMessage)) {
            return new HandshakeFailureDetails(407, message);
        }
        MatchResult match = okhttpInvalidStatusCodeMessageRegex.matchEntire((CharSequence)message);
        Object object2 = match;
        Integer n = object2 != null && (object2 = object2.getGroupValues()) != null && (object2 = (String)object2.get(1)) != null ? Integer.valueOf(Integer.parseInt((String)object2)) : null;
        Object object3 = match;
        if (object3 == null || (object3 = object3.getGroupValues()) == null || (object3 = (String)object3.get(2)) == null) {
            object3 = handshakeException.getMessage();
        }
        if (object3 != null) {
            void it;
            Object object4;
            Object object5 = object4 = object3;
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            n = n2;
            object = bl2 ? object4 : null;
        } else {
            object = null;
        }
        Object object6 = object;
        Integer n3 = n;
        return new HandshakeFailureDetails(n3, (String)object6);
    }

    /*
     * WARNING - void declaration
     */
    private static final HandshakeFailureDetails extractHandshakeFailureDetails(WebSocketHandshakeException webSocketHandshakeException) {
        Object v2;
        Integer n = webSocketHandshakeException.getResponse().statusCode();
        Object object = webSocketHandshakeException.getResponse().body();
        String string = object instanceof String ? (String)object : null;
        if (string != null) {
            void it;
            Object object2 = object = string;
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            n = n2;
            v2 = bl2 ? object : null;
        } else {
            v2 = null;
        }
        Object var6_6 = v2;
        Integer n3 = n;
        return new HandshakeFailureDetails(n3, var6_6);
    }

    private static final /* synthetic */ <C> boolean safeIs(Object $this$safeIs) {
        boolean bl;
        boolean $i$f$safeIs = false;
        try {
            Intrinsics.reifiedOperationMarker((int)3, (String)"C");
            bl = $this$safeIs instanceof Object;
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }
}

