/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.krossbow.websocket.okhttp;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import okhttp3.WebSocket;
import okio.ByteString;
import org.hildan.krossbow.websocket.WebSocketConnection;
import org.hildan.krossbow.websocket.WebSocketFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J#\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lorg/hildan/krossbow/websocket/okhttp/OkHttpSocketToKrossbowConnectionAdapter;", "Lorg/hildan/krossbow/websocket/WebSocketConnection;", "okSocket", "Lokhttp3/WebSocket;", "incomingFrames", "Lkotlinx/coroutines/flow/Flow;", "Lorg/hildan/krossbow/websocket/WebSocketFrame;", "(Lokhttp3/WebSocket;Lkotlinx/coroutines/flow/Flow;)V", "canSend", "", "getCanSend", "()Z", "getIncomingFrames", "()Lkotlinx/coroutines/flow/Flow;", "url", "", "getUrl", "()Ljava/lang/String;", "close", "", "code", "", "reason", "(ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendBinary", "frameData", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendText", "frameText", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "krossbow-websocket-okhttp"})
final class OkHttpSocketToKrossbowConnectionAdapter
implements WebSocketConnection {
    @NotNull
    private final WebSocket okSocket;
    @NotNull
    private final Flow<WebSocketFrame> incomingFrames;

    public OkHttpSocketToKrossbowConnectionAdapter(@NotNull WebSocket okSocket, @NotNull Flow<? extends WebSocketFrame> incomingFrames) {
        Intrinsics.checkNotNullParameter((Object)okSocket, (String)"okSocket");
        Intrinsics.checkNotNullParameter(incomingFrames, (String)"incomingFrames");
        this.okSocket = okSocket;
        this.incomingFrames = incomingFrames;
    }

    @NotNull
    public Flow<WebSocketFrame> getIncomingFrames() {
        return this.incomingFrames;
    }

    @NotNull
    public String getUrl() {
        return this.okSocket.request().url().toString();
    }

    public boolean getCanSend() {
        return true;
    }

    @Nullable
    public Object sendText(@NotNull String frameText, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.send(frameText);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object sendBinary(@NotNull byte[] frameData, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])frameData, (int)0, (int)0, (int)3, null));
        return Unit.INSTANCE;
    }

    @Nullable
    public Object close(int code, @Nullable String reason, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.close(code, reason);
        return Unit.INSTANCE;
    }

    @NotNull
    public String getHost() {
        return WebSocketConnection.DefaultImpls.getHost((WebSocketConnection)this);
    }
}

