/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.krossbow.websocket.okhttp;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.io.bytestring.ByteString;
import okhttp3.WebSocket;
import okio.ByteString;
import org.hildan.krossbow.io.IoUtilsKt;
import org.hildan.krossbow.websocket.WebSocketConnection;
import org.hildan.krossbow.websocket.WebSocketFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010 R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/hildan/krossbow/websocket/okhttp/OkHttpSocketToKrossbowConnectionAdapter;", "Lorg/hildan/krossbow/websocket/WebSocketConnection;", "okSocket", "Lokhttp3/WebSocket;", "protocol", "", "incomingFrames", "Lkotlinx/coroutines/flow/Flow;", "Lorg/hildan/krossbow/websocket/WebSocketFrame;", "(Lokhttp3/WebSocket;Ljava/lang/String;Lkotlinx/coroutines/flow/Flow;)V", "canSend", "", "getCanSend", "()Z", "getIncomingFrames", "()Lkotlinx/coroutines/flow/Flow;", "getProtocol", "()Ljava/lang/String;", "url", "getUrl", "close", "", "code", "", "reason", "(ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendBinary", "frameData", "Lkotlinx/io/bytestring/ByteString;", "(Lkotlinx/io/bytestring/ByteString;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendText", "frameText", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "krossbow-websocket-okhttp"})
final class OkHttpSocketToKrossbowConnectionAdapter
implements WebSocketConnection {
    @NotNull
    private final WebSocket okSocket;
    @Nullable
    private final String protocol;
    @NotNull
    private final Flow<WebSocketFrame> incomingFrames;
    @NotNull
    private final String url;

    public OkHttpSocketToKrossbowConnectionAdapter(@NotNull WebSocket okSocket, @Nullable String protocol, @NotNull Flow<? extends WebSocketFrame> incomingFrames) {
        Intrinsics.checkNotNullParameter((Object)okSocket, (String)"okSocket");
        Intrinsics.checkNotNullParameter(incomingFrames, (String)"incomingFrames");
        this.okSocket = okSocket;
        this.protocol = protocol;
        this.incomingFrames = incomingFrames;
        this.url = this.okSocket.request().url().toString();
    }

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public Flow<WebSocketFrame> getIncomingFrames() {
        return this.incomingFrames;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    public boolean getCanSend() {
        return true;
    }

    @Nullable
    public Object sendText(@NotNull String frameText, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.send(frameText);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object sendBinary(@NotNull ByteString frameData, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.send(ByteString.Companion.of$default((ByteString.Companion)okio.ByteString.Companion, (byte[])IoUtilsKt.unsafeBackingByteArray((ByteString)frameData), (int)0, (int)0, (int)3, null));
        return Unit.INSTANCE;
    }

    @Nullable
    public Object close(int code, @Nullable String reason, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.close(code, reason);
        return Unit.INSTANCE;
    }
}

