/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.krossbow.websocket.okhttp;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.okio.OkioAdaptersKt;
import okhttp3.WebSocket;
import org.hildan.krossbow.websocket.WebSocketConnection;
import org.hildan.krossbow.websocket.WebSocketFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/hildan/krossbow/websocket/okhttp/OkHttpSocketToKrossbowConnectionAdapter;", "Lorg/hildan/krossbow/websocket/WebSocketConnection;", "okSocket", "Lokhttp3/WebSocket;", "protocol", "", "incomingFrames", "Lkotlinx/coroutines/flow/Flow;", "Lorg/hildan/krossbow/websocket/WebSocketFrame;", "<init>", "(Lokhttp3/WebSocket;Ljava/lang/String;Lkotlinx/coroutines/flow/Flow;)V", "getProtocol", "()Ljava/lang/String;", "getIncomingFrames", "()Lkotlinx/coroutines/flow/Flow;", "url", "getUrl", "canSend", "", "getCanSend", "()Z", "sendText", "", "frameText", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendBinary", "frameData", "Lkotlinx/io/bytestring/ByteString;", "(Lkotlinx/io/bytestring/ByteString;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "code", "", "reason", "(ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "krossbow-websocket-okhttp"})
final class OkHttpSocketToKrossbowConnectionAdapter
implements WebSocketConnection {
    @NotNull
    private final WebSocket okSocket;
    @Nullable
    private final String protocol;
    @NotNull
    private final Flow<WebSocketFrame> incomingFrames;
    @NotNull
    private final String url;

    public OkHttpSocketToKrossbowConnectionAdapter(@NotNull WebSocket okSocket, @Nullable String protocol, @NotNull Flow<? extends WebSocketFrame> incomingFrames) {
        Intrinsics.checkNotNullParameter((Object)okSocket, (String)"okSocket");
        Intrinsics.checkNotNullParameter(incomingFrames, (String)"incomingFrames");
        this.okSocket = okSocket;
        this.protocol = protocol;
        this.incomingFrames = incomingFrames;
        this.url = this.okSocket.request().url().toString();
    }

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public Flow<WebSocketFrame> getIncomingFrames() {
        return this.incomingFrames;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    public boolean getCanSend() {
        return true;
    }

    @Nullable
    public Object sendText(@NotNull String frameText, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.send(frameText);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object sendBinary(@NotNull ByteString frameData, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.send(OkioAdaptersKt.toOkioByteString((ByteString)frameData));
        return Unit.INSTANCE;
    }

    @Nullable
    public Object close(int code, @Nullable String reason, @NotNull Continuation<? super Unit> $completion) {
        this.okSocket.close(code, reason);
        return Unit.INSTANCE;
    }
}

