(function (_, Kotlin, $module$krossbow_krossbow_websocket_core, $module$kotlinx_coroutines_core, $module$kotlin_test) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var WebSocketClient = $module$krossbow_krossbow_websocket_core.org.hildan.krossbow.websocket.WebSocketClient;
  var Unit = Kotlin.kotlin.Unit;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var throwUPAE = Kotlin.throwUPAE;
  var WebSocketFrame$Text = $module$krossbow_krossbow_websocket_core.org.hildan.krossbow.websocket.WebSocketFrame.Text;
  var assertTrue = $module$kotlin_test.kotlin.test.assertTrue_ifx8ge$;
  var assertEquals = $module$kotlin_test.kotlin.test.assertEquals_3m0tl5$;
  var WebSocketFrame$Binary = $module$krossbow_krossbow_websocket_core.org.hildan.krossbow.websocket.WebSocketFrame.Binary;
  var toList = Kotlin.kotlin.collections.toList_964n91$;
  var WebSocketFrame$Close = $module$krossbow_krossbow_websocket_core.org.hildan.krossbow.websocket.WebSocketFrame.Close;
  var L20 = Kotlin.Long.fromInt(20);
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var fail = $module$kotlin_test.kotlin.test.fail_pdl1vj$;
  var Exception_init = Kotlin.kotlin.Exception_init_pdl1vj$;
  var WebSocketListenerChannelAdapter = $module$krossbow_krossbow_websocket_core.org.hildan.krossbow.websocket.WebSocketListenerChannelAdapter;
  var WebSocketConnection = $module$krossbow_krossbow_websocket_core.org.hildan.krossbow.websocket.WebSocketConnection;
  var L2000 = Kotlin.Long.fromInt(2000);
  var L8000 = Kotlin.Long.fromInt(8000);
  var withTimeoutOrNull = $module$kotlinx_coroutines_core.kotlinx.coroutines.withTimeoutOrNull_ms3uf5$;
  var getKClass = Kotlin.getKClass;
  var createKType = Kotlin.createKType;
  var assertNotNull = $module$kotlin_test.kotlin.test.assertNotNull_tkjle6$;
  var assertFalse = $module$kotlin_test.kotlin.test.assertFalse_ifx8ge$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var L1000 = Kotlin.Long.fromInt(1000);
  var toString = Kotlin.toString;
  var getReifiedTypeParameterKType = Kotlin.getReifiedTypeParameterKType;
  var assertIsOfType = $module$kotlin_test.kotlin.test.assertIsOfType_5l1t6h$;
  var throwCCE = Kotlin.throwCCE;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var promise = $module$kotlinx_coroutines_core.kotlinx.coroutines.promise_pda6u4$;
  function Coroutine$webSocketClientMock$lambda(continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$webSocketClientMock$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$webSocketClientMock$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$webSocketClientMock$lambda.prototype.constructor = Coroutine$webSocketClientMock$lambda;
  Coroutine$webSocketClientMock$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return new WebSocketConnectionMock();
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function webSocketClientMock$lambda(continuation_0, suspended) {
    var instance = new Coroutine$webSocketClientMock$lambda(continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function webSocketClientMock$ObjectLiteral(closure$connect) {
    this.closure$connect = closure$connect;
  }
  webSocketClientMock$ObjectLiteral.prototype.connect_61zpoe$ = function (url, continuation) {
    return this.closure$connect(continuation);
  };
  webSocketClientMock$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [WebSocketClient]
  };
  function webSocketClientMock(connect) {
    if (connect === void 0)
      connect = webSocketClientMock$lambda;
    return new webSocketClientMock$ObjectLiteral(connect);
  }
  function ControlledWebSocketClientMock() {
    this.connectEventChannel_0 = Channel();
    this.connectedEventChannel_0 = Channel();
  }
  function Coroutine$connect_61zpoe$($this, url_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$connect_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connect_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connect_61zpoe$.prototype.constructor = Coroutine$connect_61zpoe$;
  Coroutine$connect_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.connectEventChannel_0.send_11rb$(Unit, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.$this.connectedEventChannel_0.receive(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ControlledWebSocketClientMock.prototype.connect_61zpoe$ = function (url_0, continuation_0, suspended) {
    var instance = new Coroutine$connect_61zpoe$(this, url_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$waitForConnectCall($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$waitForConnectCall.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$waitForConnectCall.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$waitForConnectCall.prototype.constructor = Coroutine$waitForConnectCall;
  Coroutine$waitForConnectCall.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.connectEventChannel_0.receive(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ControlledWebSocketClientMock.prototype.waitForConnectCall = function (continuation_0, suspended) {
    var instance = new Coroutine$waitForConnectCall(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$simulateSuccessfulConnection_984xrs$($this, connection_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$connection = connection_0;
  }
  Coroutine$simulateSuccessfulConnection_984xrs$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$simulateSuccessfulConnection_984xrs$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$simulateSuccessfulConnection_984xrs$.prototype.constructor = Coroutine$simulateSuccessfulConnection_984xrs$;
  Coroutine$simulateSuccessfulConnection_984xrs$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.connectedEventChannel_0.send_11rb$(this.local$connection, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ControlledWebSocketClientMock.prototype.simulateSuccessfulConnection_984xrs$ = function (connection_0, continuation_0, suspended) {
    var instance = new Coroutine$simulateSuccessfulConnection_984xrs$(this, connection_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ControlledWebSocketClientMock.prototype.simulateFailedConnection_tcv7n7$ = function (cause) {
    this.connectedEventChannel_0.close_dbl4no$(cause);
  };
  ControlledWebSocketClientMock.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ControlledWebSocketClientMock',
    interfaces: [WebSocketClient]
  };
  function WebSocketClientTestSuite() {
    this.wsClient_nevmu8$_mc363w$_0 = this.wsClient_nevmu8$_mc363w$_0;
  }
  Object.defineProperty(WebSocketClientTestSuite.prototype, 'wsClient_nevmu8$_0', {
    configurable: true,
    get: function () {
      if (this.wsClient_nevmu8$_mc363w$_0 == null)
        return throwUPAE('wsClient');
      return this.wsClient_nevmu8$_mc363w$_0;
    },
    set: function (wsClient) {
      this.wsClient_nevmu8$_mc363w$_0 = wsClient;
    }
  });
  WebSocketClientTestSuite.prototype.setupClient = function () {
    this.wsClient_nevmu8$_0 = this.provideClient();
  };
  function Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda$lambda(this$WebSocketClientTestSuite_0, port_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$WebSocketClientTestSuite = this$WebSocketClientTestSuite_0;
    this.local$port = port_0;
  }
  Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda$lambda.prototype.constructor = Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda$lambda;
  Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = testEchoWs(this.local$this$WebSocketClientTestSuite.wsClient_nevmu8$_0, 'ws://localhost:' + this.local$port, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function WebSocketClientTestSuite$testWithEchoServer$lambda$lambda(this$WebSocketClientTestSuite_0) {
    return function (port_0, continuation_0, suspended) {
      var instance = new Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda$lambda(this$WebSocketClientTestSuite_0, port_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda(this$WebSocketClientTestSuite_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$WebSocketClientTestSuite = this$WebSocketClientTestSuite_0;
  }
  Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda.prototype.constructor = Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda;
  Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = runAlongEchoWSServer(WebSocketClientTestSuite$testWithEchoServer$lambda$lambda(this.local$this$WebSocketClientTestSuite), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function WebSocketClientTestSuite$testWithEchoServer$lambda(this$WebSocketClientTestSuite_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$WebSocketClientTestSuite$testWithEchoServer$lambda(this$WebSocketClientTestSuite_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  WebSocketClientTestSuite.prototype.testWithEchoServer = function () {
    return runSuspendingTest(WebSocketClientTestSuite$testWithEchoServer$lambda(this));
  };
  WebSocketClientTestSuite.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketClientTestSuite',
    interfaces: []
  };
  function Coroutine$testEchoWs(websocketClient_0, url_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$session = void 0;
    this.local$fortyTwos = void 0;
    this.local$websocketClient = websocketClient_0;
    this.local$url = url_0;
  }
  Coroutine$testEchoWs.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$testEchoWs.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$testEchoWs.prototype.constructor = Coroutine$testEchoWs;
  Coroutine$testEchoWs.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$websocketClient.connect_61zpoe$(this.local$url, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$session = this.result_0;
            this.state_0 = 3;
            this.result_0 = this.local$session.sendText_61zpoe$('hello', this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 4;
            this.result_0 = this.local$session.incomingFrames.receive(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            var helloResponse = this.result_0;
            assertTrue(Kotlin.isType(helloResponse, WebSocketFrame$Text));
            assertEquals('hello', helloResponse.text);
            var array = new Int8Array(3);
            var tmp$;
            tmp$ = array.length - 1 | 0;
            for (var i = 0; i <= tmp$; i++) {
              array[i] = 42;
            }

            this.local$fortyTwos = array;
            this.state_0 = 5;
            this.result_0 = this.local$session.sendBinary_fqrh44$(this.local$fortyTwos, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 5:
            this.state_0 = 6;
            this.result_0 = this.local$session.incomingFrames.receive(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 6:
            var fortyTwosResponse = this.result_0;
            assertTrue(Kotlin.isType(fortyTwosResponse, WebSocketFrame$Binary));
            assertEquals(toList(this.local$fortyTwos), toList(fortyTwosResponse.bytes));
            this.state_0 = 7;
            this.result_0 = this.local$session.close_vqvrqt$(void 0, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 7:
            this.state_0 = 8;
            this.result_0 = this.local$session.incomingFrames.receive(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 8:
            var closeFrame = this.result_0;
            assertTrue(Kotlin.isType(closeFrame, WebSocketFrame$Close), 'Last frame should be a close frame');
            assertEquals(1000, closeFrame.code);
            this.state_0 = 9;
            this.result_0 = delay(L20, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 9:
            assertTrue(this.local$session.incomingFrames.isClosedForReceive, 'The incoming frames channel should be closed');
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function testEchoWs(websocketClient_0, url_0, continuation_0, suspended) {
    var instance = new Coroutine$testEchoWs(websocketClient_0, url_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function WebSocketConnectionMock() {
    this.listener_0 = new WebSocketListenerChannelAdapter();
    this.incomingFrames_bhmmaw$_0 = this.listener_0.incomingFrames;
    this.sentFrames_0 = Channel();
    this.closeEvent_0 = Channel();
    this.closed = false;
  }
  Object.defineProperty(WebSocketConnectionMock.prototype, 'url', {
    configurable: true,
    get: function () {
      return 'dummy-url';
    }
  });
  Object.defineProperty(WebSocketConnectionMock.prototype, 'canSend', {
    configurable: true,
    get: function () {
      return !this.closed;
    }
  });
  Object.defineProperty(WebSocketConnectionMock.prototype, 'incomingFrames', {
    configurable: true,
    get: function () {
      return this.incomingFrames_bhmmaw$_0;
    }
  });
  function Coroutine$sendText_61zpoe$($this, frameText_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frameText = frameText_0;
  }
  Coroutine$sendText_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendText_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendText_61zpoe$.prototype.constructor = Coroutine$sendText_61zpoe$;
  Coroutine$sendText_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.sentFrames_0.send_11rb$(new WebSocketFrame$Text(this.local$frameText), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionMock.prototype.sendText_61zpoe$ = function (frameText_0, continuation_0, suspended) {
    var instance = new Coroutine$sendText_61zpoe$(this, frameText_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$sendBinary_fqrh44$($this, frameData_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$frameData = frameData_0;
  }
  Coroutine$sendBinary_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendBinary_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendBinary_fqrh44$.prototype.constructor = Coroutine$sendBinary_fqrh44$;
  Coroutine$sendBinary_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.sentFrames_0.send_11rb$(new WebSocketFrame$Binary(this.local$frameData), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionMock.prototype.sendBinary_fqrh44$ = function (frameData_0, continuation_0, suspended) {
    var instance = new Coroutine$sendBinary_fqrh44$(this, frameData_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$close_vqvrqt$$default($this, code_0, reason_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$code = code_0;
    this.local$reason = reason_0;
  }
  Coroutine$close_vqvrqt$$default.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$close_vqvrqt$$default.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$close_vqvrqt$$default.prototype.constructor = Coroutine$close_vqvrqt$$default;
  Coroutine$close_vqvrqt$$default.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.$this.closed = true;
            this.state_0 = 2;
            this.result_0 = this.$this.closeEvent_0.send_11rb$(new CloseEvent(this.local$code, this.local$reason), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionMock.prototype.close_vqvrqt$$default = function (code_0, reason_0, continuation_0, suspended) {
    var instance = new Coroutine$close_vqvrqt$$default(this, code_0, reason_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  WebSocketConnectionMock.prototype.waitForSentWsFrameAndSimulateCompletion = function (continuation) {
    return this.sentFrames_0.receive(continuation);
  };
  function Coroutine$expectClose($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$expectClose.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$expectClose.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$expectClose.prototype.constructor = Coroutine$expectClose;
  Coroutine$expectClose.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closeEvent_0.receiveCatching(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var receiveCatching = this.result_0;
            if (!receiveCatching.isSuccess) {
              fail('expected web socket close');
            }
            return receiveCatching.getOrThrow();
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionMock.prototype.expectClose = function (continuation_0, suspended) {
    var instance = new Coroutine$expectClose(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  WebSocketConnectionMock.prototype.expectNoClose = function () {
    if (this.closeEvent_0.tryReceive().isSuccess) {
      fail('the web socket close() method should not have been called');
    }};
  function Coroutine$simulateTextFrameReceived_61zpoe$($this, text_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$text = text_0;
  }
  Coroutine$simulateTextFrameReceived_61zpoe$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$simulateTextFrameReceived_61zpoe$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$simulateTextFrameReceived_61zpoe$.prototype.constructor = Coroutine$simulateTextFrameReceived_61zpoe$;
  Coroutine$simulateTextFrameReceived_61zpoe$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.listener_0.onTextMessage_7tcg9p$(this.local$text, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionMock.prototype.simulateTextFrameReceived_61zpoe$ = function (text_0, continuation_0, suspended) {
    var instance = new Coroutine$simulateTextFrameReceived_61zpoe$(this, text_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$simulateBinaryFrameReceived_fqrh44$($this, data_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$data = data_0;
  }
  Coroutine$simulateBinaryFrameReceived_fqrh44$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$simulateBinaryFrameReceived_fqrh44$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$simulateBinaryFrameReceived_fqrh44$.prototype.constructor = Coroutine$simulateBinaryFrameReceived_fqrh44$;
  Coroutine$simulateBinaryFrameReceived_fqrh44$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.listener_0.onBinaryMessage_1fhb37$(this.local$data, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionMock.prototype.simulateBinaryFrameReceived_fqrh44$ = function (data_0, continuation_0, suspended) {
    var instance = new Coroutine$simulateBinaryFrameReceived_fqrh44$(this, data_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  WebSocketConnectionMock.prototype.simulateError_61zpoe$ = function (message) {
    this.listener_0.onError_dbl4no$(Exception_init(message));
  };
  function Coroutine$simulateClose_vqvrqt$($this, code_0, reason_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$code = code_0;
    this.local$reason = reason_0;
  }
  Coroutine$simulateClose_vqvrqt$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$simulateClose_vqvrqt$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$simulateClose_vqvrqt$.prototype.constructor = Coroutine$simulateClose_vqvrqt$;
  Coroutine$simulateClose_vqvrqt$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.listener_0.onClose_vqvrqt$(this.local$code, this.local$reason, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketConnectionMock.prototype.simulateClose_vqvrqt$ = function (code_0, reason_0, continuation_0, suspended) {
    var instance = new Coroutine$simulateClose_vqvrqt$(this, code_0, reason_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  WebSocketConnectionMock.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketConnectionMock',
    interfaces: [WebSocketConnection]
  };
  function CloseEvent(code, reason) {
    this.code = code;
    this.reason = reason;
  }
  CloseEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CloseEvent',
    interfaces: []
  };
  CloseEvent.prototype.component1 = function () {
    return this.code;
  };
  CloseEvent.prototype.component2 = function () {
    return this.reason;
  };
  CloseEvent.prototype.copy_vqvrqt$ = function (code, reason) {
    return new CloseEvent(code === void 0 ? this.code : code, reason === void 0 ? this.reason : reason);
  };
  CloseEvent.prototype.toString = function () {
    return 'CloseEvent(code=' + Kotlin.toString(this.code) + (', reason=' + Kotlin.toString(this.reason)) + ')';
  };
  CloseEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.code) | 0;
    result = result * 31 + Kotlin.hashCode(this.reason) | 0;
    return result;
  };
  CloseEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.code, other.code) && Kotlin.equals(this.reason, other.reason)))));
  };
  function Coroutine$expectFrame$lambda(this$expectFrame_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$expectFrame = this$expectFrame_0;
  }
  Coroutine$expectFrame$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$expectFrame$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$expectFrame$lambda.prototype.constructor = Coroutine$expectFrame$lambda;
  Coroutine$expectFrame$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$expectFrame.incomingFrames.receiveCatching(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function expectFrame$lambda(this$expectFrame_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$expectFrame$lambda(this$expectFrame_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS;
  function Coroutine$connectWithTimeout$lambda(closure$url_0, this$connectWithTimeout_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$url = closure$url_0;
    this.local$this$connectWithTimeout = this$connectWithTimeout_0;
  }
  Coroutine$connectWithTimeout$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connectWithTimeout$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connectWithTimeout$lambda.prototype.constructor = Coroutine$connectWithTimeout$lambda;
  Coroutine$connectWithTimeout$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$connectWithTimeout.connect_61zpoe$(this.local$closure$url, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function connectWithTimeout$lambda(closure$url_0, this$connectWithTimeout_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$connectWithTimeout$lambda(closure$url_0, this$connectWithTimeout_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$connectWithTimeout($receiver_0, url_0, timeoutMillis_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$url = url_0;
    this.local$timeoutMillis = timeoutMillis_0;
  }
  Coroutine$connectWithTimeout.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connectWithTimeout.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connectWithTimeout.prototype.constructor = Coroutine$connectWithTimeout;
  Coroutine$connectWithTimeout.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$timeoutMillis === void 0)
              this.local$timeoutMillis = L8000;
            var tmp$;
            this.state_0 = 2;
            this.result_0 = withTimeoutOrNull(this.local$timeoutMillis, connectWithTimeout$lambda(this.local$url, this.local$$receiver), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return (tmp$ = this.result_0) != null ? tmp$ : fail('Timed out while connecting to ' + this.local$url);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function connectWithTimeout($receiver_0, url_0, timeoutMillis_0, continuation_0, suspended) {
    var instance = new Coroutine$connectWithTimeout($receiver_0, url_0, timeoutMillis_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$expectTextFrame($receiver_0, frameDescription_0, timeoutMillis_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$frameType = void 0;
    this.local$$receiver = $receiver_0;
    this.local$frameDescription = frameDescription_0;
    this.local$timeoutMillis = timeoutMillis_0;
  }
  Coroutine$expectTextFrame.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$expectTextFrame.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$expectTextFrame.prototype.constructor = Coroutine$expectTextFrame;
  Coroutine$expectTextFrame.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$timeoutMillis === void 0)
              this.local$timeoutMillis = DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS;
            this.local$frameType = getKClass(WebSocketFrame$Text).simpleName;
            this.state_0 = 2;
            this.result_0 = withTimeoutOrNull(this.local$timeoutMillis, expectFrame$lambda(this.local$$receiver), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var result = this.result_0;
            assertNotNull(result, 'Timed out while waiting for ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + ')');
            assertFalse(result.isClosed, 'Expected ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but the channel was closed');
            assertFalse(result.isFailure, 'Expected ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but the channel was failed: ' + toString(result.exceptionOrNull()));
            var frame = result.getOrThrow();
            var message = 'Should have received ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but got ' + frame;
            var tmp$;
            assertIsOfType(frame, createKType(getKClass(WebSocketFrame$Text), [], false), Kotlin.isType(frame, WebSocketFrame$Text), message);
            Kotlin.isType(tmp$ = frame, WebSocketFrame$Text) ? tmp$ : throwCCE();
            this.result_0 = frame;
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function expectTextFrame($receiver_0, frameDescription_0, timeoutMillis_0, continuation_0, suspended) {
    var instance = new Coroutine$expectTextFrame($receiver_0, frameDescription_0, timeoutMillis_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$expectCloseFrame($receiver_0, frameDescription_0, timeoutMillis_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$frameType = void 0;
    this.local$$receiver = $receiver_0;
    this.local$frameDescription = frameDescription_0;
    this.local$timeoutMillis = timeoutMillis_0;
  }
  Coroutine$expectCloseFrame.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$expectCloseFrame.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$expectCloseFrame.prototype.constructor = Coroutine$expectCloseFrame;
  Coroutine$expectCloseFrame.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$frameDescription === void 0)
              this.local$frameDescription = 'no more data expected';
            if (this.local$timeoutMillis === void 0)
              this.local$timeoutMillis = DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS;
            this.local$frameType = getKClass(WebSocketFrame$Close).simpleName;
            this.state_0 = 2;
            this.result_0 = withTimeoutOrNull(this.local$timeoutMillis, expectFrame$lambda(this.local$$receiver), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var result = this.result_0;
            assertNotNull(result, 'Timed out while waiting for ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + ')');
            assertFalse(result.isClosed, 'Expected ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but the channel was closed');
            assertFalse(result.isFailure, 'Expected ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but the channel was failed: ' + toString(result.exceptionOrNull()));
            var frame = result.getOrThrow();
            var message = 'Should have received ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but got ' + frame;
            var tmp$;
            assertIsOfType(frame, createKType(getKClass(WebSocketFrame$Close), [], false), Kotlin.isType(frame, WebSocketFrame$Close), message);
            Kotlin.isType(tmp$ = frame, WebSocketFrame$Close) ? tmp$ : throwCCE();
            this.result_0 = frame;
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function expectCloseFrame($receiver_0, frameDescription_0, timeoutMillis_0, continuation_0, suspended) {
    var instance = new Coroutine$expectCloseFrame($receiver_0, frameDescription_0, timeoutMillis_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$expectFrame(T_0_0, isT_0, $receiver_0, frameDescription_0, timeoutMillis_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$frameType = void 0;
    this.local$T_0 = T_0_0;
    this.local$isT = isT_0;
    this.local$$receiver = $receiver_0;
    this.local$frameDescription = frameDescription_0;
    this.local$timeoutMillis = timeoutMillis_0;
  }
  Coroutine$expectFrame.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$expectFrame.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$expectFrame.prototype.constructor = Coroutine$expectFrame;
  Coroutine$expectFrame.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$timeoutMillis === void 0)
              this.local$timeoutMillis = DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS;
            this.local$frameType = getKClass(this.local$T_0).simpleName;
            this.state_0 = 2;
            this.result_0 = withTimeoutOrNull(this.local$timeoutMillis, expectFrame$lambda(this.local$$receiver), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var result_0 = this.result_0;
            assertNotNull(result_0, 'Timed out while waiting for ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + ')');
            assertFalse(result_0.isClosed, 'Expected ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but the channel was closed');
            assertFalse(result_0.isFailure, 'Expected ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but the channel was failed: ' + toString(result_0.exceptionOrNull()));
            var frame_0 = result_0.getOrThrow();
            var message_0 = 'Should have received ' + toString(this.local$frameType) + ' frame (' + this.local$frameDescription + '), but got ' + frame_0;
            var tmp$_0;
            assertIsOfType(frame_0, getReifiedTypeParameterKType(this.local$T_0), this.local$isT(frame_0), message_0);
            this.local$isT(tmp$_0 = frame_0) ? tmp$_0 : throwCCE();
            return frame_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function expectFrame(T_0_0, isT_0, $receiver_0, frameDescription_0, timeoutMillis_0, continuation_0, suspended) {
    var instance = new Coroutine$expectFrame(T_0_0, isT_0, $receiver_0, frameDescription_0, timeoutMillis_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  defineInlineFunction('krossbow-krossbow-websocket-test.org.hildan.krossbow.websocket.test.expectFrame_g3z3j3$', wrapFunction(function () {
    var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
    var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
    var DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS = Kotlin.Long.fromInt(2000);
    var getKClass = Kotlin.getKClass;
    var withTimeoutOrNull = _.$$importsForInline$$['kotlinx-coroutines-core'].kotlinx.coroutines.withTimeoutOrNull_ms3uf5$;
    var toString = Kotlin.toString;
    var assertNotNull = _.$$importsForInline$$['kotlin-test'].kotlin.test.assertNotNull_tkjle6$;
    var assertFalse = _.$$importsForInline$$['kotlin-test'].kotlin.test.assertFalse_ifx8ge$;
    var getReifiedTypeParameterKType = Kotlin.getReifiedTypeParameterKType;
    var assertIsOfType = _.$$importsForInline$$['kotlin-test'].kotlin.test.assertIsOfType_5l1t6h$;
    var throwCCE = Kotlin.throwCCE;
    function Coroutine$expectFrame$lambda(this$expectFrame_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$this$expectFrame = this$expectFrame_0;
    }
    Coroutine$expectFrame$lambda.$metadata$ = {
      kind: Kotlin.Kind.CLASS,
      simpleName: null,
      interfaces: [CoroutineImpl]
    };
    Coroutine$expectFrame$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$expectFrame$lambda.prototype.constructor = Coroutine$expectFrame$lambda;
    Coroutine$expectFrame$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$expectFrame.incomingFrames.receiveCatching(this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    function expectFrame$lambda(this$expectFrame_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$expectFrame$lambda(this$expectFrame_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    }
    return function (T_0, isT, $receiver, frameDescription, timeoutMillis, continuation) {
      if (timeoutMillis === void 0)
        timeoutMillis = DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS;
      var frameType = getKClass(T_0).simpleName;
      Kotlin.suspendCall(withTimeoutOrNull(timeoutMillis, expectFrame$lambda($receiver), Kotlin.coroutineReceiver()));
      var result_0 = Kotlin.coroutineResult(Kotlin.coroutineReceiver());
      assertNotNull(result_0, 'Timed out while waiting for ' + toString(frameType) + ' frame (' + frameDescription + ')');
      assertFalse(result_0.isClosed, 'Expected ' + toString(frameType) + ' frame (' + frameDescription + '), but the channel was closed');
      assertFalse(result_0.isFailure, 'Expected ' + toString(frameType) + ' frame (' + frameDescription + '), but the channel was failed: ' + toString(result_0.exceptionOrNull()));
      var frame_0 = result_0.getOrThrow();
      var message_0 = 'Should have received ' + toString(frameType) + ' frame (' + frameDescription + '), but got ' + frame_0;
      var tmp$_0;
      assertIsOfType(frame_0, getReifiedTypeParameterKType(T_0), isT(frame_0), message_0);
      isT(tmp$_0 = frame_0) ? tmp$_0 : throwCCE();
      return frame_0;
    };
  }));
  function Coroutine$expectNoMoreFrames$lambda(this$expectNoMoreFrames_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$expectNoMoreFrames = this$expectNoMoreFrames_0;
  }
  Coroutine$expectNoMoreFrames$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$expectNoMoreFrames$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$expectNoMoreFrames$lambda.prototype.constructor = Coroutine$expectNoMoreFrames$lambda;
  Coroutine$expectNoMoreFrames$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$expectNoMoreFrames.incomingFrames.receiveCatching(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function expectNoMoreFrames$lambda(this$expectNoMoreFrames_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$expectNoMoreFrames$lambda(this$expectNoMoreFrames_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$expectNoMoreFrames($receiver_0, eventDescription_0, timeoutMillis_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$eventDescription = eventDescription_0;
    this.local$timeoutMillis = timeoutMillis_0;
  }
  Coroutine$expectNoMoreFrames.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$expectNoMoreFrames.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$expectNoMoreFrames.prototype.constructor = Coroutine$expectNoMoreFrames;
  Coroutine$expectNoMoreFrames.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$eventDescription === void 0)
              this.local$eventDescription = 'end of transmission';
            if (this.local$timeoutMillis === void 0)
              this.local$timeoutMillis = L1000;
            this.state_0 = 2;
            this.result_0 = withTimeoutOrNull(this.local$timeoutMillis, expectNoMoreFrames$lambda(this.local$$receiver), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var result = this.result_0;
            assertNotNull(result, 'Timed out while waiting for incoming frames channel to be closed (' + this.local$eventDescription + ')');
            assertTrue(result.isClosed, 'Frames channel should be closed now (' + this.local$eventDescription + '), got ' + toString(result));
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function expectNoMoreFrames($receiver_0, eventDescription_0, timeoutMillis_0, continuation_0, suspended) {
    var instance = new Coroutine$expectNoMoreFrames($receiver_0, eventDescription_0, timeoutMillis_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function runAlongEchoWSServer(block, continuation) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Implement test WS echo server on JS platform');
  }
  function Coroutine$runSuspendingTest$lambda(closure$block_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$block = closure$block_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$runSuspendingTest$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$runSuspendingTest$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$runSuspendingTest$lambda.prototype.constructor = Coroutine$runSuspendingTest$lambda;
  Coroutine$runSuspendingTest$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$block(this.local$$receiver, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function runSuspendingTest$lambda(closure$block_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$runSuspendingTest$lambda(closure$block_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function runSuspendingTest(block) {
    return promise(coroutines.GlobalScope, void 0, void 0, runSuspendingTest$lambda(block));
  }
  function isBrowser() {
    var tmp$;
    return typeof (tmp$ = (typeof window !== 'undefined' && typeof window.document !== 'undefined')) === 'boolean' ? tmp$ : throwCCE();
  }
  var package$org = _.org || (_.org = {});
  var package$hildan = package$org.hildan || (package$org.hildan = {});
  var package$krossbow = package$hildan.krossbow || (package$hildan.krossbow = {});
  var package$websocket = package$krossbow.websocket || (package$krossbow.websocket = {});
  var package$test = package$websocket.test || (package$websocket.test = {});
  package$test.webSocketClientMock_jg1xp6$ = webSocketClientMock;
  package$test.ControlledWebSocketClientMock = ControlledWebSocketClientMock;
  package$test.WebSocketClientTestSuite = WebSocketClientTestSuite;
  package$test.WebSocketConnectionMock = WebSocketConnectionMock;
  package$test.CloseEvent = CloseEvent;
  Object.defineProperty(package$test, 'DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS', {
    get: function () {
      return DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS;
    }
  });
  package$test.connectWithTimeout_89nvnt$ = connectWithTimeout;
  $$importsForInline$$['krossbow-krossbow-websocket-test'] = _;
  package$test.expectTextFrame_c5986c$ = expectTextFrame;
  package$test.expectCloseFrame_c5986c$ = expectCloseFrame;
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  $$importsForInline$$['kotlin-test'] = $module$kotlin_test;
  package$test.expectNoMoreFrames_c5986c$ = expectNoMoreFrames;
  package$test.runAlongEchoWSServer_lxns2c$ = runAlongEchoWSServer;
  package$test.runSuspendingTest_3q5nlj$ = runSuspendingTest;
  package$test.isBrowser = isBrowser;
  Object.defineProperty(WebSocketConnectionMock.prototype, 'host', Object.getOwnPropertyDescriptor(WebSocketConnection.prototype, 'host'));
  WebSocketConnectionMock.prototype.close_vqvrqt$ = WebSocketConnection.prototype.close_vqvrqt$;
  DEFAULT_EXPECTED_FRAME_TIMEOUT_MILLIS = L2000;
  Kotlin.defineModule('krossbow-krossbow-websocket-test', _);
  return _;
}(module.exports, require('kotlin'), require('krossbow-krossbow-websocket-core'), require('kotlinx-coroutines-core'), require('kotlin-test')));

//# sourceMappingURL=krossbow-krossbow-websocket-test.js.map
