/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.ocr;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"getResourceImage", "Ljava/awt/image/BufferedImage;", "Ljava/lang/Class;", "resourcePath", "", "readImage", "Ljava/io/InputStream;", "Ljava/nio/file/Path;", "toByteArray", "", "format", "simple-ocr"})
public final class ImageHelpersKt {
    @NotNull
    public static final BufferedImage readImage(@NotNull Path $this$readImage) {
        Intrinsics.checkNotNullParameter((Object)$this$readImage, (String)"<this>");
        BufferedImage bufferedImage = ImageIO.read($this$readImage.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(toFile())");
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage readImage(@NotNull InputStream $this$readImage) {
        Intrinsics.checkNotNullParameter((Object)$this$readImage, (String)"<this>");
        BufferedImage bufferedImage = ImageIO.read($this$readImage);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(this)");
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage getResourceImage(@NotNull Class<?> $this$getResourceImage, @NotNull String resourcePath) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter($this$getResourceImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        InputStream inputStream = $this$getResourceImage.getResourceAsStream(resourcePath);
        BufferedImage bufferedImage2 = bufferedImage = inputStream == null ? null : ImageHelpersKt.readImage(inputStream);
        if (bufferedImage == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Resource not found at path ", (Object)resourcePath));
        }
        return bufferedImage;
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull BufferedImage $this$toByteArray, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)$this$toByteArray, format, baos);
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }
}

