/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.ocr;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.hildan.ocr.ColorSimilarityFilter;
import org.hildan.ocr.ImagePart;
import org.hildan.ocr.NoAcceptableMatchException;
import org.hildan.ocr.ScoredImage;
import org.hildan.ocr.SimpleOcrKt;
import org.hildan.ocr.TextDetector;
import org.hildan.ocr.reference.ReferenceImage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B4\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lorg/hildan/ocr/SimpleOcr;", "", "referenceImages", "", "Lorg/hildan/ocr/reference/ReferenceImage;", "textColor", "Lorg/hildan/ocr/Color;", "minRecognitionScore", "", "spaceWidthThreshold", "", "(Ljava/util/List;IDILkotlin/jvm/internal/DefaultConstructorMarker;)V", "textDetector", "Lorg/hildan/ocr/TextDetector;", "(Ljava/util/List;Lorg/hildan/ocr/TextDetector;DI)V", "findClosestReferenceText", "", "subImage", "Ljava/awt/image/BufferedImage;", "originalImage", "recognizeText", "image", "recognizeTextPart", "part", "Lorg/hildan/ocr/ImagePart;", "similarityScoresWithRefImages", "Lorg/hildan/ocr/ScoredImage;", "simple-ocr"})
public final class SimpleOcr {
    @NotNull
    private final List<ReferenceImage> referenceImages;
    @NotNull
    private final TextDetector textDetector;
    private final double minRecognitionScore;
    private final int spaceWidthThreshold;

    public SimpleOcr(@NotNull List<ReferenceImage> referenceImages, @NotNull TextDetector textDetector, double minRecognitionScore, int spaceWidthThreshold) {
        Intrinsics.checkNotNullParameter(referenceImages, (String)"referenceImages");
        Intrinsics.checkNotNullParameter((Object)textDetector, (String)"textDetector");
        this.referenceImages = referenceImages;
        this.textDetector = textDetector;
        this.minRecognitionScore = minRecognitionScore;
        this.spaceWidthThreshold = spaceWidthThreshold;
        if (!(!((Collection)this.referenceImages).isEmpty())) {
            boolean bl = false;
            String string = "no reference image provided";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SimpleOcr(List list, TextDetector textDetector, double d, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            d = 1.0;
        }
        if ((n2 & 8) != 0) {
            n = SimpleOcrKt.access$inferSpaceWidth(list);
        }
        this((List<ReferenceImage>)list, textDetector, d, n);
    }

    private SimpleOcr(List<ReferenceImage> referenceImages, int textColor, double minRecognitionScore, int spaceWidthThreshold) {
        this(referenceImages, new TextDetector(new ColorSimilarityFilter(textColor, 0, 0, 6, null), false, 2, null), minRecognitionScore, spaceWidthThreshold);
    }

    public /* synthetic */ SimpleOcr(List list, int n, double d, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            n2 = SimpleOcrKt.access$inferSpaceWidth(list);
        }
        this(list, n, d, n2, null);
    }

    @NotNull
    public final String recognizeText(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)this.textDetector.splitTextAndSpaces(image), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<ImagePart, CharSequence>(this, image){
            final /* synthetic */ SimpleOcr this$0;
            final /* synthetic */ BufferedImage $image;
            {
                this.this$0 = $receiver;
                this.$image = $image;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ImagePart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SimpleOcr.access$recognizeTextPart(this.this$0, it, this.$image);
            }
        }), (int)30, null))).toString();
    }

    private final String recognizeTextPart(ImagePart part, BufferedImage originalImage) {
        String string;
        ImagePart imagePart = part;
        if (imagePart instanceof ImagePart.TextSubImage) {
            string = this.findClosestReferenceText(((ImagePart.TextSubImage)part).getSubImage(), originalImage);
        } else if (imagePart instanceof ImagePart.Space) {
            string = ((ImagePart.Space)part).getWidth() >= this.spaceWidthThreshold ? " " : "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String findClosestReferenceText(BufferedImage subImage, BufferedImage originalImage) {
        Object v0;
        Iterable $this$maxByOrNull$iv = this.similarityScoresWithRefImages(subImage);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ScoredImage it = (ScoredImage)maxElem$iv;
                boolean bl = false;
                double maxValue$iv = it.getSimilarityScore();
                do {
                    Object e$iv = iterator$iv.next();
                    ScoredImage it2 = (ScoredImage)e$iv;
                    $i$a$-maxByOrNull-SimpleOcr$findClosestReferenceText$bestMatch$1 = false;
                    double v$iv = it2.getSimilarityScore();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        ScoredImage bestMatch = v0;
        if (bestMatch.getSimilarityScore() < this.minRecognitionScore) {
            throw new NoAcceptableMatchException(subImage, originalImage);
        }
        return bestMatch.getRefImage().getText();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScoredImage> similarityScoresWithRefImages(BufferedImage subImage) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.referenceImages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ref;
            ReferenceImage referenceImage = (ReferenceImage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ScoredImage((ReferenceImage)ref, this.textDetector.similarityScore(subImage, ref.getImage())));
        }
        return (List)destination$iv$iv;
    }

    public /* synthetic */ SimpleOcr(List referenceImages, int textColor, double minRecognitionScore, int spaceWidthThreshold, DefaultConstructorMarker $constructor_marker) {
        this((List<ReferenceImage>)referenceImages, textColor, minRecognitionScore, spaceWidthThreshold);
    }

    public static final /* synthetic */ String access$recognizeTextPart(SimpleOcr $this, ImagePart part, BufferedImage originalImage) {
        return $this.recognizeTextPart(part, originalImage);
    }
}

