/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.ocr.reference;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.hildan.ocr.ImageHelpersKt;
import org.hildan.ocr.TextDetector;
import org.hildan.ocr.reference.UniqueImageStore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u001a\u001d\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007\u001aZ\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000628\b\u0002\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00030\u000f\u001a \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016\u001a$\u0010\b\u001a\u00020\u0017*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u0003\u001a(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0006\u001a\u001a\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\u00030\u00030\t*\u00020\u0003H\u0002\u001a\u0019\u0010\u001d\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u0019\u0010\u001f\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"whiteSpaceRegex", "Lkotlin/text/Regex;", "inferTextFromPath", "", "kotlin.jvm.PlatformType", "it", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Ljava/lang/String;", "splitAndSaveSubImages", "", "Lorg/hildan/ocr/TextDetector;", "sampleImage", "Ljava/awt/image/BufferedImage;", "outputDir", "subImageFilenameWithoutExt", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "index", "subImg", "imageStore", "Lorg/hildan/ocr/reference/UniqueImageStore;", "", "sampleImagesDir", "sampleImagesGlob", "splitAndSaveCharacterImages", "sampleText", "splitCodePoints", "escapeCharForFilename", "(Ljava/lang/String;)Ljava/lang/String;", "unescapeFilenameToChar", "simple-ocr"})
@SourceDebugExtension(value={"SMAP\nReferenceImages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceImages.kt\norg/hildan/ocr/reference/ReferenceImagesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1567#2:144\n1598#2,4:145\n1557#2:149\n1628#2,3:150\n1557#2:153\n1628#2,3:154\n1863#2,2:157\n1557#2:159\n1628#2,3:160\n*S KotlinDebug\n*F\n+ 1 ReferenceImages.kt\norg/hildan/ocr/reference/ReferenceImagesKt\n*L\n64#1:144\n64#1:145,4\n81#1:149\n81#1:150,3\n98#1:153\n98#1:154,3\n99#1:157,2\n124#1:159\n124#1:160,3\n*E\n"})
public final class ReferenceImagesKt {
    @NotNull
    private static final Regex whiteSpaceRegex = new Regex("\\s+");

    private static final String inferTextFromPath(Path it) {
        String[] stringArray = new String[]{" "};
        return ReferenceImagesKt.unescapeFilenameToChar((String)StringsKt.split$default((CharSequence)PathsKt.getNameWithoutExtension((Path)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> splitAndSaveSubImages(@NotNull TextDetector $this$splitAndSaveSubImages, @NotNull BufferedImage sampleImage, @NotNull Path outputDir, @NotNull Function2<? super Integer, ? super BufferedImage, String> subImageFilenameWithoutExt) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$splitAndSaveSubImages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sampleImage, (String)"sampleImage");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(subImageFilenameWithoutExt, (String)"subImageFilenameWithoutExt");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(outputDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Iterable $this$mapIndexed$iv = $this$splitAndSaveSubImages.splitTextElements(sampleImage);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void subImg;
            void index;
            Path path;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BufferedImage bufferedImage = (BufferedImage)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path2 = path = outputDir.resolve(subImageFilenameWithoutExt.invoke((Object)((int)index), (Object)subImg) + ".png");
            boolean bl2 = false;
            ImageIO.write((RenderedImage)subImg, "png", path2.toFile());
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List splitAndSaveSubImages$default(TextDetector textDetector, BufferedImage bufferedImage, Path path, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = ReferenceImagesKt::splitAndSaveSubImages$lambda$0;
        }
        return ReferenceImagesKt.splitAndSaveSubImages(textDetector, bufferedImage, path, (Function2<? super Integer, ? super BufferedImage, String>)function2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> splitAndSaveSubImages(@NotNull TextDetector $this$splitAndSaveSubImages, @NotNull BufferedImage sampleImage, @NotNull UniqueImageStore imageStore) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$splitAndSaveSubImages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sampleImage, (String)"sampleImage");
        Intrinsics.checkNotNullParameter((Object)imageStore, (String)"imageStore");
        Iterable $this$map$iv = $this$splitAndSaveSubImages.splitTextElements(sampleImage);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void subImg;
            BufferedImage bufferedImage = (BufferedImage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(imageStore.saveOrGetPath((BufferedImage)subImg));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final void splitAndSaveSubImages(@NotNull TextDetector $this$splitAndSaveSubImages, @NotNull Path sampleImagesDir, @NotNull Path outputDir, @NotNull String sampleImagesGlob) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$splitAndSaveSubImages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sampleImagesDir, (String)"sampleImagesDir");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)sampleImagesGlob, (String)"sampleImagesGlob");
        UniqueImageStore imageStore = new UniqueImageStore(outputDir, null, 2, null);
        Iterable iterable = PathsKt.listDirectoryEntries((Path)sampleImagesDir, (String)sampleImagesGlob);
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ImageHelpersKt.readImage((Path)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BufferedImage it = (BufferedImage)element$iv;
            boolean bl = false;
            ReferenceImagesKt.splitAndSaveSubImages($this$splitAndSaveSubImages, it, imageStore);
        }
    }

    public static /* synthetic */ void splitAndSaveSubImages$default(TextDetector textDetector, Path path, Path path2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "*";
        }
        ReferenceImagesKt.splitAndSaveSubImages(textDetector, path, path2, string);
    }

    @NotNull
    public static final List<Path> splitAndSaveCharacterImages(@NotNull TextDetector $this$splitAndSaveCharacterImages, @NotNull BufferedImage sampleImage, @NotNull String sampleText, @NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter((Object)$this$splitAndSaveCharacterImages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sampleImage, (String)"sampleImage");
        Intrinsics.checkNotNullParameter((Object)sampleText, (String)"sampleText");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        CharSequence charSequence = sampleText;
        Regex regex = whiteSpaceRegex;
        String string = "";
        List<String> codePoints = ReferenceImagesKt.splitCodePoints(regex.replace(charSequence, string));
        return ReferenceImagesKt.splitAndSaveSubImages($this$splitAndSaveCharacterImages, sampleImage, outputDir, (Function2<? super Integer, ? super BufferedImage, String>)((Function2)(arg_0, arg_1) -> ReferenceImagesKt.splitAndSaveCharacterImages$lambda$6(codePoints, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> splitCodePoints(String $this$splitCodePoints) {
        void $this$mapTo$iv$iv;
        IntStream intStream = $this$splitCodePoints.codePoints();
        Intrinsics.checkNotNullExpressionValue((Object)intStream, (String)"codePoints(...)");
        Iterable $this$map$iv = StreamsKt.toList((IntStream)intStream);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.toString((int)it));
        }
        return (List)destination$iv$iv;
    }

    private static final String escapeCharForFilename(String $this$escapeCharForFilename) {
        return switch ($this$escapeCharForFilename) {
            case "." -> "dot";
            case "-" -> "dash";
            case "/" -> "slash";
            case "\\" -> "backslash";
            default -> URLEncoder.encode($this$escapeCharForFilename, Charsets.UTF_8);
        };
    }

    private static final String unescapeFilenameToChar(String $this$unescapeFilenameToChar) {
        return switch ($this$unescapeFilenameToChar) {
            case "dot" -> ".";
            case "dash" -> "-";
            case "slash" -> "/";
            case "backslash" -> "\\";
            default -> URLDecoder.decode($this$unescapeFilenameToChar, Charsets.UTF_8);
        };
    }

    private static final String splitAndSaveSubImages$lambda$0(int n, BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"<unused var>");
        return UUID.randomUUID().toString();
    }

    private static final String splitAndSaveCharacterImages$lambda$6(List $codePoints, int index, BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)$codePoints, (String)"$codePoints");
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"<unused var>");
        Object e = $codePoints.get(index);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        String string = ReferenceImagesKt.escapeCharForFilename((String)e);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeCharForFilename(...)");
        return string;
    }

    public static final /* synthetic */ String access$inferTextFromPath(Path it) {
        return ReferenceImagesKt.inferTextFromPath(it);
    }
}

