/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.ocr.reference;

import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.hildan.ocr.ImageHelpersKt;
import org.hildan.ocr.reference.UniqueImageStoreKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/hildan/ocr/reference/UniqueImageStore;", "", "imagesDir", "Ljava/nio/file/Path;", "imageFormat", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "imagesPathByHash", "Ljava/util/HashMap;", "", "saveOrGetPath", "image", "Ljava/awt/image/BufferedImage;", "imageBytes", "", "findExistingImage", "hash", "writeImage", "simple-ocr"})
@SourceDebugExtension(value={"SMAP\nUniqueImageStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueImageStore.kt\norg/hildan/ocr/reference/UniqueImageStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,73:1\n1485#2:74\n1510#2,3:75\n1513#2,3:85\n1246#2,4:89\n295#2,2:93\n381#3,7:78\n412#3:88\n381#3,7:95\n*S KotlinDebug\n*F\n+ 1 UniqueImageStore.kt\norg/hildan/ocr/reference/UniqueImageStore\n*L\n30#1:74\n30#1:75,3\n30#1:85,3\n31#1:89,4\n55#1:93,2\n30#1:78,7\n31#1:88\n61#1:95,7\n*E\n"})
public final class UniqueImageStore {
    @NotNull
    private final Path imagesDir;
    @NotNull
    private final String imageFormat;
    @NotNull
    private final HashMap<String, List<Path>> imagesPathByHash;

    /*
     * WARNING - void declaration
     */
    public UniqueImageStore(@NotNull Path imagesDir, @NotNull String imageFormat) {
        void destination$iv;
        void $this$mapValuesTo$iv;
        Object list$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)imagesDir, (String)"imagesDir");
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        this.imagesDir = imagesDir;
        this.imageFormat = imageFormat;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.imagesDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Iterable iterable = PathsKt.listDirectoryEntries$default((Path)this.imagesDir, null, (int)1, null);
        UniqueImageStore uniqueImageStore = this;
        boolean $i$f$groupBy22 = false;
        void var5_7 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = UniqueImageStoreKt.access$hash(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        Map $i$f$groupBy22 = new HashMap();
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it$iv;
            list$iv$iv = (Map.Entry)element$iv$iv;
            void var11_15 = destination$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Object k = it$iv.getKey();
            void var18_23 = var11_15;
            boolean bl3 = false;
            List list = (List)entry.getValue();
            List list2 = CollectionsKt.toMutableList((Collection)list);
            var18_23.put(k, list2);
        }
        uniqueImageStore.imagesPathByHash = (HashMap)destination$iv;
    }

    public /* synthetic */ UniqueImageStore(Path path, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "png";
        }
        this(path, string);
    }

    @NotNull
    public final Path saveOrGetPath(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.saveOrGetPath(ImageHelpersKt.toByteArray(image, this.imageFormat));
    }

    @NotNull
    public final Path saveOrGetPath(@NotNull byte[] imageBytes) {
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        String hash = UniqueImageStoreKt.access$hash(imageBytes);
        Path path = this.findExistingImage(imageBytes, hash);
        if (path == null) {
            path = this.writeImage(imageBytes, hash);
        }
        return path;
    }

    private final Path findExistingImage(byte[] imageBytes, String hash) {
        Path path;
        List<Path> similarImages;
        List<Path> list = similarImages = this.imagesPathByHash.get(hash);
        if (list != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    byte[] byArray = Files.readAllBytes(it);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                    if (!Arrays.equals(byArray, imageBytes)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            path = v2;
        } else {
            path = null;
        }
        return path;
    }

    private final Path writeImage(byte[] imageBytes, String hash) {
        Object object;
        Path path = this.imagesDir.resolve(UUID.randomUUID() + "." + this.imageFormat);
        Intrinsics.checkNotNull((Object)path);
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write(path, imageBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Map $this$getOrPut$iv = this.imagesPathByHash;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(hash);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(hash, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(path);
        return path;
    }
}

