/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.ocr;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.hildan.ocr.ColorFilter;
import org.hildan.ocr.ColorSimilarityFilter;
import org.hildan.ocr.ImagePart;
import org.hildan.ocr.TextDetectorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011*\u00020\u000eH\u0002J\u001c\u0010\u0016\u001a\u00020\u0014*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\f\u0010\u001a\u001a\u00020\u000e*\u00020\u000eH\u0002J\f\u0010\u001b\u001a\u00020\u000e*\u00020\u000eH\u0002J\u0014\u0010\u001c\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u001c\u0010!\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/hildan/ocr/TextDetector;", "", "textColorFilter", "Lorg/hildan/ocr/ColorFilter;", "trimSubImagesVertically", "", "<init>", "(Lorg/hildan/ocr/ColorFilter;Z)V", "textColor", "Lorg/hildan/ocr/Color;", "(ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "similarityScore", "", "img1", "Ljava/awt/image/BufferedImage;", "img2", "splitTextElements", "", "image", "splitTextAndSpaces", "Lorg/hildan/ocr/ImagePart;", "splitIntoParts", "extractPart", "colRange", "Lkotlin/ranges/IntRange;", "hasText", "maybeTrimTopAndBottom", "trimTopAndBottom", "hasTextInColumn", "col", "", "hasTextInRow", "row", "hasTextAtPixel", "simple-ocr"})
@SourceDebugExtension(value={"SMAP\nTextDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextDetector.kt\norg/hildan/ocr/TextDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n230#2,2:114\n230#2,2:116\n1755#2,3:118\n1755#2,3:121\n*S KotlinDebug\n*F\n+ 1 TextDetector.kt\norg/hildan/ocr/TextDetector\n*L\n92#1:114,2\n93#1:116,2\n97#1:118,3\n99#1:121,3\n*E\n"})
public final class TextDetector {
    @NotNull
    private final ColorFilter textColorFilter;
    private final boolean trimSubImagesVertically;

    public TextDetector(@NotNull ColorFilter textColorFilter, boolean trimSubImagesVertically) {
        Intrinsics.checkNotNullParameter((Object)textColorFilter, (String)"textColorFilter");
        this.textColorFilter = textColorFilter;
        this.trimSubImagesVertically = trimSubImagesVertically;
    }

    public /* synthetic */ TextDetector(ColorFilter colorFilter, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(colorFilter, bl);
    }

    private TextDetector(int textColor) {
        this(new ColorSimilarityFilter(textColor, 0, 0, 6, null), false, 2, null);
    }

    public final double similarityScore(@NotNull BufferedImage img1, @NotNull BufferedImage img2) {
        Intrinsics.checkNotNullParameter((Object)img1, (String)"img1");
        Intrinsics.checkNotNullParameter((Object)img2, (String)"img2");
        if (img1.getHeight() != img2.getHeight() || img1.getWidth() != img2.getWidth()) {
            return 0.0;
        }
        int score = 0;
        int n = img1.getWidth();
        for (int i = 0; i < n; ++i) {
            int n2 = img1.getHeight();
            for (int j = 0; j < n2; ++j) {
                if (this.hasTextAtPixel(img1, i, j) != this.hasTextAtPixel(img2, i, j)) continue;
                ++score;
            }
        }
        return (double)score / (double)(img1.getWidth() * img1.getHeight());
    }

    @NotNull
    public final List<BufferedImage> splitTextElements(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return TextDetectorKt.filterTextSubImages(this.splitIntoParts(image));
    }

    @NotNull
    public final List<ImagePart> splitTextAndSpaces(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.splitIntoParts(image);
    }

    private final List<ImagePart> splitIntoParts(BufferedImage $this$splitIntoParts) {
        List parts = new ArrayList();
        boolean currentPartHasText = this.hasTextInColumn($this$splitIntoParts, 0);
        int currentPartStart = 0;
        int n = $this$splitIntoParts.getWidth();
        for (int col = 1; col < n; ++col) {
            boolean colHasText = this.hasTextInColumn($this$splitIntoParts, col);
            if (currentPartHasText == colHasText) continue;
            parts.add(this.extractPart($this$splitIntoParts, RangesKt.until((int)currentPartStart, (int)col), currentPartHasText));
            currentPartHasText = colHasText;
            currentPartStart = col;
        }
        parts.add(this.extractPart($this$splitIntoParts, RangesKt.until((int)currentPartStart, (int)$this$splitIntoParts.getWidth()), currentPartHasText));
        return parts;
    }

    private final ImagePart extractPart(BufferedImage $this$extractPart, IntRange colRange, boolean hasText) {
        return hasText ? (ImagePart)new ImagePart.TextSubImage(this.maybeTrimTopAndBottom(TextDetectorKt.access$verticalSlice($this$extractPart, colRange))) : (ImagePart)new ImagePart.Space(TextDetectorKt.access$getLength(colRange));
    }

    private final BufferedImage maybeTrimTopAndBottom(BufferedImage $this$maybeTrimTopAndBottom) {
        return this.trimSubImagesVertically ? this.trimTopAndBottom($this$maybeTrimTopAndBottom) : $this$maybeTrimTopAndBottom;
    }

    private final BufferedImage trimTopAndBottom(BufferedImage $this$trimTopAndBottom) {
        int element$iv;
        int firstTextRow;
        block3: {
            int element$iv2;
            block2: {
                Iterable $this$first$iv = (Iterable)RangesKt.until((int)0, (int)$this$trimTopAndBottom.getHeight());
                boolean $i$f$first = false;
                Iterator iterator = $this$first$iv.iterator();
                while (iterator.hasNext()) {
                    int row = element$iv2 = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    if (!this.hasTextInRow($this$trimTopAndBottom, row)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            firstTextRow = element$iv2;
            Iterable $this$first$iv = (Iterable)RangesKt.downTo((int)($this$trimTopAndBottom.getHeight() - 1), (int)firstTextRow);
            boolean $i$f$first = false;
            Iterator iterator = $this$first$iv.iterator();
            while (iterator.hasNext()) {
                int row = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (!this.hasTextInRow($this$trimTopAndBottom, row)) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        int lastTextRow = element$iv;
        return TextDetectorKt.access$horizontalSlice($this$trimTopAndBottom, new IntRange(firstTextRow, lastTextRow));
    }

    private final boolean hasTextInColumn(BufferedImage $this$hasTextInColumn, int col) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)$this$hasTextInColumn.getHeight());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int row = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!this.hasTextAtPixel($this$hasTextInColumn, col, row)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasTextInRow(BufferedImage $this$hasTextInRow, int row) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)$this$hasTextInRow.getWidth());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int col = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!this.hasTextAtPixel($this$hasTextInRow, col, row)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasTextAtPixel(BufferedImage $this$hasTextAtPixel, int col, int row) {
        return this.textColorFilter.matches-r5trSwE(TextDetectorKt.access$colorAt($this$hasTextAtPixel, col, row));
    }

    public /* synthetic */ TextDetector(int textColor, DefaultConstructorMarker $constructor_marker) {
        this(textColor);
    }
}

