/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.socketio;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.serialization.json.Json;
import org.hildan.socketio.InvalidSocketIOPacketException;
import org.hildan.socketio.RawPacket;
import org.hildan.socketio.SocketIOKt;
import org.hildan.socketio.SocketIOPacket;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u000b\u001a\u00020\u0006*\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/hildan/socketio/SocketIO;", "", "()V", "packetFormatRegex", "Lkotlin/text/Regex;", "decode", "Lorg/hildan/socketio/SocketIOPacket;", "encodedData", "", "parseRawPacket", "Lorg/hildan/socketio/RawPacket;", "toSocketIOPacket", "socketio-kotlin"})
@SourceDebugExtension(value={"SMAP\nSocketIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketIO.kt\norg/hildan/socketio/SocketIO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class SocketIO {
    @NotNull
    public static final SocketIO INSTANCE = new SocketIO();
    @NotNull
    private static final Regex packetFormatRegex = new Regex("(?<packetType>\\d)((?<nBinaryAttachments>\\d+)-)?((?<namespace>/[^,]+),)?(?<ackId>\\d+)?(?<payload>.*)?");

    private SocketIO() {
    }

    @NotNull
    public final SocketIOPacket decode(@NotNull String encodedData) {
        Intrinsics.checkNotNullParameter((Object)encodedData, (String)"encodedData");
        return this.toSocketIOPacket(this.parseRawPacket(encodedData));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final RawPacket parseRawPacket(String encodedData) {
        v0 = SocketIO.packetFormatRegex.matchEntire((CharSequence)encodedData);
        if (v0 == null) {
            throw new InvalidSocketIOPacketException(encodedData, null, 2, null);
        }
        match = v0;
        v1 = encodedData;
        v2 /* !! */  = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"packetType");
        if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getValue()) == null) {
            throw new IllegalStateException("Internal error: Socket.IO format regex was matched but the packetType group is missing".toString());
        }
        v3 = Integer.parseInt((String)v2 /* !! */ );
        v4 /* !! */  = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"nBinaryAttachments");
        v5 = v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .getValue()) != null ? Integer.parseInt((String)v4 /* !! */ ) : 0;
        v6 /* !! */  = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"namespace");
        if (v6 /* !! */  == null || (v6 /* !! */  = v6 /* !! */ .getValue()) == null) {
            v6 /* !! */  = "/";
        }
        v7 = (v8 /* !! */  = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"ackId")) != null && (v8 /* !! */  = v8 /* !! */ .getValue()) != null ? Integer.valueOf(Integer.parseInt((String)v8 /* !! */ )) : null;
        v9 /* !! */  = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"payload");
        if (v9 /* !! */  == null || (v9 /* !! */  = v9 /* !! */ .getValue()) == null) ** GOTO lbl-1000
        var4_4 /* !! */  = var3_3 /* !! */  = v9 /* !! */ ;
        var10_5 = v7;
        var9_6 /* !! */  = v6 /* !! */ ;
        var8_7 = v5;
        var7_8 = v3;
        var6_9 = v1;
        $i$a$-takeIf-SocketIO$parseRawPacket$1 = false;
        var11_11 = !StringsKt.isBlank((CharSequence)((CharSequence)it /* !! */ ));
        v1 = var6_9;
        v3 = var7_8;
        v5 = var8_7;
        v6 /* !! */  = var9_6 /* !! */ ;
        v7 = var10_5;
        v9 /* !! */  = var11_11 != false ? var3_3 /* !! */  : null;
        if (v9 /* !! */  != null) {
            it /* !! */  = v9 /* !! */ ;
            var10_5 = v7;
            var9_6 /* !! */  = v6 /* !! */ ;
            var8_7 = v5;
            var7_8 = v3;
            var6_9 = v1;
            $i$a$-let-SocketIO$parseRawPacket$2 = false;
            var11_12 = Json.Default.parseToJsonElement((String)it /* !! */ );
            v1 = var6_9;
            v3 = var7_8;
            v5 = var8_7;
            v6 /* !! */  = var9_6 /* !! */ ;
            v7 = var10_5;
            v10 = var11_12;
        } else lbl-1000:
        // 2 sources

        {
            v10 = null;
        }
        var12_13 = v10;
        var13_14 = v7;
        var14_15 /* !! */  = v6 /* !! */ ;
        var15_16 = v5;
        var16_17 = v3;
        var17_18 = v1;
        return new RawPacket(var17_18, var16_17, var15_16, (String)var14_15 /* !! */ , var13_14, var12_13);
    }

    private final SocketIOPacket toSocketIOPacket(RawPacket $this$toSocketIOPacket) {
        return switch ($this$toSocketIOPacket.getPacketType()) {
            case 0 -> new SocketIOPacket.Connect($this$toSocketIOPacket.getNamespace(), SocketIOKt.access$connectPayload($this$toSocketIOPacket));
            case 1 -> new SocketIOPacket.Disconnect($this$toSocketIOPacket.getNamespace());
            case 2 -> new SocketIOPacket.Event($this$toSocketIOPacket.getNamespace(), $this$toSocketIOPacket.getAckId(), SocketIOKt.access$messagePayload($this$toSocketIOPacket));
            case 3 -> new SocketIOPacket.Ack($this$toSocketIOPacket.getNamespace(), SocketIOKt.access$mandatoryAckId($this$toSocketIOPacket), SocketIOKt.access$messagePayload($this$toSocketIOPacket));
            case 4 -> new SocketIOPacket.ConnectError($this$toSocketIOPacket.getNamespace(), $this$toSocketIOPacket.getPayload());
            case 5, 6 -> throw new IllegalArgumentException("Binary Socket.IO packets are not supported");
            default -> {
                SocketIOKt.access$invalid($this$toSocketIOPacket, "Unknown Socket.IO packet type " + $this$toSocketIOPacket.getPacketType());
                throw new KotlinNothingValueException();
            }
        };
    }
}

