/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.socketio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.hildan.socketio.EngineIO;
import org.hildan.socketio.EngineIOPacket;
import org.hildan.socketio.InvalidEngineIOPacketException;
import org.hildan.socketio.SocketIOPacket;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00060\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rJ.\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0010\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00060\nJD\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00060\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u00060\nH\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\u0010\u001a\u00020\b\u00a8\u0006\u0017"}, d2={"Lorg/hildan/socketio/EngineIO;", "", "()V", "decodeBatch", "", "Lorg/hildan/socketio/EngineIOPacket;", "T", "batch", "", "deserializePayload", "Lkotlin/Function1;", "decodeBinaryFrame", "Lorg/hildan/socketio/EngineIOPacket$Message;", "", "bytes", "decodeFrame", "text", "decodeSingle", "encodedData", "deserializeTextPayload", "deserializeBinaryPayload", "decodeSocketIO", "Lorg/hildan/socketio/SocketIOPacket;", "socketio-kotlin"})
@SourceDebugExtension(value={"SMAP\nEngineIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EngineIO.kt\norg/hildan/socketio/EngineIO\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,92:1\n1549#2:93\n1620#2,3:94\n96#3:97\n*S KotlinDebug\n*F\n+ 1 EngineIO.kt\norg/hildan/socketio/EngineIO\n*L\n59#1:93\n59#1:94,3\n73#1:97\n*E\n"})
public final class EngineIO {
    @NotNull
    public static final EngineIO INSTANCE = new EngineIO();

    private EngineIO() {
    }

    @NotNull
    public final EngineIOPacket<SocketIOPacket> decodeSocketIO(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.decodeFrame(text, decodeSocketIO.1.INSTANCE);
    }

    @NotNull
    public final <T> EngineIOPacket<T> decodeFrame(@NotNull String text, @NotNull Function1<? super String, ? extends T> deserializePayload) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(deserializePayload, (String)"deserializePayload");
        return this.decodeSingle(text, deserializePayload, decodeFrame.1.INSTANCE);
    }

    @NotNull
    public final EngineIOPacket.Message<byte[]> decodeBinaryFrame(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return new EngineIOPacket.Message<byte[]>(bytes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<EngineIOPacket<T>> decodeBatch(@NotNull String batch, @NotNull Function1<? super String, ? extends T> deserializePayload) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)batch, (String)"batch");
        Intrinsics.checkNotNullParameter(deserializePayload, (String)"deserializePayload");
        String[] stringArray = new String[]{"\u001e"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)batch, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.decodeFrame((String)it, deserializePayload));
        }
        return (List)destination$iv$iv;
    }

    private final <T> EngineIOPacket<T> decodeSingle(String encodedData, Function1<? super String, ? extends T> deserializeTextPayload, Function1<? super byte[], ? extends T> deserializeBinaryPayload) {
        EngineIOPacket engineIOPacket;
        if (StringsKt.isBlank((CharSequence)encodedData)) {
            throw new InvalidEngineIOPacketException(encodedData);
        }
        String payload = StringsKt.drop((String)encodedData, (int)1);
        char packetType = encodedData.charAt(0);
        if (packetType == '0') {
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            engineIOPacket = (EngineIOPacket)this_$iv.decodeFromString((DeserializationStrategy)EngineIOPacket.Open.Companion.serializer(), payload);
        } else if (packetType == '1') {
            engineIOPacket = EngineIOPacket.Close.INSTANCE;
        } else if (packetType == '2') {
            engineIOPacket = new EngineIOPacket.Ping(payload);
        } else if (packetType == '3') {
            engineIOPacket = new EngineIOPacket.Pong(payload);
        } else if (packetType == '4') {
            engineIOPacket = new EngineIOPacket.Message<Object>(deserializeTextPayload.invoke((Object)payload));
        } else if (packetType == '5') {
            engineIOPacket = EngineIOPacket.Upgrade.INSTANCE;
        } else if (packetType == '6') {
            engineIOPacket = EngineIOPacket.Noop.INSTANCE;
        } else if (packetType == 'b') {
            engineIOPacket = new EngineIOPacket.Message<Object>(deserializeBinaryPayload.invoke((Object)Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)payload, (int)0, (int)0, (int)6, null)));
        } else {
            throw new IllegalStateException(("Unknown Engine.IO packet type " + packetType).toString());
        }
        return engineIOPacket;
    }
}

