/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.socketio;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.hildan.socketio.InvalidSocketIOPacketException;
import org.hildan.socketio.RawPacket;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"connectPayload", "Lkotlinx/serialization/json/JsonObject;", "Lorg/hildan/socketio/RawPacket;", "invalid", "", "message", "", "mandatoryAckId", "", "messagePayload", "Lkotlinx/serialization/json/JsonArray;", "socketio-kotlin"})
public final class SocketIOKt {
    private static final JsonObject connectPayload(RawPacket $this$connectPayload) {
        if ($this$connectPayload.getPayload() == null) {
            return null;
        }
        JsonElement jsonElement = $this$connectPayload.getPayload();
        JsonObject jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        if (jsonObject == null) {
            SocketIOKt.invalid($this$connectPayload, "The payload for CONNECT packets must be a JSON object");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    private static final JsonArray messagePayload(RawPacket $this$messagePayload) {
        if ($this$messagePayload.getPayload() == null) {
            SocketIOKt.invalid($this$messagePayload, "The payload for EVENT and ACK packets is mandatory");
            throw new KotlinNothingValueException();
        }
        if (!($this$messagePayload.getPayload() instanceof JsonArray)) {
            SocketIOKt.invalid($this$messagePayload, "The payload for EVENT and ACK packets must be a JSON array");
            throw new KotlinNothingValueException();
        }
        if (((JsonArray)$this$messagePayload.getPayload()).isEmpty()) {
            SocketIOKt.invalid($this$messagePayload, "The array payload for EVENT and ACK packets must not be empty");
            throw new KotlinNothingValueException();
        }
        return (JsonArray)$this$messagePayload.getPayload();
    }

    private static final int mandatoryAckId(RawPacket $this$mandatoryAckId) {
        Integer n = $this$mandatoryAckId.getAckId();
        if (n == null) {
            SocketIOKt.invalid($this$mandatoryAckId, "ACK packet without an Ack ID");
            throw new KotlinNothingValueException();
        }
        return n;
    }

    private static final Void invalid(RawPacket $this$invalid, String message) {
        throw new InvalidSocketIOPacketException($this$invalid.getEncodedData(), message, null, 4, null);
    }

    public static final /* synthetic */ JsonObject access$connectPayload(RawPacket $receiver) {
        return SocketIOKt.connectPayload($receiver);
    }

    public static final /* synthetic */ JsonArray access$messagePayload(RawPacket $receiver) {
        return SocketIOKt.messagePayload($receiver);
    }

    public static final /* synthetic */ int access$mandatoryAckId(RawPacket $receiver) {
        return SocketIOKt.mandatoryAckId($receiver);
    }

    public static final /* synthetic */ Void access$invalid(RawPacket $receiver, String message) {
        return SocketIOKt.invalid($receiver, message);
    }
}

