/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.socketio;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u00c6\u0003JN\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0015\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lorg/hildan/socketio/RawPacket;", "", "encodedData", "", "packetType", "", "nBinaryAttachments", "namespace", "ackId", "payload", "Lkotlinx/serialization/json/JsonElement;", "<init>", "(Ljava/lang/String;IILjava/lang/String;Ljava/lang/Integer;Lkotlinx/serialization/json/JsonElement;)V", "getEncodedData", "()Ljava/lang/String;", "getPacketType", "()I", "getNBinaryAttachments", "getNamespace", "getAckId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPayload", "()Lkotlinx/serialization/json/JsonElement;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;IILjava/lang/String;Ljava/lang/Integer;Lkotlinx/serialization/json/JsonElement;)Lorg/hildan/socketio/RawPacket;", "equals", "", "other", "hashCode", "toString", "socketio-kotlin"})
@SourceDebugExtension(value={"SMAP\nSocketIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketIO.kt\norg/hildan/socketio/RawPacket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
final class RawPacket {
    @NotNull
    private final String encodedData;
    private final int packetType;
    private final int nBinaryAttachments;
    @NotNull
    private final String namespace;
    @Nullable
    private final Integer ackId;
    @Nullable
    private final JsonElement payload;

    public RawPacket(@NotNull String encodedData, int packetType, int nBinaryAttachments, @NotNull String namespace, @Nullable Integer ackId, @Nullable JsonElement payload) {
        Intrinsics.checkNotNullParameter((Object)encodedData, (String)"encodedData");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.encodedData = encodedData;
        this.packetType = packetType;
        this.nBinaryAttachments = nBinaryAttachments;
        this.namespace = namespace;
        this.ackId = ackId;
        this.payload = payload;
        if (!(this.nBinaryAttachments == 0)) {
            boolean bl = false;
            String string = "Socket.IO packets with binary attachments are not supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getEncodedData() {
        return this.encodedData;
    }

    public final int getPacketType() {
        return this.packetType;
    }

    public final int getNBinaryAttachments() {
        return this.nBinaryAttachments;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public final Integer getAckId() {
        return this.ackId;
    }

    @Nullable
    public final JsonElement getPayload() {
        return this.payload;
    }

    @NotNull
    public final String component1() {
        return this.encodedData;
    }

    public final int component2() {
        return this.packetType;
    }

    public final int component3() {
        return this.nBinaryAttachments;
    }

    @NotNull
    public final String component4() {
        return this.namespace;
    }

    @Nullable
    public final Integer component5() {
        return this.ackId;
    }

    @Nullable
    public final JsonElement component6() {
        return this.payload;
    }

    @NotNull
    public final RawPacket copy(@NotNull String encodedData, int packetType, int nBinaryAttachments, @NotNull String namespace, @Nullable Integer ackId, @Nullable JsonElement payload) {
        Intrinsics.checkNotNullParameter((Object)encodedData, (String)"encodedData");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return new RawPacket(encodedData, packetType, nBinaryAttachments, namespace, ackId, payload);
    }

    public static /* synthetic */ RawPacket copy$default(RawPacket rawPacket, String string, int n, int n2, String string2, Integer n3, JsonElement jsonElement, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = rawPacket.encodedData;
        }
        if ((n4 & 2) != 0) {
            n = rawPacket.packetType;
        }
        if ((n4 & 4) != 0) {
            n2 = rawPacket.nBinaryAttachments;
        }
        if ((n4 & 8) != 0) {
            string2 = rawPacket.namespace;
        }
        if ((n4 & 0x10) != 0) {
            n3 = rawPacket.ackId;
        }
        if ((n4 & 0x20) != 0) {
            jsonElement = rawPacket.payload;
        }
        return rawPacket.copy(string, n, n2, string2, n3, jsonElement);
    }

    @NotNull
    public String toString() {
        return "RawPacket(encodedData=" + this.encodedData + ", packetType=" + this.packetType + ", nBinaryAttachments=" + this.nBinaryAttachments + ", namespace=" + this.namespace + ", ackId=" + this.ackId + ", payload=" + this.payload + ")";
    }

    public int hashCode() {
        int result = this.encodedData.hashCode();
        result = result * 31 + Integer.hashCode(this.packetType);
        result = result * 31 + Integer.hashCode(this.nBinaryAttachments);
        result = result * 31 + this.namespace.hashCode();
        result = result * 31 + (this.ackId == null ? 0 : ((Object)this.ackId).hashCode());
        result = result * 31 + (this.payload == null ? 0 : this.payload.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RawPacket)) {
            return false;
        }
        RawPacket rawPacket = (RawPacket)other;
        if (!Intrinsics.areEqual((Object)this.encodedData, (Object)rawPacket.encodedData)) {
            return false;
        }
        if (this.packetType != rawPacket.packetType) {
            return false;
        }
        if (this.nBinaryAttachments != rawPacket.nBinaryAttachments) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.namespace, (Object)rawPacket.namespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ackId, (Object)rawPacket.ackId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.payload, (Object)rawPacket.payload);
    }
}

