/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.socketio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.hildan.socketio.InvalidSocketIOPacketException;
import org.hildan.socketio.PayloadElement;
import org.hildan.socketio.RawPacket;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0002*\u00020\u0005H\u0002\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\u0003*\u00020\u000bH\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000bH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0013"}, d2={"withPlaceholders", "", "Lorg/hildan/socketio/PayloadElement;", "Lkotlinx/serialization/json/JsonArray;", "toPayloadElement", "Lkotlinx/serialization/json/JsonElement;", "isBinaryPlaceholder", "", "(Lkotlinx/serialization/json/JsonElement;)Z", "connectPayload", "Lkotlinx/serialization/json/JsonObject;", "Lorg/hildan/socketio/RawPacket;", "messagePayload", "mandatoryAckId", "", "invalid", "", "message", "", "socketio-kotlin"})
@SourceDebugExtension(value={"SMAP\nSocketIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketIO.kt\norg/hildan/socketio/SocketIOKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1557#2:119\n1628#2,3:120\n*S KotlinDebug\n*F\n+ 1 SocketIO.kt\norg/hildan/socketio/SocketIOKt\n*L\n66#1:119\n66#1:120,3\n*E\n"})
public final class SocketIOKt {
    /*
     * WARNING - void declaration
     */
    private static final List<PayloadElement> withPlaceholders(JsonArray $this$withPlaceholders) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)$this$withPlaceholders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SocketIOKt.toPayloadElement((JsonElement)it));
        }
        return (List)destination$iv$iv;
    }

    private static final PayloadElement toPayloadElement(JsonElement $this$toPayloadElement) {
        PayloadElement payloadElement;
        if (SocketIOKt.isBinaryPlaceholder($this$toPayloadElement)) {
            int attachmentIndex = JsonElementKt.getInt((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)JsonElementKt.getJsonObject((JsonElement)$this$toPayloadElement)), (Object)"num"))));
            payloadElement = new PayloadElement.AttachmentRef(attachmentIndex);
        } else {
            payloadElement = new PayloadElement.Json($this$toPayloadElement);
        }
        return payloadElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isBinaryPlaceholder(JsonElement $this$isBinaryPlaceholder) {
        if (!($this$isBinaryPlaceholder instanceof JsonObject)) return false;
        if (((JsonObject)$this$isBinaryPlaceholder).size() != 2) return false;
        Object object = ((JsonObject)$this$isBinaryPlaceholder).get((Object)"_placeholder");
        if (!(object instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
        if (jsonPrimitive == null) return false;
        boolean bl = Intrinsics.areEqual((Object)JsonElementKt.getBooleanOrNull((JsonPrimitive)jsonPrimitive), (Object)true);
        if (!bl) return false;
        object = ((JsonObject)$this$isBinaryPlaceholder).get((Object)"num");
        if (!(object instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive2 = (JsonPrimitive)object;
        if (jsonPrimitive2 == null) return false;
        Integer n = JsonElementKt.getIntOrNull((JsonPrimitive)jsonPrimitive2);
        if (n == null) return false;
        return true;
    }

    private static final JsonObject connectPayload(RawPacket $this$connectPayload) {
        if ($this$connectPayload.getPayload() == null) {
            return null;
        }
        JsonElement jsonElement = $this$connectPayload.getPayload();
        JsonObject jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        if (jsonObject == null) {
            SocketIOKt.invalid($this$connectPayload, "The payload for CONNECT packets must be a JSON object");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    private static final JsonArray messagePayload(RawPacket $this$messagePayload) {
        if ($this$messagePayload.getPayload() == null) {
            SocketIOKt.invalid($this$messagePayload, "The payload for EVENT and ACK packets is mandatory");
            throw new KotlinNothingValueException();
        }
        if (!($this$messagePayload.getPayload() instanceof JsonArray)) {
            SocketIOKt.invalid($this$messagePayload, "The payload for EVENT and ACK packets must be a JSON array");
            throw new KotlinNothingValueException();
        }
        if (((JsonArray)$this$messagePayload.getPayload()).isEmpty()) {
            SocketIOKt.invalid($this$messagePayload, "The array payload for EVENT and ACK packets must not be empty");
            throw new KotlinNothingValueException();
        }
        return (JsonArray)$this$messagePayload.getPayload();
    }

    private static final int mandatoryAckId(RawPacket $this$mandatoryAckId) {
        Integer n = $this$mandatoryAckId.getAckId();
        if (n == null) {
            SocketIOKt.invalid($this$mandatoryAckId, "ACK packet without an Ack ID");
            throw new KotlinNothingValueException();
        }
        return n;
    }

    private static final Void invalid(RawPacket $this$invalid, String message) {
        throw new InvalidSocketIOPacketException($this$invalid.getEncodedData(), message, null, 4, null);
    }

    public static final /* synthetic */ JsonObject access$connectPayload(RawPacket $receiver) {
        return SocketIOKt.connectPayload($receiver);
    }

    public static final /* synthetic */ JsonArray access$messagePayload(RawPacket $receiver) {
        return SocketIOKt.messagePayload($receiver);
    }

    public static final /* synthetic */ int access$mandatoryAckId(RawPacket $receiver) {
        return SocketIOKt.mandatoryAckId($receiver);
    }

    public static final /* synthetic */ List access$withPlaceholders(JsonArray $receiver) {
        return SocketIOKt.withPlaceholders($receiver);
    }

    public static final /* synthetic */ Void access$invalid(RawPacket $receiver, String message) {
        return SocketIOKt.invalid($receiver, message);
    }
}

