/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.socketio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.bytestring.Base64Kt;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.hildan.socketio.EngineIOPacket;
import org.hildan.socketio.InvalidEngineIOPacketException;
import org.hildan.socketio.SocketIO;
import org.hildan.socketio.SocketIOPacket;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0005\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\n0\rJ.\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\n0\rJJ\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00050\u0012\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\n0\r2\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\n0\rJD\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\n0\u0005\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0017\u001a\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\n0\r2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\n0\rH\u0002J\u0014\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J4\u0010\u001a\u001a\u00020\b\"\u0004\b\u0000\u0010\n2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00050\u00122\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\b0\rJ.\u0010\u001d\u001a\u00020\b\"\u0004\b\u0000\u0010\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\n0\u00052\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\b0\r\u00a8\u0006\u001e"}, d2={"Lorg/hildan/socketio/EngineIO;", "", "<init>", "()V", "decodeSocketIO", "Lorg/hildan/socketio/EngineIOPacket;", "Lorg/hildan/socketio/SocketIOPacket;", "textFrame", "", "decodeWsFrame", "T", "text", "deserializePayload", "Lkotlin/Function1;", "Lorg/hildan/socketio/EngineIOPacket$Message;", "bytes", "Lkotlinx/io/bytestring/ByteString;", "decodeHttpBatch", "", "batch", "deserializeTextPayload", "deserializeBinaryPayload", "decodeSinglePacket", "encodedData", "encodeSocketIO", "packet", "encodeHttpBatch", "packets", "serializePayload", "encodeWsFrame", "socketio-kotlin"})
@SourceDebugExtension(value={"SMAP\nEngineIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EngineIO.kt\norg/hildan/socketio/EngineIO\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1557#2:168\n1628#2,3:169\n222#3:172\n205#3:174\n1#4:173\n*S KotlinDebug\n*F\n+ 1 EngineIO.kt\norg/hildan/socketio/EngineIO\n*L\n82#1:168\n82#1:169,3\n100#1:172\n152#1:174\n*E\n"})
public final class EngineIO {
    @NotNull
    public static final EngineIO INSTANCE = new EngineIO();

    private EngineIO() {
    }

    @NotNull
    public final EngineIOPacket<SocketIOPacket> decodeSocketIO(@NotNull String textFrame) {
        Intrinsics.checkNotNullParameter((Object)textFrame, (String)"textFrame");
        return this.decodeWsFrame(textFrame, (Function1)new Function1<String, SocketIOPacket>((Object)SocketIO.INSTANCE){

            public final SocketIOPacket invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SocketIO)this.receiver).decode(p0);
            }
        });
    }

    @NotNull
    public final <T> EngineIOPacket<T> decodeWsFrame(@NotNull String text, @NotNull Function1<? super String, ? extends T> deserializePayload) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(deserializePayload, (String)"deserializePayload");
        return this.decodeSinglePacket(text, deserializePayload, arg_0 -> EngineIO.decodeWsFrame$lambda$0(text, arg_0));
    }

    @NotNull
    public final <T> EngineIOPacket.Message<T> decodeWsFrame(@NotNull ByteString bytes, @NotNull Function1<? super ByteString, ? extends T> deserializePayload) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(deserializePayload, (String)"deserializePayload");
        return new EngineIOPacket.Message<Object>(deserializePayload.invoke((Object)bytes));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<EngineIOPacket<T>> decodeHttpBatch(@NotNull String batch, @NotNull Function1<? super String, ? extends T> deserializeTextPayload, @NotNull Function1<? super ByteString, ? extends T> deserializeBinaryPayload) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)batch, (String)"batch");
        Intrinsics.checkNotNullParameter(deserializeTextPayload, (String)"deserializeTextPayload");
        Intrinsics.checkNotNullParameter(deserializeBinaryPayload, (String)"deserializeBinaryPayload");
        String[] stringArray = new String[]{"\u001e"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)batch, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.decodeSinglePacket((String)it, deserializeTextPayload, deserializeBinaryPayload));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List decodeHttpBatch$default(EngineIO engineIO, String string, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 4) != 0) {
            function12 = arg_0 -> EngineIO.decodeHttpBatch$lambda$1(function1, arg_0);
        }
        return engineIO.decodeHttpBatch(string, function1, function12);
    }

    private final <T> EngineIOPacket<T> decodeSinglePacket(String encodedData, Function1<? super String, ? extends T> deserializeTextPayload, Function1<? super ByteString, ? extends T> deserializeBinaryPayload) {
        if (StringsKt.isBlank((CharSequence)encodedData)) {
            throw new InvalidEngineIOPacketException(encodedData, "The Engine.IO packet is empty");
        }
        String payload = StringsKt.drop((String)encodedData, (int)1);
        char packetType = encodedData.charAt(0);
        return switch (packetType) {
            case '0' -> {
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                yield (EngineIOPacket)this_$iv.decodeFromString((DeserializationStrategy)EngineIOPacket.Open.Companion.serializer(), payload);
            }
            case '1' -> EngineIOPacket.Close.INSTANCE;
            case '2' -> {
                String var6_7;
                String it = var6_7 = payload;
                boolean $i$a$-takeIf-EngineIO$decodeSinglePacket$1 = false;
                String var9_14 = ((CharSequence)it).length() > 0 ? var6_7 : null;
                yield new EngineIOPacket.Ping(var9_14);
            }
            case '3' -> {
                String var6_8;
                String it = var6_8 = payload;
                boolean $i$a$-takeIf-EngineIO$decodeSinglePacket$2 = false;
                String var10_15 = ((CharSequence)it).length() > 0 ? var6_8 : null;
                yield new EngineIOPacket.Pong(var10_15);
            }
            case '4' -> new EngineIOPacket.Message<Object>(deserializeTextPayload.invoke((Object)payload));
            case '5' -> EngineIOPacket.Upgrade.INSTANCE;
            case '6' -> EngineIOPacket.Noop.INSTANCE;
            case 'b' -> new EngineIOPacket.Message<Object>(deserializeBinaryPayload.invoke((Object)Base64Kt.decodeToByteString$default((Base64)((Base64)Base64.Default), (CharSequence)payload, (int)0, (int)0, (int)6, null)));
            default -> throw new InvalidEngineIOPacketException(encodedData, "Unknown Engine.IO packet type '" + packetType + "'");
        };
    }

    @NotNull
    public final String encodeSocketIO(@NotNull EngineIOPacket<? extends SocketIOPacket> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        return this.encodeWsFrame(packet, EngineIO::encodeSocketIO$lambda$5);
    }

    @NotNull
    public final <T> String encodeHttpBatch(@NotNull List<? extends EngineIOPacket<? extends T>> packets, @NotNull Function1<? super T, String> serializePayload) {
        Intrinsics.checkNotNullParameter(packets, (String)"packets");
        Intrinsics.checkNotNullParameter(serializePayload, (String)"serializePayload");
        return CollectionsKt.joinToString$default((Iterable)packets, (CharSequence)"\u001e", null, null, (int)0, null, arg_0 -> EngineIO.encodeHttpBatch$lambda$6(serializePayload, arg_0), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> String encodeWsFrame(@NotNull EngineIOPacket<? extends T> packet, @NotNull Function1<? super T, String> serializePayload) {
        Object object;
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        Intrinsics.checkNotNullParameter(serializePayload, (String)"serializePayload");
        EngineIOPacket<? extends T> engineIOPacket = packet;
        if (engineIOPacket instanceof EngineIOPacket.Open) {
            void this_$iv;
            Json json = (Json)Json.Default;
            EngineIOPacket<? extends T> value$iv = packet;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            object = "0" + this_$iv.encodeToString((SerializationStrategy)EngineIOPacket.Open.Companion.serializer(), value$iv);
        } else if (engineIOPacket instanceof EngineIOPacket.Close) {
            object = "1";
        } else if (engineIOPacket instanceof EngineIOPacket.Ping) {
            String string = ((EngineIOPacket.Ping)packet).getPayload();
            if (string == null) {
                string = "";
            }
            object = "2" + string;
        } else if (engineIOPacket instanceof EngineIOPacket.Pong) {
            String string = ((EngineIOPacket.Pong)packet).getPayload();
            if (string == null) {
                string = "";
            }
            object = "3" + string;
        } else if (engineIOPacket instanceof EngineIOPacket.Message) {
            object = "4" + serializePayload.invoke(((EngineIOPacket.Message)packet).getPayload());
        } else if (engineIOPacket instanceof EngineIOPacket.Upgrade) {
            object = "5";
        } else if (engineIOPacket instanceof EngineIOPacket.Noop) {
            object = "6";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private static final Object decodeWsFrame$lambda$0(String $text, ByteString it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        throw new InvalidEngineIOPacketException($text, "Unexpected binary payload in web socket text frame");
    }

    private static final Object decodeHttpBatch$lambda$1(Function1 $deserializeTextPayload, ByteString it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $deserializeTextPayload.invoke((Object)ByteStringKt.decodeToString((ByteString)it));
    }

    private static final String encodeSocketIO$lambda$5(SocketIOPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SocketIO.INSTANCE.encode(it);
    }

    private static final CharSequence encodeHttpBatch$lambda$6(Function1 $serializePayload, EngineIOPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.encodeWsFrame(it, $serializePayload);
    }
}

