/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.socketio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.hildan.socketio.InvalidSocketIOPacketException;
import org.hildan.socketio.PayloadElement;
import org.hildan.socketio.RawPacket;
import org.hildan.socketio.SocketIOPacket;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0002*\u00020\u0001H\u0002\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\tH\u0002\u001a\u0012\u0010\r\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\f\u0010\u000e\u001a\u00020\t*\u00020\u0006H\u0002\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0002H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0007*\u00020\u0002H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0007*\u00020\u0002H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0002H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0019"}, d2={"toSocketIOPacket", "Lorg/hildan/socketio/SocketIOPacket;", "Lorg/hildan/socketio/RawPacket;", "toRawPacket", "withPlaceholders", "", "Lorg/hildan/socketio/PayloadElement;", "Lkotlinx/serialization/json/JsonArray;", "toPayloadElement", "Lkotlinx/serialization/json/JsonElement;", "isBinaryPlaceholder", "", "(Lkotlinx/serialization/json/JsonElement;)Z", "toJsonArray", "toJsonElement", "connectPayload", "Lkotlinx/serialization/json/JsonObject;", "messagePayload", "nonEmptyMessagePayload", "mandatoryAckId", "", "invalid", "", "message", "", "socketio-kotlin"})
@SourceDebugExtension(value={"SMAP\nSocketIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketIO.kt\norg/hildan/socketio/SocketIOKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,225:1\n1563#2:226\n1634#2,3:227\n1563#2:230\n1634#2,3:231\n29#3,3:234\n*S KotlinDebug\n*F\n+ 1 SocketIO.kt\norg/hildan/socketio/SocketIOKt\n*L\n155#1:226\n155#1:227,3\n170#1:230\n170#1:231,3\n174#1:234,3\n*E\n"})
public final class SocketIOKt {
    private static final SocketIOPacket toSocketIOPacket(RawPacket $this$toSocketIOPacket) {
        return switch ($this$toSocketIOPacket.getPacketType()) {
            case 0 -> new SocketIOPacket.Connect($this$toSocketIOPacket.getNamespace(), SocketIOKt.connectPayload($this$toSocketIOPacket));
            case 1 -> new SocketIOPacket.Disconnect($this$toSocketIOPacket.getNamespace());
            case 2 -> new SocketIOPacket.Event($this$toSocketIOPacket.getNamespace(), $this$toSocketIOPacket.getAckId(), SocketIOKt.nonEmptyMessagePayload($this$toSocketIOPacket));
            case 3 -> new SocketIOPacket.Ack($this$toSocketIOPacket.getNamespace(), SocketIOKt.mandatoryAckId($this$toSocketIOPacket), SocketIOKt.messagePayload($this$toSocketIOPacket));
            case 4 -> new SocketIOPacket.ConnectError($this$toSocketIOPacket.getNamespace(), $this$toSocketIOPacket.getPayload());
            case 5 -> new SocketIOPacket.BinaryEvent($this$toSocketIOPacket.getNamespace(), $this$toSocketIOPacket.getAckId(), SocketIOKt.withPlaceholders(SocketIOKt.nonEmptyMessagePayload($this$toSocketIOPacket)), $this$toSocketIOPacket.getNBinaryAttachments());
            case 6 -> new SocketIOPacket.BinaryAck($this$toSocketIOPacket.getNamespace(), SocketIOKt.mandatoryAckId($this$toSocketIOPacket), SocketIOKt.withPlaceholders(SocketIOKt.messagePayload($this$toSocketIOPacket)), $this$toSocketIOPacket.getNBinaryAttachments());
            default -> {
                SocketIOKt.invalid($this$toSocketIOPacket, "Unknown Socket.IO packet type " + $this$toSocketIOPacket.getPacketType());
                throw new KotlinNothingValueException();
            }
        };
    }

    private static final RawPacket toRawPacket(SocketIOPacket $this$toRawPacket) {
        RawPacket rawPacket;
        SocketIOPacket socketIOPacket = $this$toRawPacket;
        if (socketIOPacket instanceof SocketIOPacket.Connect) {
            String string = ((SocketIOPacket.Connect)$this$toRawPacket).getNamespace();
            JsonObject jsonObject = ((SocketIOPacket.Connect)$this$toRawPacket).getPayload();
            rawPacket = new RawPacket("", 0, 0, string, null, (JsonElement)jsonObject);
        } else if (socketIOPacket instanceof SocketIOPacket.Disconnect) {
            String string = ((SocketIOPacket.Disconnect)$this$toRawPacket).getNamespace();
            rawPacket = new RawPacket("", 1, 0, string, null, null);
        } else if (socketIOPacket instanceof SocketIOPacket.Event) {
            String string = ((SocketIOPacket.Event)$this$toRawPacket).getNamespace();
            Integer n = ((SocketIOPacket.Event)$this$toRawPacket).getAckId();
            JsonArray jsonArray = ((SocketIOPacket.Event)$this$toRawPacket).getPayload();
            rawPacket = new RawPacket("", 2, 0, string, n, (JsonElement)jsonArray);
        } else if (socketIOPacket instanceof SocketIOPacket.Ack) {
            String string = ((SocketIOPacket.Ack)$this$toRawPacket).getNamespace();
            int n = ((SocketIOPacket.Ack)$this$toRawPacket).getAckId();
            JsonArray jsonArray = ((SocketIOPacket.Ack)$this$toRawPacket).getPayload();
            rawPacket = new RawPacket("", 3, 0, string, n, (JsonElement)jsonArray);
        } else if (socketIOPacket instanceof SocketIOPacket.ConnectError) {
            String string = ((SocketIOPacket.ConnectError)$this$toRawPacket).getNamespace();
            JsonElement jsonElement = ((SocketIOPacket.ConnectError)$this$toRawPacket).getErrorData();
            rawPacket = new RawPacket("", 4, 0, string, null, jsonElement);
        } else if (socketIOPacket instanceof SocketIOPacket.BinaryEvent) {
            int n = ((SocketIOPacket.BinaryEvent)$this$toRawPacket).getNBinaryAttachments();
            String string = ((SocketIOPacket.BinaryEvent)$this$toRawPacket).getNamespace();
            Integer n2 = ((SocketIOPacket.BinaryEvent)$this$toRawPacket).getAckId();
            JsonArray jsonArray = SocketIOKt.toJsonArray(((SocketIOPacket.BinaryEvent)$this$toRawPacket).getPayload());
            rawPacket = new RawPacket("", 5, n, string, n2, (JsonElement)jsonArray);
        } else if (socketIOPacket instanceof SocketIOPacket.BinaryAck) {
            int n = ((SocketIOPacket.BinaryAck)$this$toRawPacket).getNBinaryAttachments();
            String string = ((SocketIOPacket.BinaryAck)$this$toRawPacket).getNamespace();
            int n3 = ((SocketIOPacket.BinaryAck)$this$toRawPacket).getAckId();
            JsonArray jsonArray = SocketIOKt.toJsonArray(((SocketIOPacket.BinaryAck)$this$toRawPacket).getPayload());
            rawPacket = new RawPacket("", 6, n, string, n3, (JsonElement)jsonArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rawPacket;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PayloadElement> withPlaceholders(JsonArray $this$withPlaceholders) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)$this$withPlaceholders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SocketIOKt.toPayloadElement((JsonElement)it));
        }
        return (List)destination$iv$iv;
    }

    private static final PayloadElement toPayloadElement(JsonElement $this$toPayloadElement) {
        PayloadElement payloadElement;
        if (SocketIOKt.isBinaryPlaceholder($this$toPayloadElement)) {
            int attachmentIndex = JsonElementKt.getInt((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)JsonElementKt.getJsonObject((JsonElement)$this$toPayloadElement)), (Object)"num"))));
            payloadElement = new PayloadElement.AttachmentRef(attachmentIndex);
        } else {
            payloadElement = new PayloadElement.Json($this$toPayloadElement);
        }
        return payloadElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isBinaryPlaceholder(JsonElement $this$isBinaryPlaceholder) {
        if (!($this$isBinaryPlaceholder instanceof JsonObject)) return false;
        if (((JsonObject)$this$isBinaryPlaceholder).size() != 2) return false;
        Object object = ((JsonObject)$this$isBinaryPlaceholder).get((Object)"_placeholder");
        if (!(object instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
        if (jsonPrimitive == null) return false;
        boolean bl = Intrinsics.areEqual((Object)JsonElementKt.getBooleanOrNull((JsonPrimitive)jsonPrimitive), (Object)true);
        if (!bl) return false;
        object = ((JsonObject)$this$isBinaryPlaceholder).get((Object)"num");
        if (!(object instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive2 = (JsonPrimitive)object;
        if (jsonPrimitive2 == null) return false;
        Integer n = JsonElementKt.getIntOrNull((JsonPrimitive)jsonPrimitive2);
        if (n == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonArray toJsonArray(List<? extends PayloadElement> $this$toJsonArray) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toJsonArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PayloadElement payloadElement = (PayloadElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SocketIOKt.toJsonElement((PayloadElement)it));
        }
        List list = (List)destination$iv$iv;
        return new JsonArray(list);
    }

    private static final JsonElement toJsonElement(PayloadElement $this$toJsonElement) {
        JsonElement jsonElement;
        PayloadElement payloadElement = $this$toJsonElement;
        if (payloadElement instanceof PayloadElement.Json) {
            jsonElement = ((PayloadElement.Json)$this$toJsonElement).getJsonElement();
        } else if (payloadElement instanceof PayloadElement.AttachmentRef) {
            JsonObjectBuilder builder$iv;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$toJsonElement_u24lambda_u242 = builder$iv = new JsonObjectBuilder();
            boolean bl = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$toJsonElement_u24lambda_u242, (String)"_placeholder", (Boolean)true);
            $this$toJsonElement_u24lambda_u242.put("num", (JsonElement)JsonElementKt.JsonPrimitive((Number)((PayloadElement.AttachmentRef)$this$toJsonElement).getAttachmentIndex()));
            jsonElement = (JsonElement)builder$iv.build();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonElement;
    }

    private static final JsonObject connectPayload(RawPacket $this$connectPayload) {
        if ($this$connectPayload.getPayload() == null) {
            return null;
        }
        JsonElement jsonElement = $this$connectPayload.getPayload();
        JsonObject jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        if (jsonObject == null) {
            SocketIOKt.invalid($this$connectPayload, "The payload for CONNECT packets must be a JSON object");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    private static final JsonArray messagePayload(RawPacket $this$messagePayload) {
        if ($this$messagePayload.getPayload() == null) {
            SocketIOKt.invalid($this$messagePayload, "The payload for EVENT and ACK packets is mandatory");
            throw new KotlinNothingValueException();
        }
        if (!($this$messagePayload.getPayload() instanceof JsonArray)) {
            SocketIOKt.invalid($this$messagePayload, "The payload for EVENT and ACK packets must be a JSON array");
            throw new KotlinNothingValueException();
        }
        return (JsonArray)$this$messagePayload.getPayload();
    }

    private static final JsonArray nonEmptyMessagePayload(RawPacket $this$nonEmptyMessagePayload) {
        JsonArray payload = SocketIOKt.messagePayload($this$nonEmptyMessagePayload);
        if (payload.isEmpty()) {
            SocketIOKt.invalid($this$nonEmptyMessagePayload, "The array payload for EVENT packets must not be empty");
            throw new KotlinNothingValueException();
        }
        return payload;
    }

    private static final int mandatoryAckId(RawPacket $this$mandatoryAckId) {
        Integer n = $this$mandatoryAckId.getAckId();
        if (n == null) {
            SocketIOKt.invalid($this$mandatoryAckId, "ACK packet without an Ack ID");
            throw new KotlinNothingValueException();
        }
        return n;
    }

    private static final Void invalid(RawPacket $this$invalid, String message) {
        throw new InvalidSocketIOPacketException($this$invalid.getEncodedData(), message, null, 4, null);
    }

    public static final /* synthetic */ SocketIOPacket access$toSocketIOPacket(RawPacket $receiver) {
        return SocketIOKt.toSocketIOPacket($receiver);
    }

    public static final /* synthetic */ RawPacket access$toRawPacket(SocketIOPacket $receiver) {
        return SocketIOKt.toRawPacket($receiver);
    }
}

