/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.fitting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.hipparchus.analysis.function.HarmonicOscillator;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.fitting.HarmonicCurveFitter;
import org.hipparchus.fitting.WeightedObservedPoint;
import org.hipparchus.fitting.WeightedObservedPoints;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public class HarmonicCurveFitterTest {
    @Test(expected=MathIllegalArgumentException.class)
    public void testPreconditions1() {
        HarmonicCurveFitter.create().fit((Collection)new WeightedObservedPoints().toList());
    }

    @Test
    public void testNoError() {
        double a = 0.2;
        double w = 3.4;
        double p = 4.1;
        HarmonicOscillator f = new HarmonicOscillator(0.2, 3.4, 4.1);
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (double x = 0.0; x < 1.3; x += 0.01) {
            points.add(1.0, x, f.value(x));
        }
        HarmonicCurveFitter fitter = HarmonicCurveFitter.create();
        double[] fitted = fitter.fit((Collection)points.toList());
        Assert.assertEquals((double)0.2, (double)fitted[0], (double)1.0E-13);
        Assert.assertEquals((double)3.4, (double)fitted[1], (double)1.0E-13);
        Assert.assertEquals((double)4.1, (double)MathUtils.normalizeAngle((double)fitted[2], (double)4.1), (double)1.0E-13);
        HarmonicOscillator ff = new HarmonicOscillator(fitted[0], fitted[1], fitted[2]);
        for (double x = -1.0; x < 1.0; x += 0.01) {
            Assert.assertTrue((FastMath.abs((double)(f.value(x) - ff.value(x))) < 1.0E-13 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test1PercentError() {
        Random randomizer = new Random(64925784252L);
        double a = 0.2;
        double w = 3.4;
        double p = 4.1;
        HarmonicOscillator f = new HarmonicOscillator(0.2, 3.4, 4.1);
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (double x = 0.0; x < 10.0; x += 0.1) {
            points.add(1.0, x, f.value(x) + 0.01 * randomizer.nextGaussian());
        }
        HarmonicCurveFitter fitter = HarmonicCurveFitter.create();
        double[] fitted = fitter.fit((Collection)points.toList());
        Assert.assertEquals((double)0.2, (double)fitted[0], (double)7.6E-4);
        Assert.assertEquals((double)3.4, (double)fitted[1], (double)0.0027);
        Assert.assertEquals((double)4.1, (double)MathUtils.normalizeAngle((double)fitted[2], (double)4.1), (double)0.013);
    }

    @Test
    public void testTinyVariationsData() {
        Random randomizer = new Random(64925784252L);
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (double x = 0.0; x < 10.0; x += 0.1) {
            points.add(1.0, x, 1.0E-7 * randomizer.nextGaussian());
        }
        HarmonicCurveFitter fitter = HarmonicCurveFitter.create();
        fitter.fit((Collection)points.toList());
    }

    @Test
    public void testInitialGuess() {
        Random randomizer = new Random(45314242L);
        double a = 0.2;
        double w = 3.4;
        double p = 4.1;
        HarmonicOscillator f = new HarmonicOscillator(0.2, 3.4, 4.1);
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (double x = 0.0; x < 10.0; x += 0.1) {
            points.add(1.0, x, f.value(x) + 0.01 * randomizer.nextGaussian());
        }
        HarmonicCurveFitter fitter = HarmonicCurveFitter.create().withStartPoint(new double[]{0.15, 3.6, 4.5});
        double[] fitted = fitter.fit((Collection)points.toList());
        Assert.assertEquals((double)0.2, (double)fitted[0], (double)0.0012);
        Assert.assertEquals((double)3.4, (double)fitted[1], (double)0.0033);
        Assert.assertEquals((double)4.1, (double)MathUtils.normalizeAngle((double)fitted[2], (double)4.1), (double)0.017);
    }

    @Test
    public void testUnsorted() {
        int i;
        Random randomizer = new Random(64925784252L);
        double a = 0.2;
        double w = 3.4;
        double p = 4.1;
        HarmonicOscillator f = new HarmonicOscillator(0.2, 3.4, 4.1);
        int size = 100;
        double[] xTab = new double[100];
        double[] yTab = new double[100];
        for (i = 0; i < 100; ++i) {
            xTab[i] = 0.1 * (double)i;
            yTab[i] = f.value(xTab[i]) + 0.01 * randomizer.nextGaussian();
        }
        for (i = 0; i < 100; ++i) {
            int i1 = randomizer.nextInt(100);
            int i2 = randomizer.nextInt(100);
            double xTmp = xTab[i1];
            double yTmp = yTab[i1];
            xTab[i1] = xTab[i2];
            yTab[i1] = yTab[i2];
            xTab[i2] = xTmp;
            yTab[i2] = yTmp;
        }
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (int i2 = 0; i2 < 100; ++i2) {
            points.add(1.0, xTab[i2], yTab[i2]);
        }
        HarmonicCurveFitter fitter = HarmonicCurveFitter.create();
        double[] fitted = fitter.fit((Collection)points.toList());
        Assert.assertEquals((double)0.2, (double)fitted[0], (double)7.6E-4);
        Assert.assertEquals((double)3.4, (double)fitted[1], (double)0.0035);
        Assert.assertEquals((double)4.1, (double)MathUtils.normalizeAngle((double)fitted[2], (double)4.1), (double)0.015);
    }

    @Test(expected=MathIllegalStateException.class)
    public void testMath844() {
        double[] y = new double[]{0.0, 1.0, 2.0, 3.0, 2.0, 1.0, 0.0, -1.0, -2.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 2.0, 1.0, 0.0, -1.0, -2.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 2.0, 1.0, 0.0};
        ArrayList<WeightedObservedPoint> points = new ArrayList<WeightedObservedPoint>();
        for (int i = 0; i < y.length; ++i) {
            points.add(new WeightedObservedPoint(1.0, (double)i, y[i]));
        }
        new HarmonicCurveFitter.ParameterGuesser(points);
    }
}

