/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.fitting;

import java.util.Collection;
import java.util.Random;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.analysis.ParametricUnivariateFunction;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.fitting.SimpleCurveFitter;
import org.hipparchus.fitting.WeightedObservedPoints;
import org.hipparchus.random.RandomDataGenerator;
import org.junit.jupiter.api.Test;

class SimpleCurveFitterTest {
    SimpleCurveFitterTest() {
    }

    @Test
    void testPolynomialFit() {
        Random randomizer = new Random(53882150042L);
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(64925784252L);
        double[] coeff = new double[]{12.9, -3.4, 2.1};
        PolynomialFunction f = new PolynomialFunction(coeff);
        WeightedObservedPoints obs = new WeightedObservedPoints();
        for (int i = 0; i < 100; ++i) {
            double x = randomDataGenerator.nextUniform(-100.0, 100.0);
            obs.add(x, f.value(x) + 0.1 * randomizer.nextGaussian());
        }
        PolynomialFunction.Parametric function = new PolynomialFunction.Parametric();
        SimpleCurveFitter fitter = SimpleCurveFitter.create((ParametricUnivariateFunction)function, (double[])new double[]{-1.0E20, 3.0E15, -5.0E25});
        double[] best = fitter.fit((Collection)obs.toList());
        UnitTestUtils.customAssertEquals((String)"best != coeff", (double[])coeff, (double[])best, (double)0.02);
    }
}

