/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.fitting;

import java.util.List;
import org.hipparchus.fitting.WeightedObservedPoint;
import org.hipparchus.fitting.WeightedObservedPoints;
import org.hipparchus.util.Precision;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WeightedObservedPointsTest {
    WeightedObservedPointsTest() {
    }

    @Test
    void testAdd1() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        double x = 1.2;
        double y = 34.56;
        double w = 0.789;
        store.add(0.789, 1.2, 34.56);
        Assertions.assertTrue((boolean)this.lastElementIsSame(store, new WeightedObservedPoint(0.789, 1.2, 34.56)));
    }

    @Test
    void testAdd2() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        double x = 1.2;
        double y = 34.56;
        double w = 0.789;
        store.add(new WeightedObservedPoint(0.789, 1.2, 34.56));
        Assertions.assertTrue((boolean)this.lastElementIsSame(store, new WeightedObservedPoint(0.789, 1.2, 34.56)));
    }

    @Test
    void testAdd3() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        double x = 1.2;
        double y = 34.56;
        store.add(1.2, 34.56);
        Assertions.assertTrue((boolean)this.lastElementIsSame(store, new WeightedObservedPoint(1.0, 1.2, 34.56)));
    }

    @Test
    void testClear() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        store.add(new WeightedObservedPoint(1.0, 2.0, 3.0));
        store.add(new WeightedObservedPoint(2.0, -1.0, -2.0));
        Assertions.assertEquals((int)2, (int)store.toList().size());
        store.clear();
        Assertions.assertEquals((int)0, (int)store.toList().size());
    }

    @Test
    void testToListCopy() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        store.add(new WeightedObservedPoint(1.0, 2.0, 3.0));
        store.add(new WeightedObservedPoint(2.0, -3.0, -4.0));
        List list = store.toList();
        Assertions.assertEquals((int)2, (int)list.size());
        list.add(new WeightedObservedPoint(1.2, 3.4, 5.6));
        Assertions.assertFalse((list.size() == store.toList().size() ? 1 : 0) != 0);
        store.clear();
        Assertions.assertFalse((list.size() == 0 ? 1 : 0) != 0);
    }

    private boolean lastElementIsSame(WeightedObservedPoints store, WeightedObservedPoint point) {
        List list = store.toList();
        WeightedObservedPoint lastPoint = (WeightedObservedPoint)list.get(list.size() - 1);
        if (!Precision.equals((double)lastPoint.getX(), (double)point.getX())) {
            return false;
        }
        if (!Precision.equals((double)lastPoint.getY(), (double)point.getY())) {
            return false;
        }
        return Precision.equals((double)lastPoint.getWeight(), (double)point.getWeight());
    }
}

