/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.fitting;

import java.util.Collection;
import java.util.Random;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.fitting.PolynomialCurveFitter;
import org.hipparchus.fitting.WeightedObservedPoints;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.util.FastMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PolynomialCurveFitterTest {
    PolynomialCurveFitterTest() {
    }

    @Test
    void testFit() {
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(64925784252L);
        double[] coeff = new double[]{12.9, -3.4, 2.1};
        PolynomialFunction f = new PolynomialFunction(coeff);
        WeightedObservedPoints obs = new WeightedObservedPoints();
        for (int i = 0; i < 100; ++i) {
            double x = randomDataGenerator.nextUniform(-100.0, 100.0);
            obs.add(x, f.value(x));
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)0).withStartPoint(new double[]{-1.0E-20, 3.0E15, -5.0E25});
        double[] best = fitter.fit((Collection)obs.toList());
        UnitTestUtils.customAssertEquals((String)"best != coeff", (double[])coeff, (double[])best, (double)1.0E-12);
    }

    @Test
    void testNoError() {
        Random randomizer = new Random(64925784252L);
        for (int degree = 1; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)degree);
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (int i = 0; i <= degree; ++i) {
                obs.add(1.0, (double)i, p.value((double)i));
            }
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)obs.toList()));
            for (double x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                Assertions.assertEquals((double)0.0, (double)error, (double)1.0E-6);
            }
        }
    }

    @Test
    void testSmallError() {
        Random randomizer = new Random(53882150042L);
        double maxError = 0.0;
        for (int degree = 0; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)degree);
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (double x = -1.0; x < 1.0; x += 0.01) {
                obs.add(1.0, x, p.value(x) + 0.1 * randomizer.nextGaussian());
            }
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)obs.toList()));
            for (double x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                maxError = FastMath.max((double)maxError, (double)error);
                Assertions.assertTrue((FastMath.abs((double)error) < 0.1 ? 1 : 0) != 0);
            }
        }
        Assertions.assertTrue((maxError > 0.01 ? 1 : 0) != 0);
    }

    @Test
    void testRedundantSolvable() {
        this.checkUnsolvableProblem(true);
    }

    @Test
    void testLargeSample() {
        Random randomizer = new Random(6147774190404187803L);
        double maxError = 0.0;
        for (int degree = 0; degree < 10; ++degree) {
            double x;
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)degree);
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (int i = 0; i < 40000; ++i) {
                x = -1.0 + (double)i / 20000.0;
                obs.add(1.0, x, p.value(x) + 0.1 * randomizer.nextGaussian());
            }
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)obs.toList()));
            for (x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                maxError = FastMath.max((double)maxError, (double)error);
                Assertions.assertTrue((FastMath.abs((double)error) < 0.01 ? 1 : 0) != 0);
            }
        }
        Assertions.assertTrue((maxError > 0.001 ? 1 : 0) != 0);
    }

    private void checkUnsolvableProblem(boolean solvable) {
        Random randomizer = new Random(1248788532L);
        for (int degree = 0; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)degree);
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (double x = -1.0; x < 1.0; x += 0.01) {
                obs.add(1.0, 0.0, p.value(0.0));
            }
            try {
                fitter.fit((Collection)obs.toList());
                Assertions.assertTrue((solvable || degree == 0 ? 1 : 0) != 0);
                continue;
            }
            catch (MathIllegalStateException e) {
                Assertions.assertTrue((!solvable && degree > 0 ? 1 : 0) != 0);
            }
        }
    }

    private PolynomialFunction buildRandomPolynomial(int degree, Random randomizer) {
        double[] coefficients = new double[degree + 1];
        for (int i = 0; i <= degree; ++i) {
            coefficients[i] = randomizer.nextGaussian();
        }
        return new PolynomialFunction(coefficients);
    }
}

