/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.oned;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class Vector1DTest {
    @Test
    public void testConstructors() throws MathIllegalArgumentException {
        this.checkVector(new Vector1D(3.0, new Vector1D(1.0471975511965976)), Math.PI);
        this.checkVector(new Vector1D(2.0, Vector1D.ONE, -3.0, new Vector1D(2.0)), -4.0);
        this.checkVector(new Vector1D(2.0, Vector1D.ONE, 5.0, new Vector1D(2.0), -3.0, new Vector1D(3.0)), 3.0);
        this.checkVector(new Vector1D(2.0, Vector1D.ONE, 5.0, new Vector1D(2.0), 5.0, new Vector1D(-2.0), -3.0, new Vector1D(-3.0)), 11.0);
    }

    @Test
    public void testSpace() {
        Space space = new Vector1D(1.0).getSpace();
        Assert.assertEquals((long)1L, (long)space.getDimension());
    }

    @Test
    public void testZero() {
        Assert.assertEquals((double)0.0, (double)new Vector1D(1.0).getZero().getNorm(), (double)1.0E-15);
    }

    @Test
    public void testEquals() {
        Vector1D u1 = new Vector1D(1.0);
        Vector1D u2 = new Vector1D(1.0);
        Assert.assertTrue((boolean)u1.equals((Object)u1));
        Assert.assertTrue((boolean)u1.equals((Object)u2));
        Assert.assertFalse((boolean)u1.equals((Object)new Vector1D(1.0 + 10.0 * Precision.EPSILON)));
        Assert.assertTrue((boolean)new Vector1D(Double.NaN).equals((Object)new Vector1D(Double.NaN)));
    }

    @Test
    public void testHash() {
        Assert.assertEquals((long)new Vector1D(Double.NaN).hashCode(), (long)new Vector1D(Double.NaN).hashCode());
        Vector1D u = new Vector1D(1.0);
        Vector1D v = new Vector1D(1.0 + 10.0 * Precision.EPSILON);
        Assert.assertTrue((u.hashCode() != v.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testInfinite() {
        Assert.assertTrue((boolean)new Vector1D(Double.NEGATIVE_INFINITY).isInfinite());
        Assert.assertTrue((boolean)new Vector1D(Double.POSITIVE_INFINITY).isInfinite());
        Assert.assertFalse((boolean)new Vector1D(1.0).isInfinite());
        Assert.assertFalse((boolean)new Vector1D(Double.NaN).isInfinite());
    }

    @Test
    public void testNaN() {
        Assert.assertTrue((boolean)new Vector1D(Double.NaN).isNaN());
        Assert.assertFalse((boolean)new Vector1D(1.0).isNaN());
        Assert.assertFalse((boolean)new Vector1D(Double.NEGATIVE_INFINITY).isNaN());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"{3}", (Object)new Vector1D(3.0).toString());
        DecimalFormat format = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        Assert.assertEquals((Object)"{3.000}", (Object)new Vector1D(3.0).toString((NumberFormat)format));
    }

    @Test
    public void testCoordinates() {
        Vector1D v = new Vector1D(1.0);
        Assert.assertTrue((FastMath.abs((double)(v.getX() - 1.0)) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test
    public void testNorm1() {
        Assert.assertEquals((double)0.0, (double)Vector1D.ZERO.getNorm1(), (double)0.0);
        Assert.assertEquals((double)6.0, (double)new Vector1D(6.0).getNorm1(), (double)0.0);
    }

    @Test
    public void testNorm() {
        Assert.assertEquals((double)0.0, (double)Vector1D.ZERO.getNorm(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)new Vector1D(-3.0).getNorm(), (double)1.0E-12);
    }

    @Test
    public void testNormSq() {
        Assert.assertEquals((double)0.0, (double)new Vector1D(0.0).getNormSq(), (double)0.0);
        Assert.assertEquals((double)9.0, (double)new Vector1D(-3.0).getNormSq(), (double)1.0E-12);
    }

    @Test
    public void testNormInf() {
        Assert.assertEquals((double)0.0, (double)Vector1D.ZERO.getNormInf(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)new Vector1D(-3.0).getNormInf(), (double)0.0);
    }

    @Test
    public void testDistance1() {
        Vector1D v1 = new Vector1D(1.0);
        Vector1D v2 = new Vector1D(-4.0);
        Assert.assertEquals((double)0.0, (double)new Vector1D(-1.0).distance1((Vector)new Vector1D(-1.0)), (double)0.0);
        Assert.assertEquals((double)5.0, (double)v1.distance1((Vector)v2), (double)1.0E-12);
        Assert.assertEquals((double)v1.subtract((Vector)v2).getNorm1(), (double)v1.distance1((Vector)v2), (double)1.0E-12);
    }

    @Test
    public void testDistance() {
        Vector1D v1 = new Vector1D(1.0);
        Vector1D v2 = new Vector1D(-4.0);
        Assert.assertEquals((double)0.0, (double)Vector1D.distance((Vector1D)new Vector1D(-1.0), (Vector1D)new Vector1D(-1.0)), (double)0.0);
        Assert.assertEquals((double)5.0, (double)Vector1D.distance((Vector1D)v1, (Vector1D)v2), (double)1.0E-12);
        Assert.assertEquals((double)v1.subtract((Vector)v2).getNorm(), (double)Vector1D.distance((Vector1D)v1, (Vector1D)v2), (double)1.0E-12);
    }

    @Test
    public void testDistanceSq() {
        Vector1D v1 = new Vector1D(1.0);
        Vector1D v2 = new Vector1D(-4.0);
        Assert.assertEquals((double)0.0, (double)Vector1D.distanceSq((Vector1D)new Vector1D(-1.0), (Vector1D)new Vector1D(-1.0)), (double)0.0);
        Assert.assertEquals((double)25.0, (double)Vector1D.distanceSq((Vector1D)v1, (Vector1D)v2), (double)1.0E-12);
        Assert.assertEquals((double)(Vector1D.distance((Vector1D)v1, (Vector1D)v2) * Vector1D.distance((Vector1D)v1, (Vector1D)v2)), (double)Vector1D.distanceSq((Vector1D)v1, (Vector1D)v2), (double)1.0E-12);
    }

    @Test
    public void testDistanceInf() {
        Vector1D v1 = new Vector1D(1.0);
        Vector1D v2 = new Vector1D(-4.0);
        Assert.assertEquals((double)0.0, (double)Vector1D.distanceInf((Vector1D)new Vector1D(-1.0), (Vector1D)new Vector1D(-1.0)), (double)0.0);
        Assert.assertEquals((double)5.0, (double)Vector1D.distanceInf((Vector1D)v1, (Vector1D)v2), (double)1.0E-12);
        Assert.assertEquals((double)v1.subtract((Vector)v2).getNormInf(), (double)Vector1D.distanceInf((Vector1D)v1, (Vector1D)v2), (double)1.0E-12);
    }

    @Test
    public void testSubtract() {
        Vector1D v1 = new Vector1D(1.0);
        Vector1D v2 = new Vector1D(-3.0);
        v1 = v1.subtract((Vector)v2);
        this.checkVector(v1, 4.0);
        this.checkVector(v2.subtract((Vector)v1), -7.0);
        this.checkVector(v2.subtract(3.0, (Vector)v1), -15.0);
    }

    @Test
    public void testAdd() {
        Vector1D v1 = new Vector1D(1.0);
        Vector1D v2 = new Vector1D(-3.0);
        v1 = v1.add((Vector)v2);
        this.checkVector(v1, -2.0);
        this.checkVector(v2.add((Vector)v1), -5.0);
        this.checkVector(v2.add(3.0, (Vector)v1), -9.0);
    }

    @Test
    public void testScalarProduct() {
        Vector1D v = new Vector1D(1.0);
        v = v.scalarMultiply(3.0);
        this.checkVector(v, 3.0);
        this.checkVector(v.scalarMultiply(0.5), 1.5);
    }

    @Test
    public void testNormalize() throws MathRuntimeException {
        Assert.assertEquals((double)1.0, (double)new Vector1D(5.0).normalize().getNorm(), (double)1.0E-12);
        try {
            Vector1D.ZERO.normalize();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathRuntimeException mathRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testNegate() {
        this.checkVector(new Vector1D(0.1).negate(), -0.1);
    }

    private void checkVector(Vector1D v, double x) {
        Assert.assertEquals((double)x, (double)v.getX(), (double)1.0E-12);
    }
}

