/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.UnitSphereRandomVectorGenerator;
import org.hipparchus.random.Well1024a;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public class FieldRotationDSTest {
    @Test
    public void testIdentity() {
        FieldRotation<DerivativeStructure> r = this.createRotation(1.0, 0.0, 0.0, 0.0, false);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), 0.0);
        r = this.createRotation(-1.0, 0.0, 0.0, 0.0, false);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), 0.0);
        r = this.createRotation(42.0, 0.0, 0.0, 0.0, true);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), 0.0);
    }

    @Test
    @Deprecated
    public void testAxisAngleDeprecated() throws MathIllegalArgumentException {
        FieldRotation r = new FieldRotation(this.createAxis(10.0, 10.0, 10.0), (RealFieldElement)this.createAngle(2.0943951023931953));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(1.0, 0.0, 0.0));
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(), this.createVector(s, s, s));
        this.checkAngle((DerivativeStructure)r.getAngle(), 2.0943951023931953);
        try {
            new FieldRotation(this.createAxis(0.0, 0.0, 0.0), (RealFieldElement)this.createAngle(2.0943951023931953));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new FieldRotation(this.createAxis(0.0, 0.0, 1.0), (RealFieldElement)this.createAngle(4.71238898038469));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(), this.createVector(0.0, 0.0, -1.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), 1.5707963267948966);
        r = new FieldRotation(this.createAxis(0.0, 1.0, 0.0), (RealFieldElement)this.createAngle(Math.PI));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(), this.createVector(0.0, 1.0, 0.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), Math.PI);
        this.checkVector((FieldVector3D<DerivativeStructure>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(), this.createVector(1.0, 0.0, 0.0));
    }

    @Test
    public void testAxisAngleVectorOperator() throws MathIllegalArgumentException {
        FieldRotation r = new FieldRotation(this.createAxis(10.0, 10.0, 10.0), (RealFieldElement)this.createAngle(2.0943951023931953), RotationConvention.VECTOR_OPERATOR);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(1.0, 0.0, 0.0));
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(s, s, s));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(-s, -s, -s));
        this.checkAngle((DerivativeStructure)r.getAngle(), 2.0943951023931953);
        try {
            new FieldRotation(this.createAxis(0.0, 0.0, 0.0), (RealFieldElement)this.createAngle(2.0943951023931953), RotationConvention.VECTOR_OPERATOR);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new FieldRotation(this.createAxis(0.0, 0.0, 1.0), (RealFieldElement)this.createAngle(4.71238898038469), RotationConvention.VECTOR_OPERATOR);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(0.0, 0.0, -1.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), 1.5707963267948966);
        r = new FieldRotation(this.createAxis(0.0, 1.0, 0.0), (RealFieldElement)this.createAngle(Math.PI), RotationConvention.VECTOR_OPERATOR);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(0.0, -1.0, 0.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), Math.PI);
        this.checkVector((FieldVector3D<DerivativeStructure>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(-1.0, 0.0, 0.0));
    }

    @Test
    public void testAxisAngleFrameTransform() throws MathIllegalArgumentException {
        FieldRotation r = new FieldRotation(this.createAxis(10.0, 10.0, 10.0), (RealFieldElement)this.createAngle(2.0943951023931953), RotationConvention.FRAME_TRANSFORM);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 1.0, 0.0));
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(s, s, s));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(-s, -s, -s));
        this.checkAngle((DerivativeStructure)r.getAngle(), 2.0943951023931953);
        try {
            new FieldRotation(this.createAxis(0.0, 0.0, 0.0), (RealFieldElement)this.createAngle(2.0943951023931953), RotationConvention.FRAME_TRANSFORM);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new FieldRotation(this.createAxis(0.0, 0.0, 1.0), (RealFieldElement)this.createAngle(4.71238898038469), RotationConvention.FRAME_TRANSFORM);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(0.0, 0.0, -1.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), 1.5707963267948966);
        r = new FieldRotation(this.createAxis(0.0, 1.0, 0.0), (RealFieldElement)this.createAngle(Math.PI), RotationConvention.FRAME_TRANSFORM);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(0.0, -1.0, 0.0));
        this.checkAngle((DerivativeStructure)r.getAngle(), Math.PI);
        this.checkVector((FieldVector3D<DerivativeStructure>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(-1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(1.0, 0.0, 0.0));
    }

    @Test
    public void testRevert() {
        double a = 0.001;
        double b = 0.36;
        double c = 0.48;
        double d = 0.8;
        FieldRotation<DerivativeStructure> r = this.createRotation(a, b, c, d, true);
        double a2 = a * a;
        double b2 = b * b;
        double c2 = c * c;
        double d2 = d * d;
        double den = (a2 + b2 + c2 + d2) * FastMath.sqrt((double)(a2 + b2 + c2 + d2));
        Assert.assertEquals((double)((b2 + c2 + d2) / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * b / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * c / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * d / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * a / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + c2 + d2) / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * c / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * d / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * a / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * b / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + b2 + d2) / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * d / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * a / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * b / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * c / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + b2 + c2) / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        FieldRotation reverted = r.revert();
        FieldRotation rrT = r.applyTo(reverted);
        this.checkRotationDS((FieldRotation<DerivativeStructure>)rrT, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        FieldRotation rTr = reverted.applyTo(r);
        this.checkRotationDS((FieldRotation<DerivativeStructure>)rTr, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)((DerivativeStructure)r.getAngle()).getReal(), (double)((DerivativeStructure)reverted.getAngle()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)((DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)r.getAxis(RotationConvention.VECTOR_OPERATOR), (FieldVector3D)reverted.getAxis(RotationConvention.VECTOR_OPERATOR))).getReal(), (double)1.0E-15);
    }

    @Test
    public void testRevertVectorOperator() {
        double a = 0.001;
        double b = 0.36;
        double c = 0.48;
        double d = 0.8;
        FieldRotation<DerivativeStructure> r = this.createRotation(a, b, c, d, true);
        double a2 = a * a;
        double b2 = b * b;
        double c2 = c * c;
        double d2 = d * d;
        double den = (a2 + b2 + c2 + d2) * FastMath.sqrt((double)(a2 + b2 + c2 + d2));
        Assert.assertEquals((double)((b2 + c2 + d2) / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * b / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * c / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * d / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * a / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + c2 + d2) / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * c / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * d / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * a / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * b / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + b2 + d2) / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * d / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * a / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * b / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * c / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + b2 + c2) / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        FieldRotation reverted = r.revert();
        FieldRotation rrT = r.compose(reverted, RotationConvention.VECTOR_OPERATOR);
        this.checkRotationDS((FieldRotation<DerivativeStructure>)rrT, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        FieldRotation rTr = reverted.compose(r, RotationConvention.VECTOR_OPERATOR);
        this.checkRotationDS((FieldRotation<DerivativeStructure>)rTr, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)((DerivativeStructure)r.getAngle()).getReal(), (double)((DerivativeStructure)reverted.getAngle()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)((DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)r.getAxis(RotationConvention.VECTOR_OPERATOR), (FieldVector3D)reverted.getAxis(RotationConvention.VECTOR_OPERATOR))).getReal(), (double)1.0E-15);
    }

    @Test
    public void testRevertFrameTransform() {
        double a = 0.001;
        double b = 0.36;
        double c = 0.48;
        double d = 0.8;
        FieldRotation<DerivativeStructure> r = this.createRotation(a, b, c, d, true);
        double a2 = a * a;
        double b2 = b * b;
        double c2 = c * c;
        double d2 = d * d;
        double den = (a2 + b2 + c2 + d2) * FastMath.sqrt((double)(a2 + b2 + c2 + d2));
        Assert.assertEquals((double)((b2 + c2 + d2) / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * b / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * c / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-a * d / den), (double)((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * a / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + c2 + d2) / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * c / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-b * d / den), (double)((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * a / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * b / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + b2 + d2) / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-c * d / den), (double)((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * a / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * b / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)(-d * c / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)((a2 + b2 + c2) / den), (double)((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        FieldRotation reverted = r.revert();
        FieldRotation rrT = r.compose(reverted, RotationConvention.FRAME_TRANSFORM);
        this.checkRotationDS((FieldRotation<DerivativeStructure>)rrT, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rrT.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        FieldRotation rTr = reverted.compose(r, RotationConvention.FRAME_TRANSFORM);
        this.checkRotationDS((FieldRotation<DerivativeStructure>)rTr, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ0()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ1()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ2()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)rTr.getQ3()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-15);
        Assert.assertEquals((double)((DerivativeStructure)r.getAngle()).getReal(), (double)((DerivativeStructure)reverted.getAngle()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)((DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)r.getAxis(RotationConvention.FRAME_TRANSFORM), (FieldVector3D)reverted.getAxis(RotationConvention.FRAME_TRANSFORM))).getReal(), (double)1.0E-15);
    }

    @Test
    public void testVectorOnePair() throws MathRuntimeException {
        FieldVector3D<DerivativeStructure> u = this.createVector(3.0, 2.0, 1.0);
        FieldVector3D<DerivativeStructure> v = this.createVector(-4.0, 2.0, 2.0);
        FieldRotation r = new FieldRotation(u, v);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(u.scalarMultiply(v.getNorm())), (FieldVector3D<DerivativeStructure>)v.scalarMultiply(u.getNorm()));
        this.checkAngle((DerivativeStructure)new FieldRotation(u, u.negate()).getAngle(), Math.PI);
        try {
            new FieldRotation(u, this.createVector(0.0, 0.0, 0.0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathRuntimeException mathRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testVectorTwoPairs() throws MathRuntimeException {
        FieldVector3D<DerivativeStructure> u1 = this.createVector(3.0, 0.0, 0.0);
        FieldVector3D<DerivativeStructure> u2 = this.createVector(0.0, 5.0, 0.0);
        FieldVector3D<DerivativeStructure> v1 = this.createVector(0.0, 0.0, 2.0);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(-2.0, 0.0, 2.0);
        FieldRotation r = new FieldRotation(u1, u2, v1, v2);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(-1.0, 0.0, 0.0));
        r = new FieldRotation(u1, u2, u1.negate(), u2.negate());
        FieldVector3D axis = r.getAxis(RotationConvention.VECTOR_OPERATOR);
        if (((DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)axis, this.createVector(0.0, 0.0, 1.0))).getReal() > 0.0) {
            this.checkVector((FieldVector3D<DerivativeStructure>)axis, this.createVector(0.0, 0.0, 1.0));
        } else {
            this.checkVector((FieldVector3D<DerivativeStructure>)axis, this.createVector(0.0, 0.0, -1.0));
        }
        this.checkAngle((DerivativeStructure)r.getAngle(), Math.PI);
        double sqrt = FastMath.sqrt((double)2.0) / 2.0;
        r = new FieldRotation(this.createVector(1.0, 0.0, 0.0), this.createVector(0.0, 1.0, 0.0), this.createVector(0.5, 0.5, sqrt), this.createVector(0.5, 0.5, -sqrt));
        this.checkRotationDS((FieldRotation<DerivativeStructure>)r, sqrt, 0.5, 0.5, 0.0);
        r = new FieldRotation(u1, u2, u1, FieldVector3D.crossProduct(u1, u2));
        this.checkRotationDS((FieldRotation<DerivativeStructure>)r, sqrt, -sqrt, 0.0, 0.0);
        this.checkRotationDS((FieldRotation<DerivativeStructure>)new FieldRotation(u1, u2, u1, u2), 1.0, 0.0, 0.0, 0.0);
        try {
            new FieldRotation(u1, u2, this.createVector(0.0, 0.0, 0.0), v2);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathRuntimeException mathRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testMatrix() throws MathIllegalArgumentException {
        try {
            this.createRotation(new double[][]{{0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}}, 1.0E-7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.createRotation(new double[][]{{0.445888, 0.797184, -0.40704}, {0.82176, -0.18432, 0.5392}, {-0.354816, 0.574912, 0.73728}}, 1.0E-7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.createRotation(new double[][]{{0.4, 0.8, -0.4}, {-0.4, 0.6, 0.7}, {0.8, -0.2, 0.5}}, 1.0E-15);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        this.checkRotationDS(this.createRotation(new double[][]{{0.445888, 0.797184, -0.40704}, {-0.354816, 0.574912, 0.73728}, {0.82176, -0.18432, 0.5392}}, 1.0E-10), 0.8, 0.288, 0.384, 0.36);
        this.checkRotationDS(this.createRotation(new double[][]{{0.5392, 0.73728, 0.40704}, {0.18432, -0.574912, 0.797184}, {0.82176, -0.354816, -0.445888}}, 1.0E-10), 0.36, 0.8, 0.288, 0.384);
        this.checkRotationDS(this.createRotation(new double[][]{{-0.445888, 0.797184, -0.40704}, {0.354816, 0.574912, 0.73728}, {0.82176, 0.18432, -0.5392}}, 1.0E-10), 0.384, 0.36, 0.8, 0.288);
        this.checkRotationDS(this.createRotation(new double[][]{{-0.5392, 0.73728, 0.40704}, {-0.18432, -0.574912, 0.797184}, {0.82176, 0.354816, 0.445888}}, 1.0E-10), 0.288, 0.384, 0.36, 0.8);
        double[][] m1 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}};
        FieldRotation<DerivativeStructure> r = this.createRotation(m1, 1.0E-7);
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 1.0, 0.0));
        double[][] m2 = new double[][]{{0.83203, -0.55012, -0.07139}, {0.48293, 0.78164, -0.39474}, {0.27296, 0.29396, 0.91602}};
        r = this.createRotation(m2, 1.0E-12);
        DerivativeStructure[][] m3 = (DerivativeStructure[][])r.getMatrix();
        double d00 = m2[0][0] - m3[0][0].getReal();
        double d01 = m2[0][1] - m3[0][1].getReal();
        double d02 = m2[0][2] - m3[0][2].getReal();
        double d10 = m2[1][0] - m3[1][0].getReal();
        double d11 = m2[1][1] - m3[1][1].getReal();
        double d12 = m2[1][2] - m3[1][2].getReal();
        double d20 = m2[2][0] - m3[2][0].getReal();
        double d21 = m2[2][1] - m3[2][1].getReal();
        double d22 = m2[2][2] - m3[2][2].getReal();
        Assert.assertTrue((FastMath.abs((double)d00) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d01) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d02) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d10) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d11) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d12) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d20) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d21) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d22) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d00) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d01) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d02) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d10) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d11) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d12) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d20) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d21) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d22) > 4.0E-7 ? 1 : 0) != 0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double m3tm3 = m3[i][0].getReal() * m3[j][0].getReal() + m3[i][1].getReal() * m3[j][1].getReal() + m3[i][2].getReal() * m3[j][2].getReal();
                if (i == j) {
                    Assert.assertTrue((FastMath.abs((double)(m3tm3 - 1.0)) < 1.0E-10 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((FastMath.abs((double)m3tm3) < 1.0E-10 ? 1 : 0) != 0);
            }
        }
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), (FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)m3[0][0], (RealFieldElement)m3[1][0], (RealFieldElement)m3[2][0]));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), (FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)m3[0][1], (RealFieldElement)m3[1][1], (RealFieldElement)m3[2][1]));
        this.checkVector((FieldVector3D<DerivativeStructure>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), (FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)m3[0][2], (RealFieldElement)m3[1][2], (RealFieldElement)m3[2][2]));
        double[][] m4 = new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, -1.0}};
        r = this.createRotation(m4, 1.0E-7);
        this.checkAngle((DerivativeStructure)r.getAngle(), Math.PI);
        try {
            double[][] m5 = new double[][]{{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}};
            r = this.createRotation(m5, 1.0E-7);
            Assert.fail((String)("got " + r + ", should have caught an exception"));
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Deprecated
    public void testAnglesDeprecated() throws MathIllegalStateException {
        RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
        for (int i = 0; i < CardanOrders.length; ++i) {
            for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 0.3) {
                for (double alpha2 = -1.55; alpha2 < 1.55; alpha2 += 0.3) {
                    for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 0.3) {
                        FieldRotation r = new FieldRotation(CardanOrders[i], (RealFieldElement)new DerivativeStructure(3, 1, 0, alpha1), (RealFieldElement)new DerivativeStructure(3, 1, 1, alpha2), (RealFieldElement)new DerivativeStructure(3, 1, 2, alpha3));
                        DerivativeStructure[] angles = (DerivativeStructure[])r.getAngles(CardanOrders[i]);
                        this.checkAngle(angles[0], alpha1);
                        this.checkAngle(angles[1], alpha2);
                        this.checkAngle(angles[2], alpha3);
                    }
                }
            }
        }
        RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
        for (int i = 0; i < EulerOrders.length; ++i) {
            for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 0.3) {
                for (double alpha2 = 0.05; alpha2 < 3.1; alpha2 += 0.3) {
                    for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 0.3) {
                        FieldRotation r = new FieldRotation(EulerOrders[i], (RealFieldElement)new DerivativeStructure(3, 1, 0, alpha1), (RealFieldElement)new DerivativeStructure(3, 1, 1, alpha2), (RealFieldElement)new DerivativeStructure(3, 1, 2, alpha3));
                        DerivativeStructure[] angles = (DerivativeStructure[])r.getAngles(EulerOrders[i]);
                        this.checkAngle(angles[0], alpha1);
                        this.checkAngle(angles[1], alpha2);
                        this.checkAngle(angles[2], alpha3);
                    }
                }
            }
        }
    }

    @Test
    public void testAngles() throws MathIllegalStateException {
        for (RotationConvention convention : RotationConvention.values()) {
            RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
            for (int i = 0; i < CardanOrders.length; ++i) {
                for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 0.3) {
                    for (double alpha2 = -1.55; alpha2 < 1.55; alpha2 += 0.3) {
                        for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 0.3) {
                            FieldRotation r = new FieldRotation(CardanOrders[i], convention, (RealFieldElement)new DerivativeStructure(3, 1, 0, alpha1), (RealFieldElement)new DerivativeStructure(3, 1, 1, alpha2), (RealFieldElement)new DerivativeStructure(3, 1, 2, alpha3));
                            DerivativeStructure[] angles = (DerivativeStructure[])r.getAngles(CardanOrders[i], convention);
                            this.checkAngle(angles[0], alpha1);
                            this.checkAngle(angles[1], alpha2);
                            this.checkAngle(angles[2], alpha3);
                        }
                    }
                }
            }
            RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
            for (int i = 0; i < EulerOrders.length; ++i) {
                for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 0.3) {
                    for (double alpha2 = 0.05; alpha2 < 3.1; alpha2 += 0.3) {
                        for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 0.3) {
                            FieldRotation r = new FieldRotation(EulerOrders[i], convention, (RealFieldElement)new DerivativeStructure(3, 1, 0, alpha1), (RealFieldElement)new DerivativeStructure(3, 1, 1, alpha2), (RealFieldElement)new DerivativeStructure(3, 1, 2, alpha3));
                            DerivativeStructure[] angles = (DerivativeStructure[])r.getAngles(EulerOrders[i], convention);
                            this.checkAngle(angles[0], alpha1);
                            this.checkAngle(angles[1], alpha2);
                            this.checkAngle(angles[2], alpha3);
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testSingularities() {
        for (RotationConvention convention : RotationConvention.values()) {
            RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
            double[] singularCardanAngle = new double[]{1.5707963267948966, -1.5707963267948966};
            for (int i = 0; i < CardanOrders.length; ++i) {
                for (int j = 0; j < singularCardanAngle.length; ++j) {
                    FieldRotation r = new FieldRotation(CardanOrders[i], convention, (RealFieldElement)new DerivativeStructure(3, 1, 0, 0.1), (RealFieldElement)new DerivativeStructure(3, 1, 1, singularCardanAngle[j]), (RealFieldElement)new DerivativeStructure(3, 1, 2, 0.3));
                    try {
                        r.getAngles(CardanOrders[i], convention);
                        Assert.fail((String)"an exception should have been caught");
                        continue;
                    }
                    catch (MathIllegalStateException cese) {
                        Assert.assertEquals((Object)LocalizedGeometryFormats.CARDAN_ANGLES_SINGULARITY, (Object)cese.getSpecifier());
                    }
                }
            }
            RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
            double[] singularEulerAngle = new double[]{0.0, Math.PI};
            for (int i = 0; i < EulerOrders.length; ++i) {
                for (int j = 0; j < singularEulerAngle.length; ++j) {
                    FieldRotation r = new FieldRotation(EulerOrders[i], convention, (RealFieldElement)new DerivativeStructure(3, 1, 0, 0.1), (RealFieldElement)new DerivativeStructure(3, 1, 1, singularEulerAngle[j]), (RealFieldElement)new DerivativeStructure(3, 1, 2, 0.3));
                    try {
                        r.getAngles(EulerOrders[i], convention);
                        Assert.fail((String)"an exception should have been caught");
                        continue;
                    }
                    catch (MathIllegalStateException cese) {
                        Assert.assertEquals((Object)LocalizedGeometryFormats.EULER_ANGLES_SINGULARITY, (Object)cese.getSpecifier());
                    }
                }
            }
        }
    }

    @Test
    public void testQuaternion() throws MathIllegalArgumentException {
        FieldRotation<DerivativeStructure> r1 = new FieldRotation<DerivativeStructure>(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        double n = 23.5;
        FieldRotation r2 = new FieldRotation((RealFieldElement)((DerivativeStructure)r1.getQ0()).multiply(n), (RealFieldElement)((DerivativeStructure)r1.getQ1()).multiply(n), (RealFieldElement)((DerivativeStructure)r1.getQ2()).multiply(n), (RealFieldElement)((DerivativeStructure)r1.getQ3()).multiply(n), true);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<DerivativeStructure> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyTo(u), (FieldVector3D<DerivativeStructure>)r1.applyTo(u));
                }
            }
        }
        r1 = this.createRotation(0.288, 0.384, 0.36, 0.8, false);
        this.checkRotationDS(r1, -((DerivativeStructure)r1.getQ0()).getReal(), -((DerivativeStructure)r1.getQ1()).getReal(), -((DerivativeStructure)r1.getQ2()).getReal(), -((DerivativeStructure)r1.getQ3()).getReal());
        Assert.assertEquals((double)0.288, (double)r1.toRotation().getQ0(), (double)1.0E-15);
        Assert.assertEquals((double)0.384, (double)r1.toRotation().getQ1(), (double)1.0E-15);
        Assert.assertEquals((double)0.36, (double)r1.toRotation().getQ2(), (double)1.0E-15);
        Assert.assertEquals((double)0.8, (double)r1.toRotation().getQ3(), (double)1.0E-15);
    }

    @Test
    public void testApplyToRotation() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3 = r2.applyTo(r1);
        FieldRotation r3Double = r2.applyTo(new Rotation(((DerivativeStructure)r1.getQ0()).getReal(), ((DerivativeStructure)r1.getQ1()).getReal(), ((DerivativeStructure)r1.getQ2()).getReal(), ((DerivativeStructure)r1.getQ3()).getReal(), false));
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<DerivativeStructure> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyTo(r1.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyTo(r1.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeVectorOperator() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3 = r2.compose(r1, RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3Double = r2.compose(new Rotation(((DerivativeStructure)r1.getQ0()).getReal(), ((DerivativeStructure)r1.getQ1()).getReal(), ((DerivativeStructure)r1.getQ2()).getReal(), ((DerivativeStructure)r1.getQ3()).getReal(), false), RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<DerivativeStructure> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyTo(r1.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyTo(r1.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeFrameTransform() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r3 = r2.compose(r1, RotationConvention.FRAME_TRANSFORM);
        FieldRotation r3Double = r2.compose(new Rotation(((DerivativeStructure)r1.getQ0()).getReal(), ((DerivativeStructure)r1.getQ1()).getReal(), ((DerivativeStructure)r1.getQ2()).getReal(), ((DerivativeStructure)r1.getQ3()).getReal(), false), RotationConvention.FRAME_TRANSFORM);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<DerivativeStructure> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<DerivativeStructure>)r1.applyTo(r2.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<DerivativeStructure>)r1.applyTo(r2.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testApplyInverseToRotation() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3 = r2.applyInverseTo(r1);
        FieldRotation r3Double = r2.applyInverseTo(new Rotation(((DerivativeStructure)r1.getQ0()).getReal(), ((DerivativeStructure)r1.getQ1()).getReal(), ((DerivativeStructure)r1.getQ2()).getReal(), ((DerivativeStructure)r1.getQ3()).getReal(), false));
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<DerivativeStructure> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyInverseTo(r1.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyInverseTo(r1.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeInverseVectorOperator() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3 = r2.composeInverse(r1, RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3Double = r2.composeInverse(new Rotation(((DerivativeStructure)r1.getQ0()).getReal(), ((DerivativeStructure)r1.getQ1()).getReal(), ((DerivativeStructure)r1.getQ2()).getReal(), ((DerivativeStructure)r1.getQ3()).getReal(), false), RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<DerivativeStructure> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyInverseTo(r1.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<DerivativeStructure>)r2.applyInverseTo(r1.applyTo(u)), (FieldVector3D<DerivativeStructure>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeInverseframeTransform() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r3 = r2.composeInverse(r1, RotationConvention.FRAME_TRANSFORM);
        FieldRotation r3Double = r2.composeInverse(new Rotation(((DerivativeStructure)r1.getQ0()).getReal(), ((DerivativeStructure)r1.getQ1()).getReal(), ((DerivativeStructure)r1.getQ2()).getReal(), ((DerivativeStructure)r1.getQ3()).getReal(), false), RotationConvention.FRAME_TRANSFORM);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<DerivativeStructure> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<DerivativeStructure>)r1.applyTo(r2.applyInverseTo(u)), (FieldVector3D<DerivativeStructure>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<DerivativeStructure>)r1.applyTo(r2.applyInverseTo(u)), (FieldVector3D<DerivativeStructure>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testDoubleVectors() throws MathIllegalArgumentException {
        Well1024a random = new Well1024a(1732550842977857383L);
        UnitSphereRandomVectorGenerator g = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)random);
        for (int i = 0; i < 10; ++i) {
            double[] unit = g.nextVector();
            FieldRotation r = new FieldRotation(this.createVector(unit[0], unit[1], unit[2]), (RealFieldElement)this.createAngle(random.nextDouble()), RotationConvention.VECTOR_OPERATOR);
            for (double x = -0.9; x < 0.9; x += 0.2) {
                for (double y = -0.9; y < 0.9; y += 0.2) {
                    for (double z = -0.9; z < 0.9; z += 0.2) {
                        FieldVector3D<DerivativeStructure> uds = this.createVector(x, y, z);
                        FieldVector3D ruds = r.applyTo(uds);
                        FieldVector3D rIuds = r.applyInverseTo(uds);
                        Vector3D u = new Vector3D(x, y, z);
                        FieldVector3D ru = r.applyTo(u);
                        FieldVector3D rIu = r.applyInverseTo(u);
                        DerivativeStructure[] ruArray = new DerivativeStructure[3];
                        r.applyTo(new double[]{x, y, z}, (RealFieldElement[])ruArray);
                        DerivativeStructure[] rIuArray = new DerivativeStructure[3];
                        r.applyInverseTo(new double[]{x, y, z}, (RealFieldElement[])rIuArray);
                        this.checkVector((FieldVector3D<DerivativeStructure>)ruds, (FieldVector3D<DerivativeStructure>)ru);
                        this.checkVector((FieldVector3D<DerivativeStructure>)ruds, (FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement[])ruArray));
                        this.checkVector((FieldVector3D<DerivativeStructure>)rIuds, (FieldVector3D<DerivativeStructure>)rIu);
                        this.checkVector((FieldVector3D<DerivativeStructure>)rIuds, (FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement[])rIuArray));
                    }
                }
            }
        }
    }

    @Test
    public void testDoubleRotations() throws MathIllegalArgumentException {
        Well1024a random = new Well1024a(1732550842977857383L);
        UnitSphereRandomVectorGenerator g = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)random);
        for (int i = 0; i < 10; ++i) {
            double[] unit1 = g.nextVector();
            Rotation r1 = new Rotation(new Vector3D(unit1[0], unit1[1], unit1[2]), random.nextDouble(), RotationConvention.VECTOR_OPERATOR);
            FieldRotation r1Prime = new FieldRotation((RealFieldElement)new DerivativeStructure(4, 1, 0, r1.getQ0()), (RealFieldElement)new DerivativeStructure(4, 1, 1, r1.getQ1()), (RealFieldElement)new DerivativeStructure(4, 1, 2, r1.getQ2()), (RealFieldElement)new DerivativeStructure(4, 1, 3, r1.getQ3()), false);
            double[] unit2 = g.nextVector();
            FieldRotation r2 = new FieldRotation(this.createVector(unit2[0], unit2[1], unit2[2]), (RealFieldElement)this.createAngle(random.nextDouble()), RotationConvention.VECTOR_OPERATOR);
            FieldRotation rA = FieldRotation.applyTo((Rotation)r1, (FieldRotation)r2);
            FieldRotation rB = r1Prime.compose(r2, RotationConvention.VECTOR_OPERATOR);
            FieldRotation rC = FieldRotation.applyInverseTo((Rotation)r1, (FieldRotation)r2);
            FieldRotation rD = r1Prime.composeInverse(r2, RotationConvention.VECTOR_OPERATOR);
            for (double x = -0.9; x < 0.9; x += 0.2) {
                for (double y = -0.9; y < 0.9; y += 0.2) {
                    for (double z = -0.9; z < 0.9; z += 0.2) {
                        FieldVector3D<DerivativeStructure> uds = this.createVector(x, y, z);
                        this.checkVector((FieldVector3D<DerivativeStructure>)r1Prime.applyTo(uds), (FieldVector3D<DerivativeStructure>)FieldRotation.applyTo((Rotation)r1, uds));
                        this.checkVector((FieldVector3D<DerivativeStructure>)r1Prime.applyInverseTo(uds), (FieldVector3D<DerivativeStructure>)FieldRotation.applyInverseTo((Rotation)r1, uds));
                        this.checkVector((FieldVector3D<DerivativeStructure>)rA.applyTo(uds), (FieldVector3D<DerivativeStructure>)rB.applyTo(uds));
                        this.checkVector((FieldVector3D<DerivativeStructure>)rA.applyInverseTo(uds), (FieldVector3D<DerivativeStructure>)rB.applyInverseTo(uds));
                        this.checkVector((FieldVector3D<DerivativeStructure>)rC.applyTo(uds), (FieldVector3D<DerivativeStructure>)rD.applyTo(uds));
                        this.checkVector((FieldVector3D<DerivativeStructure>)rC.applyInverseTo(uds), (FieldVector3D<DerivativeStructure>)rD.applyInverseTo(uds));
                    }
                }
            }
        }
    }

    @Test
    public void testDerivatives() {
        double eps = 5.0E-16;
        double kx = 2.0;
        double ky = -3.0;
        double kz = 5.0;
        double n2 = kx * kx + ky * ky + kz * kz;
        double n = FastMath.sqrt((double)n2);
        double theta = 1.7;
        double cosTheta = FastMath.cos((double)theta);
        double sinTheta = FastMath.sin((double)theta);
        FieldRotation r = new FieldRotation(this.createAxis(kx, ky, kz), (RealFieldElement)this.createAngle(theta), RotationConvention.VECTOR_OPERATOR);
        Vector3D a = new Vector3D(kx / n, ky / n, kz / n);
        RealMatrix dadk = MatrixUtils.createRealMatrix((double[][])new double[][]{{(ky * ky + kz * kz) / (n * n2), -kx * ky / (n * n2), -kx * kz / (n * n2)}, {-kx * ky / (n * n2), (kx * kx + kz * kz) / (n * n2), -ky * kz / (n * n2)}, {-kx * kz / (n * n2), -ky * kz / (n * n2), (kx * kx + ky * ky) / (n * n2)}});
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    Vector3D u = new Vector3D(x, y, z);
                    FieldVector3D v = r.applyTo(this.createVector(x, y, z));
                    double dot = Vector3D.dotProduct((Vector3D)u, (Vector3D)a);
                    Vector3D cross = Vector3D.crossProduct((Vector3D)a, (Vector3D)u);
                    double c1 = 1.0 - cosTheta;
                    double c2 = c1 * dot;
                    Vector3D rt = new Vector3D(cosTheta, u, c2, a, sinTheta, cross);
                    Assert.assertEquals((double)rt.getX(), (double)((DerivativeStructure)v.getX()).getReal(), (double)eps);
                    Assert.assertEquals((double)rt.getY(), (double)((DerivativeStructure)v.getY()).getReal(), (double)eps);
                    Assert.assertEquals((double)rt.getZ(), (double)((DerivativeStructure)v.getZ()).getReal(), (double)eps);
                    RealMatrix dvda = MatrixUtils.createRealMatrix((double[][])new double[][]{{c1 * x * a.getX() + c2, c1 * y * a.getX() + sinTheta * z, c1 * z * a.getX() - sinTheta * y}, {c1 * x * a.getY() - sinTheta * z, c1 * y * a.getY() + c2, c1 * z * a.getY() + sinTheta * x}, {c1 * x * a.getZ() + sinTheta * y, c1 * y * a.getZ() - sinTheta * x, c1 * z * a.getZ() + c2}});
                    RealMatrix dvdk = dvda.multiply(dadk);
                    Assert.assertEquals((double)dvdk.getEntry(0, 0), (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)eps);
                    Assert.assertEquals((double)dvdk.getEntry(0, 1), (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)eps);
                    Assert.assertEquals((double)dvdk.getEntry(0, 2), (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)eps);
                    Assert.assertEquals((double)dvdk.getEntry(1, 0), (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)eps);
                    Assert.assertEquals((double)dvdk.getEntry(1, 1), (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)eps);
                    Assert.assertEquals((double)dvdk.getEntry(1, 2), (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)eps);
                    Assert.assertEquals((double)dvdk.getEntry(2, 0), (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)eps);
                    Assert.assertEquals((double)dvdk.getEntry(2, 1), (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)eps);
                    Assert.assertEquals((double)dvdk.getEntry(2, 2), (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)eps);
                    Vector3D dvdTheta = new Vector3D(-sinTheta, u, sinTheta * dot, a, cosTheta, cross);
                    Assert.assertEquals((double)dvdTheta.getX(), (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)eps);
                    Assert.assertEquals((double)dvdTheta.getY(), (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)eps);
                    Assert.assertEquals((double)dvdTheta.getZ(), (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)eps);
                }
            }
        }
    }

    @Test
    public void testArray() throws MathIllegalArgumentException {
        FieldRotation r = new FieldRotation(this.createAxis(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<DerivativeStructure> u = this.createVector(x, y, z);
                    FieldVector3D v = r.applyTo(u);
                    DerivativeStructure[] out = new DerivativeStructure[3];
                    r.applyTo((RealFieldElement[])new DerivativeStructure[]{(DerivativeStructure)u.getX(), (DerivativeStructure)u.getY(), (DerivativeStructure)u.getZ()}, (RealFieldElement[])out);
                    Assert.assertEquals((double)((DerivativeStructure)v.getX()).getReal(), (double)out[0].getReal(), (double)1.0E-10);
                    Assert.assertEquals((double)((DerivativeStructure)v.getY()).getReal(), (double)out[1].getReal(), (double)1.0E-10);
                    Assert.assertEquals((double)((DerivativeStructure)v.getZ()).getReal(), (double)out[2].getReal(), (double)1.0E-10);
                    r.applyInverseTo((RealFieldElement[])out, (RealFieldElement[])out);
                    Assert.assertEquals((double)((DerivativeStructure)u.getX()).getReal(), (double)out[0].getReal(), (double)1.0E-10);
                    Assert.assertEquals((double)((DerivativeStructure)u.getY()).getReal(), (double)out[1].getReal(), (double)1.0E-10);
                    Assert.assertEquals((double)((DerivativeStructure)u.getZ()).getReal(), (double)out[2].getReal(), (double)1.0E-10);
                }
            }
        }
    }

    @Test
    public void testApplyInverseTo() throws MathIllegalArgumentException {
        FieldVector3D<DerivativeStructure> u;
        double phi;
        double lambda;
        DerivativeStructure[] in = new DerivativeStructure[3];
        DerivativeStructure[] out = new DerivativeStructure[3];
        DerivativeStructure[] rebuilt = new DerivativeStructure[3];
        FieldRotation r = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = this.createVector(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                r.applyInverseTo(r.applyTo(u));
                this.checkVector(u, (FieldVector3D<DerivativeStructure>)r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, (FieldVector3D<DerivativeStructure>)r.applyTo(r.applyInverseTo(u)));
                in[0] = (DerivativeStructure)u.getX();
                in[1] = (DerivativeStructure)u.getY();
                in[2] = (DerivativeStructure)u.getZ();
                r.applyTo((RealFieldElement[])in, (RealFieldElement[])out);
                r.applyInverseTo((RealFieldElement[])out, (RealFieldElement[])rebuilt);
                Assert.assertEquals((double)in[0].getReal(), (double)rebuilt[0].getReal(), (double)1.0E-12);
                Assert.assertEquals((double)in[1].getReal(), (double)rebuilt[1].getReal(), (double)1.0E-12);
                Assert.assertEquals((double)in[2].getReal(), (double)rebuilt[2].getReal(), (double)1.0E-12);
            }
        }
        r = this.createRotation(1.0, 0.0, 0.0, 0.0, false);
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = this.createVector(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                this.checkVector(u, (FieldVector3D<DerivativeStructure>)r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, (FieldVector3D<DerivativeStructure>)r.applyTo(r.applyInverseTo(u)));
            }
        }
        r = new FieldRotation(this.createVector(0.0, 0.0, 1.0), (RealFieldElement)this.createAngle(Math.PI), RotationConvention.VECTOR_OPERATOR);
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = this.createVector(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                this.checkVector(u, (FieldVector3D<DerivativeStructure>)r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, (FieldVector3D<DerivativeStructure>)r.applyTo(r.applyInverseTo(u)));
            }
        }
    }

    @Test
    public void testIssue639() throws MathRuntimeException {
        FieldVector3D<DerivativeStructure> u1 = this.createVector(-4921140.837095533, -2.1512094250440013E7, -890093.279426377);
        FieldVector3D<DerivativeStructure> u2 = this.createVector(-2.7238580938724895E9, -2.169664921341876E9, 6.749688708885301E10);
        FieldRotation rot = new FieldRotation(u1, u2, this.createVector(1.0, 0.0, 0.0), this.createVector(0.0, 0.0, 1.0));
        Assert.assertEquals((double)0.6228370359608201, (double)((DerivativeStructure)rot.getQ0()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)0.02577076214564988, (double)((DerivativeStructure)rot.getQ1()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-2.503012255839931E-10, (double)((DerivativeStructure)rot.getQ2()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-0.7819270390861109, (double)((DerivativeStructure)rot.getQ3()).getReal(), (double)1.0E-15);
    }

    @Test
    public void testIssue801() throws MathRuntimeException {
        FieldVector3D<DerivativeStructure> u1 = this.createVector(0.9999988431610581, -0.0015210774290851095, 0.0);
        FieldVector3D<DerivativeStructure> u2 = this.createVector(0.0, 0.0, 1.0);
        FieldVector3D<DerivativeStructure> v1 = this.createVector(0.9999999999999999, 0.0, 0.0);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(0.0, 0.0, -1.0);
        FieldRotation quat = new FieldRotation(u1, u2, v1, v2);
        double q2 = ((DerivativeStructure)quat.getQ0()).getReal() * ((DerivativeStructure)quat.getQ0()).getReal() + ((DerivativeStructure)quat.getQ1()).getReal() * ((DerivativeStructure)quat.getQ1()).getReal() + ((DerivativeStructure)quat.getQ2()).getReal() * ((DerivativeStructure)quat.getQ2()).getReal() + ((DerivativeStructure)quat.getQ3()).getReal() * ((DerivativeStructure)quat.getQ3()).getReal();
        Assert.assertEquals((double)1.0, (double)q2, (double)1.0E-14);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.angle(v1, (FieldVector3D)quat.applyTo(u1))).getReal(), (double)1.0E-14);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.angle(v2, (FieldVector3D)quat.applyTo(u2))).getReal(), (double)1.0E-14);
    }

    private void checkAngle(DerivativeStructure a1, double a2) {
        Assert.assertEquals((double)a1.getReal(), (double)MathUtils.normalizeAngle((double)a2, (double)a1.getReal()), (double)1.0E-10);
    }

    private void checkRotationDS(FieldRotation<DerivativeStructure> r, double q0, double q1, double q2, double q3) {
        FieldRotation<DerivativeStructure> rPrime = this.createRotation(q0, q1, q2, q3, false);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldRotation.distance(r, rPrime)).getReal(), (double)1.0E-12);
    }

    private FieldRotation<DerivativeStructure> createRotation(double q0, double q1, double q2, double q3, boolean needsNormalization) {
        return new FieldRotation((RealFieldElement)new DerivativeStructure(4, 1, 0, q0), (RealFieldElement)new DerivativeStructure(4, 1, 1, q1), (RealFieldElement)new DerivativeStructure(4, 1, 2, q2), (RealFieldElement)new DerivativeStructure(4, 1, 3, q3), needsNormalization);
    }

    private FieldRotation<DerivativeStructure> createRotation(double[][] m, double threshold) {
        DerivativeStructure[][] mds = new DerivativeStructure[m.length][m[0].length];
        int index = 0;
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                mds[i][j] = new DerivativeStructure(4, 1, index, m[i][j]);
                index = (index + 1) % 4;
            }
        }
        return new FieldRotation((RealFieldElement[][])mds, threshold);
    }

    private FieldVector3D<DerivativeStructure> createVector(double x, double y, double z) {
        return new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, x), (RealFieldElement)new DerivativeStructure(4, 1, y), (RealFieldElement)new DerivativeStructure(4, 1, z));
    }

    private FieldVector3D<DerivativeStructure> createAxis(double x, double y, double z) {
        return new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 0, x), (RealFieldElement)new DerivativeStructure(4, 1, 1, y), (RealFieldElement)new DerivativeStructure(4, 1, 2, z));
    }

    private DerivativeStructure createAngle(double alpha) {
        return new DerivativeStructure(4, 1, 3, alpha);
    }

    private void checkVector(FieldVector3D<DerivativeStructure> u, FieldVector3D<DerivativeStructure> v) {
        Assert.assertEquals((double)((DerivativeStructure)u.getX()).getReal(), (double)((DerivativeStructure)v.getX()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)((DerivativeStructure)u.getY()).getReal(), (double)((DerivativeStructure)v.getY()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)((DerivativeStructure)u.getZ()).getReal(), (double)((DerivativeStructure)v.getZ()).getReal(), (double)1.0E-12);
    }
}

