/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import org.hipparchus.RealFieldElement;
import org.hipparchus.dfp.Dfp;
import org.hipparchus.dfp.DfpField;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.UnitSphereRandomVectorGenerator;
import org.hipparchus.random.Well1024a;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public class FieldRotationDfpTest {
    @Test
    public void testIdentity() {
        FieldRotation<Dfp> r = this.createRotation(1.0, 0.0, 0.0, 0.0, false);
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((Dfp)r.getAngle(), 0.0);
        r = this.createRotation(-1.0, 0.0, 0.0, 0.0, false);
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((Dfp)r.getAngle(), 0.0);
        r = this.createRotation(42.0, 0.0, 0.0, 0.0, true);
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((Dfp)r.getAngle(), 0.0);
    }

    @Test
    @Deprecated
    public void testAxisAngleDeprecated() throws MathIllegalArgumentException {
        FieldRotation r = new FieldRotation(this.createAxis(10.0, 10.0, 10.0), (RealFieldElement)this.createAngle(2.0943951023931953));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(1.0, 0.0, 0.0));
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(), this.createVector(s, s, s));
        this.checkAngle((Dfp)r.getAngle(), 2.0943951023931953);
        try {
            new FieldRotation(this.createAxis(0.0, 0.0, 0.0), (RealFieldElement)this.createAngle(2.0943951023931953));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new FieldRotation(this.createAxis(0.0, 0.0, 1.0), (RealFieldElement)this.createAngle(4.71238898038469));
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(), this.createVector(0.0, 0.0, -1.0));
        this.checkAngle((Dfp)r.getAngle(), 1.5707963267948966);
        r = new FieldRotation(this.createAxis(0.0, 1.0, 0.0), (RealFieldElement)this.createAngle(Math.PI));
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(), this.createVector(0.0, 1.0, 0.0));
        this.checkAngle((Dfp)r.getAngle(), Math.PI);
        this.checkVector((FieldVector3D<Dfp>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(), this.createVector(1.0, 0.0, 0.0));
    }

    @Test
    public void testAxisAngleVectorOperator() throws MathIllegalArgumentException {
        FieldRotation r = new FieldRotation(this.createAxis(10.0, 10.0, 10.0), (RealFieldElement)this.createAngle(2.0943951023931953), RotationConvention.VECTOR_OPERATOR);
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(1.0, 0.0, 0.0));
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(s, s, s));
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(-s, -s, -s));
        this.checkAngle((Dfp)r.getAngle(), 2.0943951023931953);
        try {
            new FieldRotation(this.createAxis(0.0, 0.0, 0.0), (RealFieldElement)this.createAngle(2.0943951023931953), RotationConvention.VECTOR_OPERATOR);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new FieldRotation(this.createAxis(0.0, 0.0, 1.0), (RealFieldElement)this.createAngle(4.71238898038469), RotationConvention.VECTOR_OPERATOR);
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(0.0, 0.0, -1.0));
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((Dfp)r.getAngle(), 1.5707963267948966);
        r = new FieldRotation(this.createAxis(0.0, 1.0, 0.0), (RealFieldElement)this.createAngle(Math.PI), RotationConvention.VECTOR_OPERATOR);
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(0.0, -1.0, 0.0));
        this.checkAngle((Dfp)r.getAngle(), Math.PI);
        this.checkVector((FieldVector3D<Dfp>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(-1.0, 0.0, 0.0));
    }

    @Test
    public void testAxisAngleFrameTransform() throws MathIllegalArgumentException {
        FieldRotation r = new FieldRotation(this.createAxis(10.0, 10.0, 10.0), (RealFieldElement)this.createAngle(2.0943951023931953), RotationConvention.FRAME_TRANSFORM);
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 1.0, 0.0));
        double s = 1.0 / FastMath.sqrt((double)3.0);
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(s, s, s));
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(-s, -s, -s));
        this.checkAngle((Dfp)r.getAngle(), 2.0943951023931953);
        try {
            new FieldRotation(this.createAxis(0.0, 0.0, 0.0), (RealFieldElement)this.createAngle(2.0943951023931953), RotationConvention.FRAME_TRANSFORM);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        r = new FieldRotation(this.createAxis(0.0, 0.0, 1.0), (RealFieldElement)this.createAngle(4.71238898038469), RotationConvention.FRAME_TRANSFORM);
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(0.0, 0.0, -1.0));
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(0.0, 0.0, 1.0));
        this.checkAngle((Dfp)r.getAngle(), 1.5707963267948966);
        r = new FieldRotation(this.createAxis(0.0, 1.0, 0.0), (RealFieldElement)this.createAngle(Math.PI), RotationConvention.FRAME_TRANSFORM);
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(0.0, 1.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(0.0, -1.0, 0.0));
        this.checkAngle((Dfp)r.getAngle(), Math.PI);
        this.checkVector((FieldVector3D<Dfp>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(RotationConvention.FRAME_TRANSFORM), this.createVector(-1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)this.createRotation(1.0, 0.0, 0.0, 0.0, false).getAxis(RotationConvention.VECTOR_OPERATOR), this.createVector(1.0, 0.0, 0.0));
    }

    @Test
    public void testRevert() {
        double a = 0.001;
        double b = 0.36;
        double c = 0.48;
        double d = 0.8;
        FieldRotation<Dfp> r = this.createRotation(a, b, c, d, true);
        FieldRotation reverted = r.revert();
        FieldRotation rrT = r.applyTo(reverted);
        this.checkRotationDS((FieldRotation<Dfp>)rrT, 1.0, 0.0, 0.0, 0.0);
        FieldRotation rTr = reverted.applyTo(r);
        this.checkRotationDS((FieldRotation<Dfp>)rTr, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)((Dfp)r.getAngle()).getReal(), (double)((Dfp)reverted.getAngle()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)((Dfp)FieldVector3D.dotProduct((FieldVector3D)r.getAxis(RotationConvention.VECTOR_OPERATOR), (FieldVector3D)reverted.getAxis(RotationConvention.VECTOR_OPERATOR))).getReal(), (double)1.0E-15);
    }

    @Test
    public void testRevertVectorOperator() {
        double a = 0.001;
        double b = 0.36;
        double c = 0.48;
        double d = 0.8;
        FieldRotation<Dfp> r = this.createRotation(a, b, c, d, true);
        FieldRotation reverted = r.revert();
        FieldRotation rrT = r.compose(reverted, RotationConvention.VECTOR_OPERATOR);
        this.checkRotationDS((FieldRotation<Dfp>)rrT, 1.0, 0.0, 0.0, 0.0);
        FieldRotation rTr = reverted.compose(r, RotationConvention.VECTOR_OPERATOR);
        this.checkRotationDS((FieldRotation<Dfp>)rTr, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)((Dfp)r.getAngle()).getReal(), (double)((Dfp)reverted.getAngle()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)((Dfp)FieldVector3D.dotProduct((FieldVector3D)r.getAxis(RotationConvention.VECTOR_OPERATOR), (FieldVector3D)reverted.getAxis(RotationConvention.VECTOR_OPERATOR))).getReal(), (double)1.0E-15);
    }

    @Test
    public void testRevertFrameTransform() {
        double a = 0.001;
        double b = 0.36;
        double c = 0.48;
        double d = 0.8;
        FieldRotation<Dfp> r = this.createRotation(a, b, c, d, true);
        FieldRotation reverted = r.revert();
        FieldRotation rrT = r.compose(reverted, RotationConvention.FRAME_TRANSFORM);
        this.checkRotationDS((FieldRotation<Dfp>)rrT, 1.0, 0.0, 0.0, 0.0);
        FieldRotation rTr = reverted.compose(r, RotationConvention.FRAME_TRANSFORM);
        this.checkRotationDS((FieldRotation<Dfp>)rTr, 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)((Dfp)r.getAngle()).getReal(), (double)((Dfp)reverted.getAngle()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)((Dfp)FieldVector3D.dotProduct((FieldVector3D)r.getAxis(RotationConvention.FRAME_TRANSFORM), (FieldVector3D)reverted.getAxis(RotationConvention.FRAME_TRANSFORM))).getReal(), (double)1.0E-15);
    }

    @Test
    public void testVectorOnePair() throws MathRuntimeException {
        FieldVector3D<Dfp> u = this.createVector(3.0, 2.0, 1.0);
        FieldVector3D<Dfp> v = this.createVector(-4.0, 2.0, 2.0);
        FieldRotation r = new FieldRotation(u, v);
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(u.scalarMultiply(v.getNorm())), (FieldVector3D<Dfp>)v.scalarMultiply(u.getNorm()));
        this.checkAngle((Dfp)new FieldRotation(u, u.negate()).getAngle(), Math.PI);
        try {
            new FieldRotation(u, this.createVector(0.0, 0.0, 0.0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathRuntimeException mathRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testVectorTwoPairs() throws MathRuntimeException {
        FieldVector3D<Dfp> u1 = this.createVector(3.0, 0.0, 0.0);
        FieldVector3D<Dfp> u2 = this.createVector(0.0, 5.0, 0.0);
        FieldVector3D<Dfp> v1 = this.createVector(0.0, 0.0, 2.0);
        FieldVector3D<Dfp> v2 = this.createVector(-2.0, 0.0, 2.0);
        FieldRotation r = new FieldRotation(u1, u2, v1, v2);
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(-1.0, 0.0, 0.0));
        r = new FieldRotation(u1, u2, u1.negate(), u2.negate());
        FieldVector3D axis = r.getAxis(RotationConvention.VECTOR_OPERATOR);
        if (((Dfp)FieldVector3D.dotProduct((FieldVector3D)axis, this.createVector(0.0, 0.0, 1.0))).getReal() > 0.0) {
            this.checkVector((FieldVector3D<Dfp>)axis, this.createVector(0.0, 0.0, 1.0));
        } else {
            this.checkVector((FieldVector3D<Dfp>)axis, this.createVector(0.0, 0.0, -1.0));
        }
        this.checkAngle((Dfp)r.getAngle(), Math.PI);
        double sqrt = FastMath.sqrt((double)2.0) / 2.0;
        r = new FieldRotation(this.createVector(1.0, 0.0, 0.0), this.createVector(0.0, 1.0, 0.0), this.createVector(0.5, 0.5, sqrt), this.createVector(0.5, 0.5, -sqrt));
        this.checkRotationDS((FieldRotation<Dfp>)r, sqrt, 0.5, 0.5, 0.0);
        r = new FieldRotation(u1, u2, u1, FieldVector3D.crossProduct(u1, u2));
        this.checkRotationDS((FieldRotation<Dfp>)r, sqrt, -sqrt, 0.0, 0.0);
        this.checkRotationDS((FieldRotation<Dfp>)new FieldRotation(u1, u2, u1, u2), 1.0, 0.0, 0.0, 0.0);
        try {
            new FieldRotation(u1, u2, this.createVector(0.0, 0.0, 0.0), v2);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathRuntimeException mathRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testMatrix() throws MathIllegalArgumentException {
        try {
            this.createRotation(new double[][]{{0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}}, 1.0E-7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.createRotation(new double[][]{{0.445888, 0.797184, -0.40704}, {0.82176, -0.18432, 0.5392}, {-0.354816, 0.574912, 0.73728}}, 1.0E-7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.createRotation(new double[][]{{0.4, 0.8, -0.4}, {-0.4, 0.6, 0.7}, {0.8, -0.2, 0.5}}, 1.0E-15);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        this.checkRotationDS(this.createRotation(new double[][]{{0.445888, 0.797184, -0.40704}, {-0.354816, 0.574912, 0.73728}, {0.82176, -0.18432, 0.5392}}, 1.0E-10), 0.8, 0.288, 0.384, 0.36);
        this.checkRotationDS(this.createRotation(new double[][]{{0.5392, 0.73728, 0.40704}, {0.18432, -0.574912, 0.797184}, {0.82176, -0.354816, -0.445888}}, 1.0E-10), 0.36, 0.8, 0.288, 0.384);
        this.checkRotationDS(this.createRotation(new double[][]{{-0.445888, 0.797184, -0.40704}, {0.354816, 0.574912, 0.73728}, {0.82176, 0.18432, -0.5392}}, 1.0E-10), 0.384, 0.36, 0.8, 0.288);
        this.checkRotationDS(this.createRotation(new double[][]{{-0.5392, 0.73728, 0.40704}, {-0.18432, -0.574912, 0.797184}, {0.82176, 0.354816, 0.445888}}, 1.0E-10), 0.288, 0.384, 0.36, 0.8);
        double[][] m1 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}};
        FieldRotation<Dfp> r = this.createRotation(m1, 1.0E-7);
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), this.createVector(0.0, 0.0, 1.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), this.createVector(1.0, 0.0, 0.0));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), this.createVector(0.0, 1.0, 0.0));
        double[][] m2 = new double[][]{{0.83203, -0.55012, -0.07139}, {0.48293, 0.78164, -0.39474}, {0.27296, 0.29396, 0.91602}};
        r = this.createRotation(m2, 1.0E-12);
        Dfp[][] m3 = (Dfp[][])r.getMatrix();
        double d00 = m2[0][0] - m3[0][0].getReal();
        double d01 = m2[0][1] - m3[0][1].getReal();
        double d02 = m2[0][2] - m3[0][2].getReal();
        double d10 = m2[1][0] - m3[1][0].getReal();
        double d11 = m2[1][1] - m3[1][1].getReal();
        double d12 = m2[1][2] - m3[1][2].getReal();
        double d20 = m2[2][0] - m3[2][0].getReal();
        double d21 = m2[2][1] - m3[2][1].getReal();
        double d22 = m2[2][2] - m3[2][2].getReal();
        Assert.assertTrue((FastMath.abs((double)d00) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d01) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d02) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d10) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d11) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d12) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d20) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d21) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d22) < 6.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d00) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d01) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d02) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d10) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d11) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d12) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d20) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d21) > 4.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)d22) > 4.0E-7 ? 1 : 0) != 0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double m3tm3 = m3[i][0].getReal() * m3[j][0].getReal() + m3[i][1].getReal() * m3[j][1].getReal() + m3[i][2].getReal() * m3[j][2].getReal();
                if (i == j) {
                    Assert.assertTrue((FastMath.abs((double)(m3tm3 - 1.0)) < 1.0E-10 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((FastMath.abs((double)m3tm3) < 1.0E-10 ? 1 : 0) != 0);
            }
        }
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(1.0, 0.0, 0.0)), (FieldVector3D<Dfp>)new FieldVector3D((RealFieldElement)m3[0][0], (RealFieldElement)m3[1][0], (RealFieldElement)m3[2][0]));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 1.0, 0.0)), (FieldVector3D<Dfp>)new FieldVector3D((RealFieldElement)m3[0][1], (RealFieldElement)m3[1][1], (RealFieldElement)m3[2][1]));
        this.checkVector((FieldVector3D<Dfp>)r.applyTo(this.createVector(0.0, 0.0, 1.0)), (FieldVector3D<Dfp>)new FieldVector3D((RealFieldElement)m3[0][2], (RealFieldElement)m3[1][2], (RealFieldElement)m3[2][2]));
        double[][] m4 = new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, -1.0}};
        r = this.createRotation(m4, 1.0E-7);
        this.checkAngle((Dfp)r.getAngle(), Math.PI);
        try {
            double[][] m5 = new double[][]{{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}};
            r = this.createRotation(m5, 1.0E-7);
            Assert.fail((String)("got " + r + ", should have caught an exception"));
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Deprecated
    public void testAnglesDeprecated() throws MathIllegalStateException {
        DfpField field = new DfpField(15);
        RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
        for (int i = 0; i < CardanOrders.length; ++i) {
            for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 2.0) {
                for (double alpha2 = -1.55; alpha2 < 1.55; alpha2 += 0.8) {
                    for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 2.0) {
                        FieldRotation r = new FieldRotation(CardanOrders[i], (RealFieldElement)field.newDfp(alpha1), (RealFieldElement)field.newDfp(alpha2), (RealFieldElement)field.newDfp(alpha3));
                        Dfp[] angles = (Dfp[])r.getAngles(CardanOrders[i]);
                        this.checkAngle(angles[0], alpha1);
                        this.checkAngle(angles[1], alpha2);
                        this.checkAngle(angles[2], alpha3);
                    }
                }
            }
        }
        RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
        for (int i = 0; i < EulerOrders.length; ++i) {
            for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 2.0) {
                for (double alpha2 = 0.05; alpha2 < 3.1; alpha2 += 0.8) {
                    for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 2.0) {
                        FieldRotation r = new FieldRotation(EulerOrders[i], (RealFieldElement)field.newDfp(alpha1), (RealFieldElement)field.newDfp(alpha2), (RealFieldElement)field.newDfp(alpha3));
                        Dfp[] angles = (Dfp[])r.getAngles(EulerOrders[i]);
                        this.checkAngle(angles[0], alpha1);
                        this.checkAngle(angles[1], alpha2);
                        this.checkAngle(angles[2], alpha3);
                    }
                }
            }
        }
    }

    @Test
    public void testAngles() throws MathIllegalStateException {
        DfpField field = new DfpField(15);
        for (RotationConvention convention : RotationConvention.values()) {
            RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
            for (int i = 0; i < CardanOrders.length; ++i) {
                for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 2.0) {
                    for (double alpha2 = -1.55; alpha2 < 1.55; alpha2 += 0.8) {
                        for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 2.0) {
                            FieldRotation r = new FieldRotation(CardanOrders[i], convention, (RealFieldElement)field.newDfp(alpha1), (RealFieldElement)field.newDfp(alpha2), (RealFieldElement)field.newDfp(alpha3));
                            Dfp[] angles = (Dfp[])r.getAngles(CardanOrders[i], convention);
                            this.checkAngle(angles[0], alpha1);
                            this.checkAngle(angles[1], alpha2);
                            this.checkAngle(angles[2], alpha3);
                        }
                    }
                }
            }
            RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
            for (int i = 0; i < EulerOrders.length; ++i) {
                for (double alpha1 = 0.1; alpha1 < 6.2; alpha1 += 2.0) {
                    for (double alpha2 = 0.05; alpha2 < 3.1; alpha2 += 0.8) {
                        for (double alpha3 = 0.1; alpha3 < 6.2; alpha3 += 2.0) {
                            FieldRotation r = new FieldRotation(EulerOrders[i], convention, (RealFieldElement)field.newDfp(alpha1), (RealFieldElement)field.newDfp(alpha2), (RealFieldElement)field.newDfp(alpha3));
                            Dfp[] angles = (Dfp[])r.getAngles(EulerOrders[i], convention);
                            this.checkAngle(angles[0], alpha1);
                            this.checkAngle(angles[1], alpha2);
                            this.checkAngle(angles[2], alpha3);
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testSingularities() {
        DfpField field = new DfpField(20);
        for (RotationConvention convention : RotationConvention.values()) {
            RotationOrder[] CardanOrders = new RotationOrder[]{RotationOrder.XYZ, RotationOrder.XZY, RotationOrder.YXZ, RotationOrder.YZX, RotationOrder.ZXY, RotationOrder.ZYX};
            double[] singularCardanAngle = new double[]{1.5707963267948966, -1.5707963267948966};
            for (int i = 0; i < CardanOrders.length; ++i) {
                for (int j = 0; j < singularCardanAngle.length; ++j) {
                    FieldRotation r = new FieldRotation(CardanOrders[i], convention, (RealFieldElement)field.newDfp(0.1), (RealFieldElement)field.newDfp(singularCardanAngle[j]), (RealFieldElement)field.newDfp(0.3));
                    try {
                        r.getAngles(CardanOrders[i], convention);
                        Assert.fail((String)"an exception should have been caught");
                        continue;
                    }
                    catch (MathIllegalStateException cese) {
                        Assert.assertEquals((Object)LocalizedGeometryFormats.CARDAN_ANGLES_SINGULARITY, (Object)cese.getSpecifier());
                    }
                }
            }
            RotationOrder[] EulerOrders = new RotationOrder[]{RotationOrder.XYX, RotationOrder.XZX, RotationOrder.YXY, RotationOrder.YZY, RotationOrder.ZXZ, RotationOrder.ZYZ};
            double[] singularEulerAngle = new double[]{0.0, Math.PI};
            for (int i = 0; i < EulerOrders.length; ++i) {
                for (int j = 0; j < singularEulerAngle.length; ++j) {
                    FieldRotation r = new FieldRotation(EulerOrders[i], convention, (RealFieldElement)field.newDfp(0.1), (RealFieldElement)field.newDfp(singularEulerAngle[j]), (RealFieldElement)field.newDfp(0.3));
                    try {
                        r.getAngles(EulerOrders[i], convention);
                        Assert.fail((String)"an exception should have been caught");
                        continue;
                    }
                    catch (MathIllegalStateException cese) {
                        Assert.assertEquals((Object)LocalizedGeometryFormats.EULER_ANGLES_SINGULARITY, (Object)cese.getSpecifier());
                    }
                }
            }
        }
    }

    @Test
    public void testQuaternion() throws MathIllegalArgumentException {
        FieldRotation<Dfp> r1 = new FieldRotation<Dfp>(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        double n = 23.5;
        FieldRotation r2 = new FieldRotation((RealFieldElement)((Dfp)r1.getQ0()).multiply(n), (RealFieldElement)((Dfp)r1.getQ1()).multiply(n), (RealFieldElement)((Dfp)r1.getQ2()).multiply(n), (RealFieldElement)((Dfp)r1.getQ3()).multiply(n), true);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<Dfp> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<Dfp>)r2.applyTo(u), (FieldVector3D<Dfp>)r1.applyTo(u));
                }
            }
        }
        r1 = this.createRotation(0.288, 0.384, 0.36, 0.8, false);
        this.checkRotationDS(r1, -((Dfp)r1.getQ0()).getReal(), -((Dfp)r1.getQ1()).getReal(), -((Dfp)r1.getQ2()).getReal(), -((Dfp)r1.getQ3()).getReal());
    }

    @Test
    public void testApplyToRotation() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3 = r2.applyTo(r1);
        FieldRotation r3Double = r2.applyTo(new Rotation(((Dfp)r1.getQ0()).getReal(), ((Dfp)r1.getQ1()).getReal(), ((Dfp)r1.getQ2()).getReal(), ((Dfp)r1.getQ3()).getReal(), false));
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<Dfp> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<Dfp>)r2.applyTo(r1.applyTo(u)), (FieldVector3D<Dfp>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<Dfp>)r2.applyTo(r1.applyTo(u)), (FieldVector3D<Dfp>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeVectorOperator() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3 = r2.compose(r1, RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3Double = r2.compose(new Rotation(((Dfp)r1.getQ0()).getReal(), ((Dfp)r1.getQ1()).getReal(), ((Dfp)r1.getQ2()).getReal(), ((Dfp)r1.getQ3()).getReal(), false), RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<Dfp> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<Dfp>)r2.applyTo(r1.applyTo(u)), (FieldVector3D<Dfp>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<Dfp>)r2.applyTo(r1.applyTo(u)), (FieldVector3D<Dfp>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeFrameTransform() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r3 = r2.compose(r1, RotationConvention.FRAME_TRANSFORM);
        FieldRotation r3Double = r2.compose(new Rotation(((Dfp)r1.getQ0()).getReal(), ((Dfp)r1.getQ1()).getReal(), ((Dfp)r1.getQ2()).getReal(), ((Dfp)r1.getQ3()).getReal(), false), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r4 = r1.compose(r2, RotationConvention.VECTOR_OPERATOR);
        Assert.assertEquals((double)0.0, (double)((Dfp)FieldRotation.distance((FieldRotation)r3, (FieldRotation)r4)).getReal(), (double)1.0E-15);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<Dfp> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<Dfp>)r1.applyTo(r2.applyTo(u)), (FieldVector3D<Dfp>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<Dfp>)r1.applyTo(r2.applyTo(u)), (FieldVector3D<Dfp>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testApplyInverseToRotation() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3 = r2.applyInverseTo(r1);
        FieldRotation r3Double = r2.applyInverseTo(new Rotation(((Dfp)r1.getQ0()).getReal(), ((Dfp)r1.getQ1()).getReal(), ((Dfp)r1.getQ2()).getReal(), ((Dfp)r1.getQ3()).getReal(), false));
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<Dfp> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<Dfp>)r2.applyInverseTo(r1.applyTo(u)), (FieldVector3D<Dfp>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<Dfp>)r2.applyInverseTo(r1.applyTo(u)), (FieldVector3D<Dfp>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeInverseVectorOperator() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3 = r2.composeInverse(r1, RotationConvention.VECTOR_OPERATOR);
        FieldRotation r3Double = r2.composeInverse(new Rotation(((Dfp)r1.getQ0()).getReal(), ((Dfp)r1.getQ1()).getReal(), ((Dfp)r1.getQ2()).getReal(), ((Dfp)r1.getQ3()).getReal(), false), RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<Dfp> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<Dfp>)r2.applyInverseTo(r1.applyTo(u)), (FieldVector3D<Dfp>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<Dfp>)r2.applyInverseTo(r1.applyTo(u)), (FieldVector3D<Dfp>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testComposeInverseFrameTransform() throws MathIllegalArgumentException {
        FieldRotation r1 = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r2 = new FieldRotation(this.createVector(-1.0, 3.0, 2.0), (RealFieldElement)this.createAngle(0.3), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r3 = r2.composeInverse(r1, RotationConvention.FRAME_TRANSFORM);
        FieldRotation r3Double = r2.composeInverse(new Rotation(((Dfp)r1.getQ0()).getReal(), ((Dfp)r1.getQ1()).getReal(), ((Dfp)r1.getQ2()).getReal(), ((Dfp)r1.getQ3()).getReal(), false), RotationConvention.FRAME_TRANSFORM);
        FieldRotation r4 = r1.revert().composeInverse(r2.revert(), RotationConvention.VECTOR_OPERATOR);
        Assert.assertEquals((double)0.0, (double)((Dfp)FieldRotation.distance((FieldRotation)r3, (FieldRotation)r4)).getReal(), (double)1.0E-15);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<Dfp> u = this.createVector(x, y, z);
                    this.checkVector((FieldVector3D<Dfp>)r1.applyTo(r2.applyInverseTo(u)), (FieldVector3D<Dfp>)r3.applyTo(u));
                    this.checkVector((FieldVector3D<Dfp>)r1.applyTo(r2.applyInverseTo(u)), (FieldVector3D<Dfp>)r3Double.applyTo(u));
                }
            }
        }
    }

    @Test
    public void testDoubleVectors() throws MathIllegalArgumentException {
        Well1024a random = new Well1024a(1732550842977857383L);
        UnitSphereRandomVectorGenerator g = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)random);
        for (int i = 0; i < 10; ++i) {
            double[] unit = g.nextVector();
            FieldRotation r = new FieldRotation(this.createVector(unit[0], unit[1], unit[2]), (RealFieldElement)this.createAngle(random.nextDouble()), RotationConvention.VECTOR_OPERATOR);
            for (double x = -0.9; x < 0.9; x += 0.4) {
                for (double y = -0.9; y < 0.9; y += 0.4) {
                    for (double z = -0.9; z < 0.9; z += 0.4) {
                        FieldVector3D<Dfp> uds = this.createVector(x, y, z);
                        FieldVector3D ruds = r.applyTo(uds);
                        FieldVector3D rIuds = r.applyInverseTo(uds);
                        Vector3D u = new Vector3D(x, y, z);
                        FieldVector3D ru = r.applyTo(u);
                        FieldVector3D rIu = r.applyInverseTo(u);
                        Dfp[] ruArray = new Dfp[3];
                        r.applyTo(new double[]{x, y, z}, (RealFieldElement[])ruArray);
                        Dfp[] rIuArray = new Dfp[3];
                        r.applyInverseTo(new double[]{x, y, z}, (RealFieldElement[])rIuArray);
                        this.checkVector((FieldVector3D<Dfp>)ruds, (FieldVector3D<Dfp>)ru);
                        this.checkVector((FieldVector3D<Dfp>)ruds, (FieldVector3D<Dfp>)new FieldVector3D((RealFieldElement[])ruArray));
                        this.checkVector((FieldVector3D<Dfp>)rIuds, (FieldVector3D<Dfp>)rIu);
                        this.checkVector((FieldVector3D<Dfp>)rIuds, (FieldVector3D<Dfp>)new FieldVector3D((RealFieldElement[])rIuArray));
                    }
                }
            }
        }
    }

    @Test
    public void testDoubleRotations() throws MathIllegalArgumentException {
        DfpField field = new DfpField(20);
        Well1024a random = new Well1024a(1732550842977857383L);
        UnitSphereRandomVectorGenerator g = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)random);
        for (int i = 0; i < 10; ++i) {
            double[] unit1 = g.nextVector();
            Rotation r1 = new Rotation(new Vector3D(unit1[0], unit1[1], unit1[2]), random.nextDouble(), RotationConvention.VECTOR_OPERATOR);
            FieldRotation r1Prime = new FieldRotation((RealFieldElement)field.newDfp(r1.getQ0()), (RealFieldElement)field.newDfp(r1.getQ1()), (RealFieldElement)field.newDfp(r1.getQ2()), (RealFieldElement)field.newDfp(r1.getQ3()), false);
            double[] unit2 = g.nextVector();
            FieldRotation r2 = new FieldRotation(this.createVector(unit2[0], unit2[1], unit2[2]), (RealFieldElement)this.createAngle(random.nextDouble()), RotationConvention.VECTOR_OPERATOR);
            FieldRotation rA = FieldRotation.applyTo((Rotation)r1, (FieldRotation)r2);
            FieldRotation rB = r1Prime.compose(r2, RotationConvention.VECTOR_OPERATOR);
            FieldRotation rC = FieldRotation.applyInverseTo((Rotation)r1, (FieldRotation)r2);
            FieldRotation rD = r1Prime.composeInverse(r2, RotationConvention.VECTOR_OPERATOR);
            for (double x = -0.9; x < 0.9; x += 0.4) {
                for (double y = -0.9; y < 0.9; y += 0.4) {
                    for (double z = -0.9; z < 0.9; z += 0.4) {
                        FieldVector3D<Dfp> uds = this.createVector(x, y, z);
                        this.checkVector((FieldVector3D<Dfp>)r1Prime.applyTo(uds), (FieldVector3D<Dfp>)FieldRotation.applyTo((Rotation)r1, uds));
                        this.checkVector((FieldVector3D<Dfp>)r1Prime.applyInverseTo(uds), (FieldVector3D<Dfp>)FieldRotation.applyInverseTo((Rotation)r1, uds));
                        this.checkVector((FieldVector3D<Dfp>)rA.applyTo(uds), (FieldVector3D<Dfp>)rB.applyTo(uds));
                        this.checkVector((FieldVector3D<Dfp>)rA.applyInverseTo(uds), (FieldVector3D<Dfp>)rB.applyInverseTo(uds));
                        this.checkVector((FieldVector3D<Dfp>)rC.applyTo(uds), (FieldVector3D<Dfp>)rD.applyTo(uds));
                        this.checkVector((FieldVector3D<Dfp>)rC.applyInverseTo(uds), (FieldVector3D<Dfp>)rD.applyInverseTo(uds));
                    }
                }
            }
        }
    }

    @Test
    public void testArray() throws MathIllegalArgumentException {
        FieldRotation r = new FieldRotation(this.createAxis(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        for (double x = -0.9; x < 0.9; x += 0.2) {
            for (double y = -0.9; y < 0.9; y += 0.2) {
                for (double z = -0.9; z < 0.9; z += 0.2) {
                    FieldVector3D<Dfp> u = this.createVector(x, y, z);
                    FieldVector3D v = r.applyTo(u);
                    Dfp[] out = new Dfp[3];
                    r.applyTo((RealFieldElement[])new Dfp[]{(Dfp)u.getX(), (Dfp)u.getY(), (Dfp)u.getZ()}, (RealFieldElement[])out);
                    Assert.assertEquals((double)((Dfp)v.getX()).getReal(), (double)out[0].getReal(), (double)1.0E-10);
                    Assert.assertEquals((double)((Dfp)v.getY()).getReal(), (double)out[1].getReal(), (double)1.0E-10);
                    Assert.assertEquals((double)((Dfp)v.getZ()).getReal(), (double)out[2].getReal(), (double)1.0E-10);
                    r.applyInverseTo((RealFieldElement[])out, (RealFieldElement[])out);
                    Assert.assertEquals((double)((Dfp)u.getX()).getReal(), (double)out[0].getReal(), (double)1.0E-10);
                    Assert.assertEquals((double)((Dfp)u.getY()).getReal(), (double)out[1].getReal(), (double)1.0E-10);
                    Assert.assertEquals((double)((Dfp)u.getZ()).getReal(), (double)out[2].getReal(), (double)1.0E-10);
                }
            }
        }
    }

    @Test
    public void testApplyInverseTo() throws MathIllegalArgumentException {
        FieldVector3D<Dfp> u;
        double phi;
        double lambda;
        Dfp[] in = new Dfp[3];
        Dfp[] out = new Dfp[3];
        Dfp[] rebuilt = new Dfp[3];
        FieldRotation r = new FieldRotation(this.createVector(2.0, -3.0, 5.0), (RealFieldElement)this.createAngle(1.7), RotationConvention.VECTOR_OPERATOR);
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = this.createVector(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                r.applyInverseTo(r.applyTo(u));
                this.checkVector(u, (FieldVector3D<Dfp>)r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, (FieldVector3D<Dfp>)r.applyTo(r.applyInverseTo(u)));
                in[0] = (Dfp)u.getX();
                in[1] = (Dfp)u.getY();
                in[2] = (Dfp)u.getZ();
                r.applyTo((RealFieldElement[])in, (RealFieldElement[])out);
                r.applyInverseTo((RealFieldElement[])out, (RealFieldElement[])rebuilt);
                Assert.assertEquals((double)in[0].getReal(), (double)rebuilt[0].getReal(), (double)1.0E-12);
                Assert.assertEquals((double)in[1].getReal(), (double)rebuilt[1].getReal(), (double)1.0E-12);
                Assert.assertEquals((double)in[2].getReal(), (double)rebuilt[2].getReal(), (double)1.0E-12);
            }
        }
        r = this.createRotation(1.0, 0.0, 0.0, 0.0, false);
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = this.createVector(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                this.checkVector(u, (FieldVector3D<Dfp>)r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, (FieldVector3D<Dfp>)r.applyTo(r.applyInverseTo(u)));
            }
        }
        r = new FieldRotation(this.createVector(0.0, 0.0, 1.0), (RealFieldElement)this.createAngle(Math.PI), RotationConvention.VECTOR_OPERATOR);
        for (lambda = 0.0; lambda < 6.2; lambda += 0.2) {
            for (phi = -1.55; phi < 1.55; phi += 0.2) {
                u = this.createVector(FastMath.cos((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)lambda) * FastMath.cos((double)phi), FastMath.sin((double)phi));
                this.checkVector(u, (FieldVector3D<Dfp>)r.applyInverseTo(r.applyTo(u)));
                this.checkVector(u, (FieldVector3D<Dfp>)r.applyTo(r.applyInverseTo(u)));
            }
        }
    }

    @Test
    public void testIssue639() throws MathRuntimeException {
        FieldVector3D<Dfp> u1 = this.createVector(-4921140.837095533, -2.1512094250440013E7, -890093.279426377);
        FieldVector3D<Dfp> u2 = this.createVector(-2.7238580938724895E9, -2.169664921341876E9, 6.749688708885301E10);
        FieldRotation rot = new FieldRotation(u1, u2, this.createVector(1.0, 0.0, 0.0), this.createVector(0.0, 0.0, 1.0));
        Assert.assertEquals((double)0.6228370359608201, (double)((Dfp)rot.getQ0()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)0.02577076214564988, (double)((Dfp)rot.getQ1()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-2.503012255839931E-10, (double)((Dfp)rot.getQ2()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-0.7819270390861109, (double)((Dfp)rot.getQ3()).getReal(), (double)1.0E-15);
    }

    @Test
    public void testIssue801() throws MathRuntimeException {
        FieldVector3D<Dfp> u1 = this.createVector(0.9999988431610581, -0.0015210774290851095, 0.0);
        FieldVector3D<Dfp> u2 = this.createVector(0.0, 0.0, 1.0);
        FieldVector3D<Dfp> v1 = this.createVector(0.9999999999999999, 0.0, 0.0);
        FieldVector3D<Dfp> v2 = this.createVector(0.0, 0.0, -1.0);
        FieldRotation quat = new FieldRotation(u1, u2, v1, v2);
        double q2 = ((Dfp)quat.getQ0()).getReal() * ((Dfp)quat.getQ0()).getReal() + ((Dfp)quat.getQ1()).getReal() * ((Dfp)quat.getQ1()).getReal() + ((Dfp)quat.getQ2()).getReal() * ((Dfp)quat.getQ2()).getReal() + ((Dfp)quat.getQ3()).getReal() * ((Dfp)quat.getQ3()).getReal();
        Assert.assertEquals((double)1.0, (double)q2, (double)1.0E-14);
        Assert.assertEquals((double)0.0, (double)((Dfp)FieldVector3D.angle(v1, (FieldVector3D)quat.applyTo(u1))).getReal(), (double)1.0E-14);
        Assert.assertEquals((double)0.0, (double)((Dfp)FieldVector3D.angle(v2, (FieldVector3D)quat.applyTo(u2))).getReal(), (double)1.0E-14);
    }

    private void checkAngle(Dfp a1, double a2) {
        Assert.assertEquals((double)a1.getReal(), (double)MathUtils.normalizeAngle((double)a2, (double)a1.getReal()), (double)1.0E-10);
    }

    private void checkRotationDS(FieldRotation<Dfp> r, double q0, double q1, double q2, double q3) {
        FieldRotation<Dfp> rPrime = this.createRotation(q0, q1, q2, q3, false);
        Assert.assertEquals((double)0.0, (double)((Dfp)FieldRotation.distance(r, rPrime)).getReal(), (double)1.0E-12);
    }

    private FieldRotation<Dfp> createRotation(double q0, double q1, double q2, double q3, boolean needsNormalization) {
        DfpField field = new DfpField(20);
        return new FieldRotation((RealFieldElement)field.newDfp(q0), (RealFieldElement)field.newDfp(q1), (RealFieldElement)field.newDfp(q2), (RealFieldElement)field.newDfp(q3), needsNormalization);
    }

    private FieldRotation<Dfp> createRotation(double[][] m, double threshold) {
        DfpField field = new DfpField(20);
        Dfp[][] mds = new Dfp[m.length][m[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                mds[i][j] = field.newDfp(m[i][j]);
            }
        }
        return new FieldRotation((RealFieldElement[][])mds, threshold);
    }

    private FieldVector3D<Dfp> createVector(double x, double y, double z) {
        DfpField field = new DfpField(20);
        return new FieldVector3D((RealFieldElement)field.newDfp(x), (RealFieldElement)field.newDfp(y), (RealFieldElement)field.newDfp(z));
    }

    private FieldVector3D<Dfp> createAxis(double x, double y, double z) {
        DfpField field = new DfpField(20);
        return new FieldVector3D((RealFieldElement)field.newDfp(x), (RealFieldElement)field.newDfp(y), (RealFieldElement)field.newDfp(z));
    }

    private Dfp createAngle(double alpha) {
        return new DfpField(20).newDfp(alpha);
    }

    private void checkVector(FieldVector3D<Dfp> u, FieldVector3D<Dfp> v) {
        Assert.assertEquals((double)((Dfp)u.getX()).getReal(), (double)((Dfp)v.getX()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)((Dfp)u.getY()).getReal(), (double)((Dfp)v.getY()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)((Dfp)u.getZ()).getReal(), (double)((Dfp)v.getZ()).getReal(), (double)1.0E-12);
    }
}

