/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.euclidean.twod.DiskGenerator;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.UnitSphereRandomVectorGenerator;
import org.hipparchus.random.Well1024a;
import org.junit.Assert;
import org.junit.Test;

public class DiskGeneratorTest {
    @Test
    public void testSupport0Point() {
        List<Vector2D> support = Arrays.asList(new Vector2D[0]);
        EnclosingBall disk = new DiskGenerator().ballOnSupport(support);
        Assert.assertTrue((disk.getRadius() < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)disk.getSupportSize());
        Assert.assertEquals((long)0L, (long)((Vector2D[])disk.getSupport()).length);
    }

    @Test
    public void testSupport1Point() {
        List<Vector2D> support = Arrays.asList(new Vector2D(1.0, 2.0));
        EnclosingBall disk = new DiskGenerator().ballOnSupport(support);
        Assert.assertEquals((double)0.0, (double)disk.getRadius(), (double)1.0E-10);
        Assert.assertTrue((boolean)disk.contains((Point)support.get(0)));
        Assert.assertTrue((boolean)disk.contains((Point)support.get(0), 0.5));
        Assert.assertFalse((boolean)disk.contains((Point)new Vector2D(support.get(0).getX() + 0.1, support.get(0).getY() - 0.1), 0.001));
        Assert.assertTrue((boolean)disk.contains((Point)new Vector2D(support.get(0).getX() + 0.1, support.get(0).getY() - 0.1), 0.5));
        Assert.assertEquals((double)0.0, (double)support.get(0).distance(disk.getCenter()), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)disk.getSupportSize());
        Assert.assertTrue((support.get(0) == ((Vector2D[])disk.getSupport())[0] ? 1 : 0) != 0);
    }

    @Test
    public void testSupport2Points() {
        List<Vector2D> support = Arrays.asList(new Vector2D(1.0, 0.0), new Vector2D(3.0, 0.0));
        EnclosingBall disk = new DiskGenerator().ballOnSupport(support);
        Assert.assertEquals((double)1.0, (double)disk.getRadius(), (double)1.0E-10);
        int i = 0;
        for (Vector2D v : support) {
            Assert.assertTrue((boolean)disk.contains((Point)v));
            Assert.assertEquals((double)1.0, (double)v.distance(disk.getCenter()), (double)1.0E-10);
            Assert.assertTrue((v == ((Vector2D[])disk.getSupport())[i++] ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)disk.contains((Point)new Vector2D(2.0, 0.9)));
        Assert.assertFalse((boolean)disk.contains((Point)Vector2D.ZERO));
        Assert.assertEquals((double)0.0, (double)new Vector2D(2.0, 0.0).distance(disk.getCenter()), (double)1.0E-10);
        Assert.assertEquals((long)2L, (long)disk.getSupportSize());
    }

    @Test
    public void testSupport3Points() {
        List<Vector2D> support = Arrays.asList(new Vector2D(1.0, 0.0), new Vector2D(3.0, 0.0), new Vector2D(2.0, 2.0));
        EnclosingBall disk = new DiskGenerator().ballOnSupport(support);
        Assert.assertEquals((double)1.25, (double)disk.getRadius(), (double)1.0E-10);
        int i = 0;
        for (Vector2D v : support) {
            Assert.assertTrue((boolean)disk.contains((Point)v));
            Assert.assertEquals((double)1.25, (double)v.distance(disk.getCenter()), (double)1.0E-10);
            Assert.assertTrue((v == ((Vector2D[])disk.getSupport())[i++] ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)disk.contains((Point)new Vector2D(2.0, 0.9)));
        Assert.assertFalse((boolean)disk.contains((Point)new Vector2D(0.9, 0.0)));
        Assert.assertFalse((boolean)disk.contains((Point)new Vector2D(3.1, 0.0)));
        Assert.assertTrue((boolean)disk.contains((Point)new Vector2D(2.0, -0.499)));
        Assert.assertFalse((boolean)disk.contains((Point)new Vector2D(2.0, -0.501)));
        Assert.assertEquals((double)0.0, (double)new Vector2D(2.0, 0.75).distance(disk.getCenter()), (double)1.0E-10);
        Assert.assertEquals((long)3L, (long)disk.getSupportSize());
    }

    @Test
    public void testRandom() {
        Well1024a random = new Well1024a(1367590258819989136L);
        UnitSphereRandomVectorGenerator sr = new UnitSphereRandomVectorGenerator(2, (RandomGenerator)random);
        for (int i = 0; i < 500; ++i) {
            double d = 25.0 * random.nextDouble();
            double refRadius = 10.0 * random.nextDouble();
            Vector2D refCenter = new Vector2D(d, new Vector2D(sr.nextVector()));
            ArrayList<Vector2D> support = new ArrayList<Vector2D>();
            for (int j = 0; j < 3; ++j) {
                support.add(new Vector2D(1.0, refCenter, refRadius, new Vector2D(sr.nextVector())));
            }
            EnclosingBall disk = new DiskGenerator().ballOnSupport(support);
            Assert.assertEquals((double)0.0, (double)refCenter.distance(disk.getCenter()), (double)(3.0E-9 * refRadius));
            Assert.assertEquals((double)refRadius, (double)disk.getRadius(), (double)(7.0E-10 * refRadius));
        }
    }
}

