/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import org.hipparchus.geometry.euclidean.twod.Line;
import org.hipparchus.geometry.euclidean.twod.Segment;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class SegmentTest {
    @Test
    public void testDistance() {
        Vector2D start = new Vector2D(2.0, 2.0);
        Vector2D end = new Vector2D(-2.0, -2.0);
        Segment segment = new Segment(start, end, new Line(start, end, 1.0E-10));
        Assert.assertEquals((double)FastMath.sqrt((double)2.0), (double)segment.distance(new Vector2D(1.0, -1.0)), (double)1.0E-10);
        Assert.assertEquals((double)FastMath.sin((double)0.7853981633974483), (double)segment.distance(new Vector2D(0.0, -1.0)), (double)1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)8.0), (double)segment.distance(new Vector2D(0.0, 4.0)), (double)1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)8.0), (double)segment.distance(new Vector2D(0.0, -4.0)), (double)1.0E-10);
    }
}

